/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.integration.quark;

import java.util.ArrayList;
import java.util.List;
import net.mehvahdjukaar.supplementaries.common.block.tiles.SafeBlockTile;
import net.mehvahdjukaar.supplementaries.setup.ModRegistry;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import vazkii.quark.base.module.ModuleLoader;
import vazkii.quark.content.client.module.ImprovedTooltipsModule;
import vazkii.quark.content.management.module.ExpandedItemInteractionsModule;

public class QuarkTooltipPlugin {
    private static final BlockState DEFAULT_SAFE = ((Block)ModRegistry.SAFE.get()).m_49966_();
    private static final SafeBlockTile DUMMY_SAFE_TILE = new SafeBlockTile(BlockPos.f_121853_, DEFAULT_SAFE);

    public static boolean canRenderTooltip() {
        return ModuleLoader.INSTANCE.isModuleEnabled(ExpandedItemInteractionsModule.class) && (!ImprovedTooltipsModule.shulkerBoxRequireShift || Screen.m_96638_());
    }

    public static void onItemTooltipEvent(ItemTooltipEvent event) {
        ItemStack stack;
        CompoundTag cmp;
        if (QuarkTooltipPlugin.canRenderTooltip() && (cmp = (stack = event.getItemStack()).m_41737_("BlockEntityTag")) != null && !cmp.m_128441_("LootTable")) {
            Item i = stack.m_41720_();
            if (i == ModRegistry.SAFE_ITEM.get()) {
                DUMMY_SAFE_TILE.m_142466_(cmp);
                LocalPlayer player = Minecraft.m_91087_().f_91074_;
                if (player == null || DUMMY_SAFE_TILE.canPlayerOpen((Player)Minecraft.m_91087_().f_91074_, false)) {
                    QuarkTooltipPlugin.cleanupTooltip(event.getToolTip());
                }
            } else if (i == ModRegistry.SACK_ITEM.get()) {
                QuarkTooltipPlugin.cleanupTooltip(event.getToolTip());
            }
        }
    }

    private static void cleanupTooltip(List<Component> tooltip) {
        ArrayList<Component> tooltipCopy = new ArrayList<Component>(tooltip);
        for (int i = 1; i < tooltipCopy.size(); ++i) {
            Component component = tooltipCopy.get(i);
            String s = component.getString();
            if (s.startsWith("\u00c2\u00a7") && !s.startsWith("\u00c2\u00a7o")) continue;
            tooltip.remove(component);
        }
        if (ImprovedTooltipsModule.shulkerBoxRequireShift && !Screen.m_96638_()) {
            tooltip.add(1, (Component)new TranslatableComponent("quark.misc.shulker_box_shift"));
        }
    }
}

