/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.selene.map;

import java.util.function.BiConsumer;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.data.models.blockstates.PropertyDispatch;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.saveddata.maps.MapItemSavedData;

public record CustomDataHolder<T>(String id, Function<CompoundTag, T> load, BiConsumer<CompoundTag, T> save, PropertyDispatch.TriFunction<MapItemSavedData, Entity, T, Boolean> onItemUpdate, PropertyDispatch.TriFunction<MapItemSavedData, ItemStack, T, Component> onItemTooltip) {
    @Nullable
    public Instance<T> create(CompoundTag tag) {
        T v = this.load.apply(tag);
        if (v == null) {
            return null;
        }
        return new Instance<T>(v, this);
    }

    @Nullable
    public Instance<T> createFromBuffer(FriendlyByteBuf buffer) {
        return this.create(buffer.m_130260_());
    }

    public static class Instance<T> {
        private T object;
        private final CustomDataHolder<T> type;

        private Instance(T value, @Nonnull CustomDataHolder<T> type) {
            this.object = value;
            this.type = type;
        }

        public CustomDataHolder<T> getType() {
            return this.type;
        }

        public void save(CompoundTag tag) {
            this.type.save.accept(tag, (CompoundTag)this.object);
        }

        public boolean onUpdate(MapItemSavedData data, Entity entity) {
            return (Boolean)this.type.onItemUpdate.m_125475_((Object)data, (Object)entity, this.object);
        }

        @Nullable
        public Component getTooltip(MapItemSavedData data, ItemStack stack) {
            return (Component)this.type.onItemTooltip.m_125475_((Object)data, (Object)stack, this.object);
        }

        public void set(T value) {
            this.object = value;
        }

        public void saveToBuffer(FriendlyByteBuf buffer) {
            CompoundTag tag = new CompoundTag();
            this.save(tag);
            buffer.m_130079_(tag);
        }
    }
}

