/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.selene.resourcepack;

import com.google.gson.JsonElement;
import com.mojang.blaze3d.platform.NativeImage;
import java.io.ByteArrayInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.mehvahdjukaar.selene.resourcepack.AssetGenerators;
import net.mehvahdjukaar.selene.resourcepack.RPUtils;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackResources;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.metadata.MetadataSectionSerializer;
import net.minecraft.server.packs.metadata.pack.PackMetadataSection;
import net.minecraft.server.packs.metadata.pack.PackMetadataSectionSerializer;
import net.minecraft.server.packs.repository.Pack;
import net.minecraft.server.packs.repository.PackCompatibility;
import net.minecraft.server.packs.repository.PackSource;
import net.minecraftforge.event.AddPackFindersEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public abstract class DynamicResourcePack
implements PackResources {
    protected static final Logger LOGGER = LogManager.getLogger();
    public static final List<ResourceLocation> NO_RESOURCES = Collections.emptyList();
    protected final boolean hidden;
    protected final boolean fixed;
    protected final Pack.Position position;
    protected final PackType packType;
    protected final PackMetadataSection packInfo;
    protected final Component title;
    protected final ResourceLocation resourcePackName;
    private final Set<String> namespaces = new HashSet<String>();
    private final Map<ResourceLocation, byte[]> resources = new HashMap<ResourceLocation, byte[]>();
    public boolean generateDebugResources = false;

    public DynamicResourcePack(ResourceLocation name, PackType type) {
        this(name, type, Pack.Position.TOP, false, false);
    }

    public DynamicResourcePack(ResourceLocation name, PackType type, Pack.Position position, boolean fixed, boolean hidden) {
        this.packType = type;
        TextComponent component = new TextComponent(AssetGenerators.LangBuilder.getReadableName(name.m_135827_() + "_dynamic_resources"));
        this.packInfo = new PackMetadataSection((Component)component, 6);
        this.resourcePackName = name;
        this.namespaces.add(name.m_135827_());
        this.title = new TextComponent(AssetGenerators.LangBuilder.getReadableName(name.toString()));
        this.position = position;
        this.fixed = fixed;
        this.hidden = hidden;
    }

    public void addNamespaces(String ... namespaces) {
        this.namespaces.addAll(Arrays.asList(namespaces));
    }

    public Component getTitle() {
        return this.title;
    }

    public String m_8017_() {
        return this.title.getString();
    }

    public void registerPack(IEventBus bus) {
        bus.addListener(this::register);
    }

    public void register(AddPackFindersEvent event) {
        if (event.getPackType() == this.packType) {
            event.addRepositorySource((infoConsumer, packFactory) -> infoConsumer.accept(new Pack(this.m_8017_(), true, () -> this, this.getTitle(), this.packInfo.m_10373_(), PackCompatibility.COMPATIBLE, Pack.Position.TOP, this.fixed, PackSource.f_10527_, this.hidden)));
        }
    }

    public Set<String> m_5698_(PackType packType) {
        return this.namespaces;
    }

    public <T> T m_5550_(MetadataSectionSerializer<T> serializer) {
        return (T)(serializer instanceof PackMetadataSectionSerializer ? this.packInfo : null);
    }

    @Nullable
    public InputStream m_5542_(String p_10294_) {
        return null;
    }

    public Collection<ResourceLocation> m_7466_(PackType packType, String namespace, String id, int maxDepth, Predicate<String> filter) {
        if (packType == this.packType && packType == PackType.SERVER_DATA && this.namespaces.contains(namespace)) {
            return this.resources.keySet().stream().filter(r -> r.m_135827_().equals(namespace) && r.m_135815_().startsWith(id)).filter(r -> filter.test(r.toString())).collect(Collectors.toList());
        }
        return NO_RESOURCES;
    }

    public InputStream m_8031_(PackType type, ResourceLocation id) throws IOException {
        if (type != this.packType) {
            throw new IOException(String.format("Tried to access wrong type of resource on %s.", this.resourcePackName));
        }
        if (this.resources.containsKey(id)) {
            try {
                return new ByteArrayInputStream(this.resources.get(id));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        throw this.makeFileNotFoundException(String.format("%s/%s/%s", type.m_10305_(), id.m_135827_(), id.m_135815_()));
    }

    public boolean m_7211_(PackType type, ResourceLocation id) {
        return type == this.packType && this.resources.containsKey(id);
    }

    public void close() {
        if (this.packType == PackType.CLIENT_RESOURCES) {
            // empty if block
        }
    }

    public FileNotFoundException makeFileNotFoundException(String path) {
        return new FileNotFoundException(String.format("'%s' in ResourcePack '%s'", path, this.resourcePackName));
    }

    protected void addBytes(ResourceLocation path, byte[] bytes) {
        this.namespaces.add(path.m_135827_());
        this.resources.put(path, bytes);
        if (this.generateDebugResources) {
            try {
                Path p = Paths.get("debug", "generated_resource_pack").resolve(path.m_135827_() + "/" + path.m_135815_());
                Files.createDirectories(p.getParent(), new FileAttribute[0]);
                Files.write(p, bytes, StandardOpenOption.CREATE, StandardOpenOption.WRITE, StandardOpenOption.TRUNCATE_EXISTING);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    protected void addImage(ResourceLocation path, NativeImage image, RPUtils.ResType resType) {
        try (NativeImage nativeImage = image;){
            this.addBytes(path, image.m_85121_(), resType);
        }
        catch (Exception e) {
            LOGGER.warn("Failed to add image {} to resource pack {}.", (Object)path, (Object)this.resourcePackName, (Object)e);
        }
    }

    private void addJson(ResourceLocation path, JsonElement json) {
        try {
            this.addBytes(path, RPUtils.serializeJson(json).getBytes());
        }
        catch (IOException e) {
            LOGGER.error("Failed to write JSON {} to resource pack {}.", (Object)path, (Object)this.resourcePackName, (Object)e);
        }
    }

    public void addJson(ResourceLocation location, JsonElement json, RPUtils.ResType resType) {
        this.addJson(RPUtils.resPath(location, resType), json);
    }

    public void addBytes(ResourceLocation location, byte[] bytes, RPUtils.ResType resType) {
        this.addBytes(RPUtils.resPath(location, resType), bytes);
    }

    public void addSimilarJsonResource(RPUtils.StaticResource resource, String keyword, String replaceWith) throws NoSuchElementException {
        ResourceLocation fullPath = resource.location;
        String string = new String(resource.data, StandardCharsets.UTF_8);
        if (!string.contains(keyword)) {
            throw new NoSuchElementException(String.format("Resource %s did not contain keyword %s. ", fullPath, keyword));
        }
        string = string.replace(keyword, replaceWith);
        StringBuilder builder = new StringBuilder();
        String[] partial = fullPath.m_135815_().split("/");
        for (int i = 0; i < partial.length; ++i) {
            if (i != 0) {
                builder.append("/");
            }
            if (i == partial.length - 1) {
                builder.append(partial[i].replace(keyword, replaceWith));
                continue;
            }
            builder.append(partial[i]);
        }
        ResourceLocation newRes = new ResourceLocation(this.resourcePackName.m_135827_(), builder.toString());
        this.addBytes(newRes, string.getBytes());
    }

    @FunctionalInterface
    public static interface TextTransform {
        public String accept(String var1);

        public static TextTransform replace(String from, String to) {
            return s -> s.replace(from, to);
        }
    }
}

