/*
 * Decompiled with CFR 0.152.
 */
package snownee.fruits;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Sets;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import net.minecraft.client.color.block.BlockColors;
import net.minecraft.client.color.item.ItemColors;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.core.BlockPos;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.tags.BlockTagsProvider;
import net.minecraft.data.worldgen.features.FeatureUtils;
import net.minecraft.data.worldgen.placement.PlacementUtils;
import net.minecraft.data.worldgen.placement.VegetationPlacements;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.random.SimpleWeightedRandomList;
import net.minecraft.util.valueproviders.ConstantInt;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.util.valueproviders.WeightedListInt;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.BannerPatternItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.SignItem;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.FenceBlock;
import net.minecraft.world.level.block.FenceGateBlock;
import net.minecraft.world.level.block.FlowerPotBlock;
import net.minecraft.world.level.block.PressurePlateBlock;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.SaplingBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.StandingSignBlock;
import net.minecraft.world.level.block.TrapDoorBlock;
import net.minecraft.world.level.block.WallSignBlock;
import net.minecraft.world.level.block.WoodButtonBlock;
import net.minecraft.world.level.block.entity.BannerPattern;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.grower.AbstractTreeGrower;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.WoodType;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.SimpleRandomFeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;
import net.minecraft.world.level.levelgen.feature.featuresize.FeatureSize;
import net.minecraft.world.level.levelgen.feature.featuresize.TwoLayersFeatureSize;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacer;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacerType;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import net.minecraft.world.level.levelgen.feature.stateproviders.SimpleStateProvider;
import net.minecraft.world.level.levelgen.feature.stateproviders.WeightedStateProvider;
import net.minecraft.world.level.levelgen.feature.treedecorators.BeehiveDecorator;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecoratorType;
import net.minecraft.world.level.levelgen.feature.trunkplacers.StraightTrunkPlacer;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacer;
import net.minecraft.world.level.levelgen.placement.CountPlacement;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.ColorHandlerEvent;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.forge.event.lifecycle.GatherDataEvent;
import snownee.fruits.CancellableGameEvent;
import snownee.fruits.FruitDropGameEvent;
import snownee.fruits.FruitType;
import snownee.fruits.FruitsConfig;
import snownee.fruits.FruitsMod;
import snownee.fruits.Hooks;
import snownee.fruits.block.FruitLeavesBlock;
import snownee.fruits.block.entity.FruitTreeBlockEntity;
import snownee.fruits.block.grower.FruitTreeGrower;
import snownee.fruits.cherry.FruitTypeExtension;
import snownee.fruits.cherry.block.SlidingDoorEntity;
import snownee.fruits.cherry.client.SlidingDoorRenderer;
import snownee.fruits.datagen.CommonBlockTagsProvider;
import snownee.fruits.datagen.CommonItemTagsProvider;
import snownee.fruits.datagen.CoreBlockLoot;
import snownee.fruits.levelgen.foliageplacers.FruitBlobFoliagePlacer;
import snownee.fruits.levelgen.treedecorators.CarpetTreeDecorator;
import snownee.kiwi.AbstractModule;
import snownee.kiwi.KiwiModule;
import snownee.kiwi.block.ModBlock;
import snownee.kiwi.data.provider.KiwiLootTableProvider;
import snownee.kiwi.item.ModItem;
import snownee.kiwi.loader.event.InitEvent;
import snownee.kiwi.util.VanillaActions;

@KiwiModule
@KiwiModule.Subscriber(value=KiwiModule.Subscriber.Bus.MOD)
public final class CoreModule
extends AbstractModule {
    @KiwiModule.Category(value="food")
    public static Item MANDARIN = new ModItem(CoreModule.itemProp().m_41489_(Foods.MANDARIN));
    @KiwiModule.Category(value="food")
    public static Item LIME = new ModItem(CoreModule.itemProp().m_41489_(Foods.LIME));
    @KiwiModule.Category(value="food")
    public static Item CITRON = new ModItem(CoreModule.itemProp().m_41489_(Foods.CITRON));
    @KiwiModule.Category(value="food")
    public static Item POMELO = new ModItem(CoreModule.itemProp().m_41489_(Foods.POMELO));
    @KiwiModule.Category(value="food")
    public static Item ORANGE = new ModItem(CoreModule.itemProp().m_41489_(Foods.ORANGE));
    @KiwiModule.Category(value="food")
    public static Item LEMON = new ModItem(CoreModule.itemProp().m_41489_(Foods.LEMON));
    @KiwiModule.Category(value="food")
    public static Item GRAPEFRUIT = new ModItem(CoreModule.itemProp().m_41489_(Foods.GRAPEFRUIT));
    public static Item EMPOWERED_CITRON = new ModItem(CoreModule.itemProp().m_41497_(Rarity.RARE).m_41489_(Foods.EMPOWERED_CITRON)){

        public boolean m_5812_(ItemStack stack) {
            return true;
        }
    };
    @KiwiModule.Category(value="decorations")
    @KiwiModule.RenderLayer(value=KiwiModule.RenderLayer.Layer.CUTOUT)
    public static FruitLeavesBlock MANDARIN_LEAVES = new FruitLeavesBlock(() -> FruitType.MANDARIN, CoreModule.blockProp((BlockBehaviour)Blocks.f_50050_));
    @KiwiModule.Category(value="decorations")
    @KiwiModule.RenderLayer(value=KiwiModule.RenderLayer.Layer.CUTOUT)
    public static FruitLeavesBlock LIME_LEAVES = new FruitLeavesBlock(() -> FruitType.LIME, CoreModule.blockProp((BlockBehaviour)Blocks.f_50050_));
    @KiwiModule.Category(value="decorations")
    @KiwiModule.RenderLayer(value=KiwiModule.RenderLayer.Layer.CUTOUT)
    public static FruitLeavesBlock CITRON_LEAVES = new FruitLeavesBlock(() -> FruitType.CITRON, CoreModule.blockProp((BlockBehaviour)Blocks.f_50050_));
    @KiwiModule.Category(value="decorations")
    @KiwiModule.RenderLayer(value=KiwiModule.RenderLayer.Layer.CUTOUT)
    public static FruitLeavesBlock POMELO_LEAVES = new FruitLeavesBlock(() -> FruitType.POMELO, CoreModule.blockProp((BlockBehaviour)Blocks.f_50050_));
    @KiwiModule.Category(value="decorations")
    @KiwiModule.RenderLayer(value=KiwiModule.RenderLayer.Layer.CUTOUT)
    public static FruitLeavesBlock ORANGE_LEAVES = new FruitLeavesBlock(() -> FruitType.ORANGE, CoreModule.blockProp((BlockBehaviour)Blocks.f_50050_));
    @KiwiModule.Category(value="decorations")
    @KiwiModule.RenderLayer(value=KiwiModule.RenderLayer.Layer.CUTOUT)
    public static FruitLeavesBlock LEMON_LEAVES = new FruitLeavesBlock(() -> FruitType.LEMON, CoreModule.blockProp((BlockBehaviour)Blocks.f_50050_));
    @KiwiModule.Category(value="decorations")
    @KiwiModule.RenderLayer(value=KiwiModule.RenderLayer.Layer.CUTOUT)
    public static FruitLeavesBlock GRAPEFRUIT_LEAVES = new FruitLeavesBlock(() -> FruitType.GRAPEFRUIT, CoreModule.blockProp((BlockBehaviour)Blocks.f_50050_));
    @KiwiModule.Category(value="decorations")
    @KiwiModule.RenderLayer(value=KiwiModule.RenderLayer.Layer.CUTOUT)
    public static FruitLeavesBlock APPLE_LEAVES = new FruitLeavesBlock(() -> FruitType.APPLE, CoreModule.blockProp((BlockBehaviour)Blocks.f_50050_));
    @KiwiModule.Category(value="building_blocks")
    public static RotatedPillarBlock CITRUS_LOG = new RotatedPillarBlock(CoreModule.blockProp((BlockBehaviour)Blocks.f_50002_));
    @KiwiModule.Category(value="building_blocks")
    public static Block CITRUS_WOOD = new RotatedPillarBlock(CoreModule.blockProp((BlockBehaviour)Blocks.f_50014_));
    @KiwiModule.Category(value="building_blocks")
    public static Block STRIPPED_CITRUS_LOG = new RotatedPillarBlock(CoreModule.blockProp((BlockBehaviour)Blocks.f_50007_));
    @KiwiModule.Category(value="building_blocks")
    public static Block STRIPPED_CITRUS_WOOD = new RotatedPillarBlock(CoreModule.blockProp((BlockBehaviour)Blocks.f_50047_));
    @KiwiModule.Category(value="building_blocks")
    public static Block CITRUS_PLANKS = new ModBlock(CoreModule.blockProp((BlockBehaviour)Blocks.f_50743_));
    @KiwiModule.Category(value="building_blocks")
    public static SlabBlock CITRUS_SLAB = new SlabBlock(CoreModule.blockProp((BlockBehaviour)Blocks.f_50401_));
    @KiwiModule.Category(value="building_blocks")
    public static StairBlock CITRUS_STAIRS = new StairBlock(() -> CITRUS_PLANKS.m_49966_(), CoreModule.blockProp((BlockBehaviour)Blocks.f_50271_));
    @KiwiModule.Category(value="decorations")
    public static FenceBlock CITRUS_FENCE = new FenceBlock(CoreModule.blockProp((BlockBehaviour)Blocks.f_50481_));
    @KiwiModule.Category(value="redstone")
    public static FenceGateBlock CITRUS_FENCE_GATE = new FenceGateBlock(CoreModule.blockProp((BlockBehaviour)Blocks.f_50476_));
    @KiwiModule.Category(value="redstone")
    public static TrapDoorBlock CITRUS_TRAPDOOR = new TrapDoorBlock(CoreModule.blockProp((BlockBehaviour)Blocks.f_50219_));
    @KiwiModule.Category(value="redstone")
    @KiwiModule.RenderLayer(value=KiwiModule.RenderLayer.Layer.CUTOUT)
    public static DoorBlock CITRUS_DOOR = new DoorBlock(CoreModule.blockProp((BlockBehaviour)Blocks.f_50486_));
    @KiwiModule.Category(value="redstone")
    public static WoodButtonBlock CITRUS_BUTTON = new WoodButtonBlock(CoreModule.blockProp((BlockBehaviour)Blocks.f_50219_));
    @KiwiModule.Category(value="redstone")
    public static PressurePlateBlock CITRUS_PRESSURE_PLATE = new PressurePlateBlock(PressurePlateBlock.Sensitivity.EVERYTHING, CoreModule.blockProp((BlockBehaviour)Blocks.f_50486_));
    @KiwiModule.Category(value="decorations")
    @KiwiModule.RenderLayer(value=KiwiModule.RenderLayer.Layer.CUTOUT)
    public static SaplingBlock MANDARIN_SAPLING = new SaplingBlock((AbstractTreeGrower)new FruitTreeGrower(() -> FruitType.MANDARIN), CoreModule.blockProp((BlockBehaviour)Blocks.f_50746_));
    @KiwiModule.Category(value="decorations")
    @KiwiModule.RenderLayer(value=KiwiModule.RenderLayer.Layer.CUTOUT)
    public static SaplingBlock LIME_SAPLING = new SaplingBlock((AbstractTreeGrower)new FruitTreeGrower(() -> FruitType.LIME), CoreModule.blockProp((BlockBehaviour)Blocks.f_50746_));
    @KiwiModule.Category(value="decorations")
    @KiwiModule.RenderLayer(value=KiwiModule.RenderLayer.Layer.CUTOUT)
    public static SaplingBlock CITRON_SAPLING = new SaplingBlock((AbstractTreeGrower)new FruitTreeGrower(() -> FruitType.CITRON), CoreModule.blockProp((BlockBehaviour)Blocks.f_50746_));
    @KiwiModule.Category(value="decorations")
    @KiwiModule.RenderLayer(value=KiwiModule.RenderLayer.Layer.CUTOUT)
    public static SaplingBlock POMELO_SAPLING = new SaplingBlock((AbstractTreeGrower)new FruitTreeGrower(() -> FruitType.POMELO), CoreModule.blockProp((BlockBehaviour)Blocks.f_50746_));
    @KiwiModule.Category(value="decorations")
    @KiwiModule.RenderLayer(value=KiwiModule.RenderLayer.Layer.CUTOUT)
    public static SaplingBlock ORANGE_SAPLING = new SaplingBlock((AbstractTreeGrower)new FruitTreeGrower(() -> FruitType.ORANGE), CoreModule.blockProp((BlockBehaviour)Blocks.f_50746_));
    @KiwiModule.Category(value="decorations")
    @KiwiModule.RenderLayer(value=KiwiModule.RenderLayer.Layer.CUTOUT)
    public static SaplingBlock LEMON_SAPLING = new SaplingBlock((AbstractTreeGrower)new FruitTreeGrower(() -> FruitType.LEMON), CoreModule.blockProp((BlockBehaviour)Blocks.f_50746_));
    @KiwiModule.Category(value="decorations")
    @KiwiModule.RenderLayer(value=KiwiModule.RenderLayer.Layer.CUTOUT)
    public static SaplingBlock GRAPEFRUIT_SAPLING = new SaplingBlock((AbstractTreeGrower)new FruitTreeGrower(() -> FruitType.GRAPEFRUIT), CoreModule.blockProp((BlockBehaviour)Blocks.f_50746_));
    @KiwiModule.Category(value="decorations")
    @KiwiModule.RenderLayer(value=KiwiModule.RenderLayer.Layer.CUTOUT)
    public static SaplingBlock APPLE_SAPLING = new SaplingBlock((AbstractTreeGrower)new FruitTreeGrower(() -> FruitType.APPLE), CoreModule.blockProp((BlockBehaviour)Blocks.f_50746_));
    @KiwiModule.RenderLayer(value=KiwiModule.RenderLayer.Layer.CUTOUT)
    @KiwiModule.NoItem
    public static FlowerPotBlock POTTED_MANDARIN = new FlowerPotBlock(() -> (FlowerPotBlock)Blocks.f_50276_, () -> MANDARIN_SAPLING, CoreModule.blockProp((BlockBehaviour)Blocks.f_50280_));
    @KiwiModule.RenderLayer(value=KiwiModule.RenderLayer.Layer.CUTOUT)
    @KiwiModule.NoItem
    public static FlowerPotBlock POTTED_LIME = new FlowerPotBlock(() -> (FlowerPotBlock)Blocks.f_50276_, () -> LIME_SAPLING, CoreModule.blockProp((BlockBehaviour)Blocks.f_50280_));
    @KiwiModule.RenderLayer(value=KiwiModule.RenderLayer.Layer.CUTOUT)
    @KiwiModule.NoItem
    public static FlowerPotBlock POTTED_CITRON = new FlowerPotBlock(() -> (FlowerPotBlock)Blocks.f_50276_, () -> CITRON_SAPLING, CoreModule.blockProp((BlockBehaviour)Blocks.f_50280_));
    @KiwiModule.RenderLayer(value=KiwiModule.RenderLayer.Layer.CUTOUT)
    @KiwiModule.NoItem
    public static FlowerPotBlock POTTED_POMELO = new FlowerPotBlock(() -> (FlowerPotBlock)Blocks.f_50276_, () -> POMELO_SAPLING, CoreModule.blockProp((BlockBehaviour)Blocks.f_50280_));
    @KiwiModule.RenderLayer(value=KiwiModule.RenderLayer.Layer.CUTOUT)
    @KiwiModule.NoItem
    public static FlowerPotBlock POTTED_ORANGE = new FlowerPotBlock(() -> (FlowerPotBlock)Blocks.f_50276_, () -> ORANGE_SAPLING, CoreModule.blockProp((BlockBehaviour)Blocks.f_50280_));
    @KiwiModule.RenderLayer(value=KiwiModule.RenderLayer.Layer.CUTOUT)
    @KiwiModule.NoItem
    public static FlowerPotBlock POTTED_LEMON = new FlowerPotBlock(() -> (FlowerPotBlock)Blocks.f_50276_, () -> LEMON_SAPLING, CoreModule.blockProp((BlockBehaviour)Blocks.f_50280_));
    @KiwiModule.RenderLayer(value=KiwiModule.RenderLayer.Layer.CUTOUT)
    @KiwiModule.NoItem
    public static FlowerPotBlock POTTED_GRAPEFRUIT = new FlowerPotBlock(() -> (FlowerPotBlock)Blocks.f_50276_, () -> GRAPEFRUIT_SAPLING, CoreModule.blockProp((BlockBehaviour)Blocks.f_50280_));
    @KiwiModule.RenderLayer(value=KiwiModule.RenderLayer.Layer.CUTOUT)
    @KiwiModule.NoItem
    public static FlowerPotBlock POTTED_APPLE = new FlowerPotBlock(() -> (FlowerPotBlock)Blocks.f_50276_, () -> APPLE_SAPLING, CoreModule.blockProp((BlockBehaviour)Blocks.f_50280_));
    public static final Set<Block> ALL_LEAVES = Sets.newConcurrentHashSet();
    public static BlockEntityType<FruitTreeBlockEntity> FRUIT_TREE = new BlockEntityType(FruitTreeBlockEntity::new, ALL_LEAVES, null);
    @KiwiModule.Name(value="carpet")
    public static TreeDecoratorType<CarpetTreeDecorator> CARPET_DECORATOR = new TreeDecoratorType(CarpetTreeDecorator.CODEC);
    @KiwiModule.Name(value="blob")
    public static FoliagePlacerType<FruitBlobFoliagePlacer> BLOB_PLACER = new FoliagePlacerType(FruitBlobFoliagePlacer.CODEC);
    public static final BannerPattern SNOWFLAKE = BannerPattern.create((String)"SNOWFLAKE", (String)"snowflake", (String)"sno", (boolean)true);
    @KiwiModule.Category(value="misc")
    public static final BannerPatternItem SNOWFLAKE_BANNER_PATTERN = new BannerPatternItem(SNOWFLAKE, CoreModule.itemProp().m_41487_(1).m_41497_(Rarity.UNCOMMON));
    public static SoundEvent OPEN_SOUND = new SoundEvent(new ResourceLocation("fruittrees", "block.wooden_door.open"));
    public static SoundEvent CLOSE_SOUND = new SoundEvent(new ResourceLocation("fruittrees", "block.wooden_door.close"));
    public static EntityType<SlidingDoorEntity> SLIDING_DOOR = EntityType.Builder.m_20704_(SlidingDoorEntity::new, (MobCategory)MobCategory.MISC).m_20699_(1.0f, 2.0f).m_20719_().m_20698_().setCustomClientFactory((p, w) -> new SlidingDoorEntity((Level)w, new BlockPos(p.getPosX(), p.getPosY(), p.getPosZ()))).m_20712_("fruittrees:door");
    public static final WoodType CITRUS_WOODTYPE = WoodType.create((String)"fruittrees_citrus");
    @KiwiModule.NoItem
    public static StandingSignBlock CITRUS_SIGN = new StandingSignBlock(CoreModule.blockProp((BlockBehaviour)Blocks.f_50095_), CITRUS_WOODTYPE);
    @KiwiModule.NoItem
    public static WallSignBlock CITRUS_WALL_SIGN = new WallSignBlock(CoreModule.blockProp((BlockBehaviour)Blocks.f_50158_), CITRUS_WOODTYPE);
    @KiwiModule.Name(value="citrus_sign")
    @KiwiModule.Category(value="decorations")
    public static SignItem CITRUS_SIGN_ITEM = new SignItem(CoreModule.itemProp().m_41487_(16), (Block)CITRUS_SIGN, (Block)CITRUS_WALL_SIGN);
    public static FruitDropGameEvent FRUIT_DROP = new FruitDropGameEvent("fruittrees:fruit_drop", 6);
    public static CancellableGameEvent LEAVES_TRAMPLE = new CancellableGameEvent("fruittrees:leaves_trample", 6);
    private ConfiguredFeature<?, ?> TREES_CF;
    private static PlacedFeature[] allFeatures;

    public CoreModule() {
        MinecraftForge.EVENT_BUS.addListener(CoreModule::insertFeatures);
    }

    protected void init(InitEvent event) {
        event.enqueueWork(() -> {
            FlowerPotBlock pot = (FlowerPotBlock)Blocks.f_50276_;
            pot.addPlant(MANDARIN_SAPLING.getRegistryName(), () -> POTTED_MANDARIN);
            pot.addPlant(LIME_SAPLING.getRegistryName(), () -> POTTED_LIME);
            pot.addPlant(CITRON_SAPLING.getRegistryName(), () -> POTTED_CITRON);
            pot.addPlant(POMELO_SAPLING.getRegistryName(), () -> POTTED_POMELO);
            pot.addPlant(ORANGE_SAPLING.getRegistryName(), () -> POTTED_ORANGE);
            pot.addPlant(LEMON_SAPLING.getRegistryName(), () -> POTTED_LEMON);
            pot.addPlant(GRAPEFRUIT_SAPLING.getRegistryName(), () -> POTTED_GRAPEFRUIT);
            pot.addPlant(APPLE_SAPLING.getRegistryName(), () -> POTTED_APPLE);
            VanillaActions.registerAxeConversion((Block)CITRUS_LOG, (Block)STRIPPED_CITRUS_LOG);
            VanillaActions.registerAxeConversion((Block)CITRUS_WOOD, (Block)STRIPPED_CITRUS_WOOD);
            for (FruitType type : FruitType.values()) {
                VanillaActions.registerCompostable((float)0.5f, (ItemLike)type.fruit);
                VanillaActions.registerCompostable((float)0.3f, (ItemLike)type.leaves);
                VanillaActions.registerCompostable((float)0.3f, (ItemLike)((ItemLike)type.sapling.get()));
                VanillaActions.registerVillagerPickupable((ItemLike)type.fruit);
                VanillaActions.registerVillagerCompostable((ItemLike)type.fruit);
                type.makeFeature();
            }
            if (FruitsConfig.worldGen) {
                ImmutableList.Builder builder = ImmutableList.builder();
                for (FruitType type : List.of(FruitType.CITRON, FruitType.LIME, FruitType.MANDARIN)) {
                    if (type.featureWG == null) continue;
                    builder.add(() -> type.featureWG.m_190823_(new PlacementModifier[0]));
                }
                this.TREES_CF = Feature.f_65755_.m_65815_((FeatureConfiguration)new SimpleRandomFeatureConfiguration((List)builder.build()));
                FeatureUtils.m_195005_((String)"fruittrees:base_trees", this.TREES_CF);
                allFeatures = new PlacedFeature[Hooks.cherry ? 5 : 3];
                this.makePlacedFeature("002", FruitsConfig.treesGenChunksInPlains, 0);
                this.makePlacedFeature("005", FruitsConfig.treesGenChunksInForest, 1);
                this.makePlacedFeature("1", FruitsConfig.treesGenChunksInJungle, 2);
            }
            WoodType.m_61844_((WoodType)CITRUS_WOODTYPE);
        }).whenComplete((v, ex) -> {
            if (ex != null) {
                FruitsMod.logger.catching(ex);
            }
        });
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public void clientInit(ModelRegistryEvent event) {
        Sheets.addWoodType((WoodType)CITRUS_WOODTYPE);
    }

    @SubscribeEvent
    protected void entityRenderers(EntityRenderersEvent.RegisterRenderers event) {
        event.registerEntityRenderer(SLIDING_DOOR, SlidingDoorRenderer::new);
    }

    private void makePlacedFeature(String id, int chunks, int index) {
        SimpleWeightedRandomList simpleweightedrandomlist = SimpleWeightedRandomList.m_146263_().m_146271_((Object)ConstantInt.m_146483_((int)0), chunks - 1).m_146271_((Object)ConstantInt.m_146483_((int)1), 1).m_146270_();
        CountPlacement placement = CountPlacement.m_191630_((IntProvider)new WeightedListInt(simpleweightedrandomlist));
        CoreModule.allFeatures[index] = this.TREES_CF.m_190821_(VegetationPlacements.m_195481_((PlacementModifier)placement, (Block)LEMON_SAPLING));
        PlacementUtils.m_195368_((String)("fruittrees:trees_" + id), (PlacedFeature)allFeatures[index]);
        if (index != 2 && Hooks.cherry) {
            CoreModule.allFeatures[index + 3] = FruitTypeExtension.CHERRY.featureWG.m_190821_(VegetationPlacements.m_195481_((PlacementModifier)placement, (Block)LEMON_SAPLING));
            PlacementUtils.m_195368_((String)("fruittrees:cherry_" + id), (PlacedFeature)allFeatures[index + 3]);
        }
    }

    public static void insertFeatures(BiomeLoadingEvent event) {
        int i;
        if (!FruitsConfig.worldGen) {
            return;
        }
        Biome.ClimateSettings climate = event.getClimate();
        if (climate.f_47680_ != Biome.Precipitation.RAIN) {
            return;
        }
        if (climate.f_47682_ == Biome.TemperatureModifier.FROZEN) {
            return;
        }
        Biome.BiomeCategory category = event.getCategory();
        switch (category) {
            case PLAINS: {
                i = 0;
                break;
            }
            case FOREST: {
                i = 1;
                break;
            }
            case JUNGLE: {
                i = 2;
                break;
            }
            default: {
                return;
            }
        }
        event.getGeneration().m_186664_(GenerationStep.Decoration.VEGETAL_DECORATION, allFeatures[i]);
        if (category != Biome.BiomeCategory.JUNGLE && Hooks.cherry) {
            event.getGeneration().m_186664_(GenerationStep.Decoration.VEGETAL_DECORATION, allFeatures[i + 3]);
        }
    }

    public static ConfiguredFeature<TreeConfiguration, ?> buildTreeFeature(FruitType type, boolean worldGen, Block carpet) {
        SimpleStateProvider leavesProvider;
        ImmutableList decorators;
        if (worldGen) {
            decorators = carpet == null ? ImmutableList.of((Object)new BeehiveDecorator(0.05f)) : ImmutableList.of((Object)new BeehiveDecorator(0.05f), (Object)((Object)new CarpetTreeDecorator((BlockStateProvider)BlockStateProvider.m_191382_((Block)carpet))));
            leavesProvider = new WeightedStateProvider(SimpleWeightedRandomList.m_146263_().m_146271_((Object)type.leaves.m_49966_(), 2).m_146271_((Object)((BlockState)type.leaves.m_49966_().m_61124_((Property)FruitLeavesBlock.AGE, (Comparable)Integer.valueOf(2))), 1));
        } else {
            decorators = ImmutableList.of();
            leavesProvider = BlockStateProvider.m_191382_((Block)type.leaves);
        }
        StringBuffer buf = new StringBuffer("fruittrees:");
        buf.append(type.name().toLowerCase(Locale.ENGLISH));
        if (worldGen) {
            buf.append("_wg");
        }
        return FeatureUtils.m_195005_((String)buf.toString(), (ConfiguredFeature)Feature.f_65760_.m_65815_((FeatureConfiguration)new TreeConfiguration.TreeConfigurationBuilder((BlockStateProvider)BlockStateProvider.m_191382_((Block)type.log), (TrunkPlacer)new StraightTrunkPlacer(4, 2, 0), (BlockStateProvider)leavesProvider, (FoliagePlacer)new FruitBlobFoliagePlacer((IntProvider)ConstantInt.m_146483_((int)2), (IntProvider)ConstantInt.f_146476_, 3), (FeatureSize)new TwoLayersFeatureSize(1, 0, 1)).m_68244_().m_68249_((List)decorators).m_68251_()));
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public void handleBlockColor(ColorHandlerEvent.Block event) {
        BlockState oakLeaves = Blocks.f_50050_.m_49966_();
        BlockColors blockColors = event.getBlockColors();
        blockColors.m_92589_((state, world, pos, i) -> {
            if (i == 0) {
                return blockColors.m_92577_(oakLeaves, world, pos, i);
            }
            if (i == 1) {
                Block block = state.m_60734_();
                if (block == CITRON_LEAVES) {
                    return 14535768;
                }
                if (block == GRAPEFRUIT_LEAVES) {
                    return 16011307;
                }
                if (block == LEMON_LEAVES) {
                    return 15452747;
                }
                if (block == LIME_LEAVES) {
                    return 13294198;
                }
                if (block == MANDARIN_LEAVES) {
                    return 15763993;
                }
                if (block == ORANGE_LEAVES) {
                    return 15763993;
                }
                if (block == POMELO_LEAVES) {
                    return 16250494;
                }
                if (block == APPLE_LEAVES) {
                    return 16522282;
                }
            }
            return -1;
        }, new Block[]{MANDARIN_LEAVES, LIME_LEAVES, CITRON_LEAVES, POMELO_LEAVES, ORANGE_LEAVES, LEMON_LEAVES, GRAPEFRUIT_LEAVES, APPLE_LEAVES});
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public void handleItemColor(ColorHandlerEvent.Item event) {
        ItemStack oakLeaves = new ItemStack((ItemLike)Items.f_41896_);
        ItemColors itemColors = event.getItemColors();
        itemColors.m_92689_((stack, i) -> itemColors.m_92676_(oakLeaves, i), new ItemLike[]{MANDARIN_LEAVES, LIME_LEAVES, CITRON_LEAVES, POMELO_LEAVES, ORANGE_LEAVES, LEMON_LEAVES, GRAPEFRUIT_LEAVES, APPLE_LEAVES});
    }

    public void gatherData(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        if (event.includeServer()) {
            generator.m_123914_((DataProvider)new KiwiLootTableProvider(generator).add(CoreBlockLoot::new, LootContextParamSets.f_81421_));
            CommonBlockTagsProvider blockTagsProvider = new CommonBlockTagsProvider(generator, event.getExistingFileHelper());
            generator.m_123914_((DataProvider)blockTagsProvider);
            generator.m_123914_((DataProvider)new CommonItemTagsProvider(generator, (BlockTagsProvider)blockTagsProvider, event.getExistingFileHelper()));
        }
    }

    public static final class Foods {
        public static final FoodProperties MANDARIN = new FoodProperties.Builder().m_38760_(3).m_38758_(0.3f).m_38767_();
        public static final FoodProperties LIME = new FoodProperties.Builder().m_38760_(3).m_38758_(0.3f).m_38767_();
        public static final FoodProperties CITRON = new FoodProperties.Builder().m_38760_(3).m_38758_(0.3f).m_38767_();
        public static final FoodProperties POMELO = new FoodProperties.Builder().m_38760_(4).m_38758_(0.3f).m_38767_();
        public static final FoodProperties ORANGE = new FoodProperties.Builder().m_38760_(3).m_38758_(0.5f).m_38767_();
        public static final FoodProperties LEMON = new FoodProperties.Builder().m_38760_(2).m_38758_(1.0f).m_38766_().m_38767_();
        public static final FoodProperties GRAPEFRUIT = new FoodProperties.Builder().m_38760_(6).m_38758_(0.4f).m_38767_();
        public static final FoodProperties EMPOWERED_CITRON = new FoodProperties.Builder().m_38760_(3).m_38758_(5.0f).m_38767_();
    }
}

