/*
 * Decompiled with CFR 0.152.
 */
package snownee.fruits;

import com.google.common.collect.Lists;
import com.mojang.datafixers.util.Either;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.Tag;
import net.minecraft.world.Container;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.animal.Bee;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DoublePlantBlock;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.registries.ForgeRegistries;
import snownee.fruits.FruitType;
import snownee.fruits.block.FruitLeavesBlock;
import snownee.fruits.cherry.block.SlidingDoorEntity;
import snownee.fruits.hybridization.HybridingContext;
import snownee.fruits.hybridization.HybridingRecipe;
import snownee.fruits.hybridization.Hybridization;
import snownee.kiwi.util.NBTHelper;
import snownee.kiwi.util.Util;

public final class Hooks {
    public static boolean cherry;
    public static boolean hybridization;

    private Hooks() {
    }

    public static boolean safeSetBlock(Level world, BlockPos pos, BlockState state) {
        BlockState old = world.m_8055_(pos);
        if (old == state || old.m_155947_() || old.m_60811_() == PushReaction.BLOCK || old.m_60734_() == Blocks.f_50080_ || old.m_60620_((Tag)BlockTags.f_13070_)) {
            return false;
        }
        return world.m_46597_(pos, state);
    }

    public static boolean canPollinate(BlockState state) {
        if (state.m_60620_((Tag)BlockTags.f_13040_)) {
            if (state.m_60734_() == Blocks.f_50355_) {
                return state.m_61143_((Property)DoublePlantBlock.f_52858_) == DoubleBlockHalf.UPPER;
            }
            return true;
        }
        if (state.m_60620_((Tag)BlockTags.f_13037_)) {
            return true;
        }
        if (hybridization && state.m_60734_() instanceof FruitLeavesBlock) {
            if (!((FruitLeavesBlock)state.m_60734_()).canGrow(state)) {
                return false;
            }
            return (Integer)state.m_61143_((Property)FruitLeavesBlock.AGE) == 2;
        }
        return false;
    }

    public static void onPollinateComplete(Bee bee) {
        String newPollen;
        BlockState state = bee.f_19853_.m_8055_(bee.m_27851_());
        Block block = state.m_60734_();
        FruitType type = block instanceof FruitLeavesBlock ? ((FruitLeavesBlock)block).type.get() : null;
        NBTHelper data = NBTHelper.of((CompoundTag)bee.getPersistentData());
        ListTag list = data.getTagList("FruitsList", 8);
        if (list == null) {
            list = new ListTag();
            data.setTag("FruitsList", (net.minecraft.nbt.Tag)list);
        }
        String string = newPollen = type != null ? type.name() : "_" + Util.trimRL((ResourceLocation)block.getRegistryName());
        if (list.stream().anyMatch(e -> e.m_7916_().equals(newPollen))) {
            return;
        }
        StringTag newPollenNBT = StringTag.m_129297_((String)newPollen);
        if (!list.isEmpty()) {
            List<Either<FruitType, Block>> pollenList = Hooks.readPollen(list);
            pollenList.add(Hooks.parsePollen(newPollen));
            Optional recipe = bee.f_19853_.m_7465_().m_44015_(Hybridization.RECIPE_TYPE, (Container)new HybridingContext(pollenList), bee.f_19853_);
            if (recipe.isPresent()) {
                boolean isMisc;
                Block newBlock = ((HybridingRecipe)((Object)recipe.get())).getResultAsBlock(pollenList);
                boolean isLeaves = newBlock instanceof FruitLeavesBlock;
                boolean isFlower = !isLeaves && BlockTags.f_13041_.m_8110_((Object)newBlock);
                boolean bl = isMisc = !isLeaves && !isFlower;
                if (!isMisc && isLeaves != block instanceof FruitLeavesBlock) {
                    return;
                }
                BlockPos root = bee.m_27851_();
                if (state.m_60620_((Tag)BlockTags.f_13040_) && state.m_61138_((Property)DoublePlantBlock.f_52858_) && state.m_61143_((Property)DoublePlantBlock.f_52858_) == DoubleBlockHalf.UPPER) {
                    root = root.m_7495_();
                } else if (isMisc && !newBlock.m_5568_() && !(block instanceof FruitLeavesBlock)) {
                    root = root.m_7495_();
                }
                BlockState newState = newBlock.m_49966_();
                boolean isBigFlower = false;
                if (isLeaves) {
                    newState = (BlockState)newState.m_61124_((Property)FruitLeavesBlock.AGE, (Comparable)Integer.valueOf(2));
                    newState = (BlockState)newState.m_61124_((Property)LeavesBlock.f_54418_, (Comparable)((Integer)state.m_61143_((Property)LeavesBlock.f_54418_)));
                } else if (isFlower && newState.m_60620_((Tag)BlockTags.f_13040_) && newState.m_61138_((Property)DoublePlantBlock.f_52858_)) {
                    newState = (BlockState)newState.m_61124_((Property)DoublePlantBlock.f_52858_, (Comparable)DoubleBlockHalf.LOWER);
                    isBigFlower = true;
                }
                boolean placed = Hooks.safeSetBlock(bee.f_19853_, root, newState);
                if (placed && isBigFlower) {
                    newState = (BlockState)newState.m_61124_((Property)DoublePlantBlock.f_52858_, (Comparable)DoubleBlockHalf.UPPER);
                    Hooks.safeSetBlock(bee.f_19853_, root.m_7494_(), newState);
                }
                if (placed) {
                    data.remove("FruitsList");
                    return;
                }
            }
        }
        if (list.size() > 3) {
            int toRemove = list.size() - 3;
            while (toRemove-- > 0) {
                list.remove(0);
            }
        }
        list.add((Object)newPollenNBT);
    }

    public static List<Either<FruitType, Block>> readPollen(ListTag list) {
        ArrayList pollenList = Lists.newArrayList();
        list.forEach(e -> pollenList.add(Hooks.parsePollen(e.m_7916_())));
        return pollenList;
    }

    public static Either<FruitType, Block> parsePollen(String id) {
        if (id.startsWith("_")) {
            Block block = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(id.substring(1)));
            return Either.right((Object)block);
        }
        FruitType type = FruitType.parse(id);
        return Either.left((Object)((Object)type));
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void modifyRayTraceResult(Minecraft mc) {
        Entity entity;
        if (mc.f_91077_ instanceof EntityHitResult && (entity = ((EntityHitResult)mc.f_91077_).m_82443_()) instanceof SlidingDoorEntity) {
            Vec3 vec = mc.f_91077_.m_82450_();
            BlockPos pos = entity.m_142538_();
            if (vec.f_82480_ - (double)pos.m_123342_() >= 1.0) {
                pos = pos.m_7494_();
            }
            mc.f_91077_ = new BlockHitResult(vec, Direction.UP, pos, false);
        }
    }
}

