/*
 * Decompiled with CFR 0.152.
 */
package snownee.fruits.block;

import java.util.Random;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.animal.FlyingAnimal;
import net.minecraft.world.entity.item.FallingBlockEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEventListener;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.EntityCollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.items.ItemHandlerHelper;
import snownee.fruits.CoreModule;
import snownee.fruits.FruitType;
import snownee.fruits.FruitsConfig;
import snownee.fruits.block.entity.FruitTreeBlockEntity;
import snownee.fruits.levelgen.treedecorators.CarpetTreeDecorator;

public class FruitLeavesBlock
extends LeavesBlock
implements BonemealableBlock,
EntityBlock {
    public static final IntegerProperty AGE = BlockStateProperties.f_61407_;
    public final Supplier<FruitType> type;

    public FruitLeavesBlock(Supplier<FruitType> type, BlockBehaviour.Properties properties) {
        super(properties);
        this.type = type;
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)f_54418_, (Comparable)Integer.valueOf(7))).m_61124_((Property)f_54419_, (Comparable)Boolean.valueOf(false))).m_61124_((Property)AGE, (Comparable)Integer.valueOf(1)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{f_54418_, f_54419_, AGE});
    }

    public boolean m_7370_(BlockGetter worldIn, BlockPos pos, BlockState state, boolean isClient) {
        return this.canGrow(state) || (Integer)state.m_61143_((Property)AGE) == 1;
    }

    public boolean m_5491_(Level worldIn, Random rand, BlockPos pos, BlockState state) {
        return (Integer)state.m_61143_((Property)AGE) != 3;
    }

    public void m_7719_(ServerLevel world, Random rand, BlockPos pos, BlockState state) {
        world.m_46597_(pos, (BlockState)state.m_61122_((Property)AGE));
    }

    public static Supplier<ItemEntity> dropFruit(Level level, BlockPos pos, BlockState state, float deathRate) {
        boolean die;
        if (level.f_46443_ || (Integer)state.m_61143_((Property)AGE) != 3) {
            return () -> null;
        }
        if (!level.m_46469_().m_46207_(GameRules.f_46136_)) {
            return () -> null;
        }
        boolean bl = die = deathRate == 1.0f;
        if (deathRate > 0.0f) {
            die = level.f_46441_.nextFloat() < deathRate;
        }
        state = (BlockState)state.m_61124_((Property)AGE, (Comparable)Integer.valueOf(die ? 0 : 1));
        if (deathRate == 1.0f) {
            state = (BlockState)state.m_61124_((Property)f_54419_, (Comparable)Boolean.valueOf(false));
        }
        BlockState newState = state;
        FruitType type = ((FruitLeavesBlock)state.m_60734_()).type.get();
        ItemStack stack = new ItemStack((ItemLike)type.fruit);
        if (!stack.m_41619_() && !level.restoringBlockSnapshots) {
            float f = EntityType.f_20461_.m_20679_() / 2.0f;
            double d0 = (double)((float)pos.m_123341_() + 0.5f) + Mth.m_14064_((Random)level.f_46441_, (double)-0.25, (double)0.25);
            double d1 = (double)((float)pos.m_123342_() + 0.5f) + Mth.m_14064_((Random)level.f_46441_, (double)-0.25, (double)0.25) - (double)f;
            double d2 = (double)((float)pos.m_123343_() + 0.5f) + Mth.m_14064_((Random)level.f_46441_, (double)-0.25, (double)0.25);
            ItemEntity itementity = new ItemEntity(level, d0, d1, d2, stack);
            itementity.m_32060_();
            if (level.m_7967_((Entity)itementity)) {
                return () -> {
                    level.m_46597_(pos, newState);
                    return itementity;
                };
            }
        }
        return () -> null;
    }

    public void m_7455_(BlockState state, ServerLevel world, BlockPos pos, Random rand) {
        if (this.shouldDecay(state)) {
            FruitLeavesBlock.m_49950_((BlockState)state, (Level)world, (BlockPos)pos);
            world.m_7471_(pos, false);
        } else if (this.canGrow(state) && world.m_46803_(pos.m_7494_()) >= 9) {
            boolean def;
            int r = rand.nextInt(100);
            if (r < 10 && this.type.get().carpet != null) {
                CarpetTreeDecorator.placeCarpet((LevelSimulatedReader)world, pos, this.type.get().carpet.m_49966_(), (arg_0, arg_1) -> ((ServerLevel)world).m_46597_(arg_0, arg_1));
            }
            boolean bl = def = r > 99 - FruitsConfig.growingSpeed;
            if ((Integer)state.m_61143_((Property)AGE) == 3) {
                FruitsConfig.DropMode mode = FruitsConfig.getDropMode((LevelAccessor)world);
                if (mode == FruitsConfig.DropMode.NO_DROP) {
                    return;
                }
                GameEventListener receiver = CoreModule.FRUIT_DROP.post((LevelAccessor)world, pos, null);
                if (receiver == null) {
                    FruitLeavesBlock.dropFruit((Level)world, pos, state, 0.6f).get();
                }
            } else if (ForgeHooks.onCropsGrowPre((Level)world, (BlockPos)pos, (BlockState)state, (boolean)def)) {
                this.m_7719_(world, rand, pos, state);
                ForgeHooks.onCropsGrowPost((Level)world, (BlockPos)pos, (BlockState)state);
            }
        }
    }

    public void m_7458_(BlockState state, ServerLevel world, BlockPos pos, Random rand) {
        if (((Boolean)(state = FruitLeavesBlock.m_54435_((BlockState)state, (LevelAccessor)world, (BlockPos)pos)).m_61143_((Property)f_54419_)).booleanValue() && (Integer)state.m_61143_((Property)f_54418_) != 1) {
            state = (BlockState)state.m_61124_((Property)f_54419_, (Comparable)Boolean.valueOf(false));
        }
        world.m_46597_(pos, state);
    }

    public boolean m_6724_(BlockState state) {
        return this.shouldDecay(state) || this.canGrow(state) || (Integer)state.m_61143_((Property)AGE) == 0;
    }

    public boolean shouldDecay(BlockState state) {
        return (Integer)state.m_61143_((Property)f_54418_) == 7 && (Boolean)state.m_61143_((Property)f_54419_) == false;
    }

    public boolean canGrow(BlockState state) {
        return (Integer)state.m_61143_((Property)AGE) > 0 && ((Boolean)state.m_61143_((Property)f_54419_) == false || (Integer)state.m_61143_((Property)f_54418_) == 1);
    }

    public BlockState m_7417_(BlockState state, Direction facing, BlockState facingState, LevelAccessor worldIn, BlockPos currentPos, BlockPos facingPos) {
        if (this.canGrow(state) || (Integer)state.m_61143_((Property)AGE) == 0) {
            return super.m_7417_(state, facing, facingState, worldIn, currentPos, facingPos);
        }
        return state;
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)this.m_49966_().m_61124_((Property)f_54419_, (Comparable)Boolean.valueOf(true));
    }

    public VoxelShape m_5939_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        Entity entity;
        EntityCollisionContext c;
        if (context instanceof EntityCollisionContext && (c = (EntityCollisionContext)context).m_193113_() != null && !((entity = c.m_193113_()) instanceof ItemEntity) && !(entity instanceof FlyingAnimal)) {
            return Shapes.m_83144_();
        }
        return Shapes.m_83040_();
    }

    public void m_142072_(Level worldIn, BlockState stateIn, BlockPos pos, Entity entityIn, float fallDistance) {
        super.m_142072_(worldIn, stateIn, pos, entityIn, fallDistance);
        if (!worldIn.f_46443_ && fallDistance >= 1.0f && (entityIn instanceof LivingEntity || entityIn instanceof FallingBlockEntity)) {
            GameEventListener receiver = CoreModule.LEAVES_TRAMPLE.post((LevelAccessor)worldIn, pos, entityIn);
            float deathRate = 1.0f;
            if (receiver instanceof FruitTreeBlockEntity) {
                deathRate = ((FruitTreeBlockEntity)receiver).getDeathRate();
            }
            for (BlockPos pos2 : BlockPos.m_121976_((int)(pos.m_123341_() - 1), (int)(pos.m_123342_() - 2), (int)(pos.m_123343_() - 1), (int)(pos.m_123341_() + 1), (int)pos.m_123342_(), (int)(pos.m_123343_() + 1))) {
                BlockState state = worldIn.m_8055_(pos2);
                if (!(state.m_60734_() instanceof FruitLeavesBlock)) continue;
                FruitLeavesBlock.dropFruit(worldIn, pos2, state, deathRate).get();
                if (this.type.get().carpet == null) continue;
                CarpetTreeDecorator.placeCarpet((LevelSimulatedReader)worldIn, pos2, this.type.get().carpet.m_49966_(), (arg_0, arg_1) -> ((Level)worldIn).m_46597_(arg_0, arg_1));
            }
        }
    }

    public InteractionResult m_6227_(BlockState state, Level worldIn, BlockPos pos, Player playerIn, InteractionHand hand, BlockHitResult ray) {
        if ((Integer)state.m_61143_((Property)AGE) == 3 && worldIn.m_46597_(pos, (BlockState)state.m_61124_((Property)AGE, (Comparable)Integer.valueOf(1)))) {
            if (!worldIn.f_46443_) {
                ItemStack fruit = new ItemStack((ItemLike)this.type.get().fruit);
                if (playerIn instanceof FakePlayer) {
                    FruitLeavesBlock.m_152435_((Level)worldIn, (BlockPos)pos, (Direction)ray.m_82434_(), (ItemStack)fruit);
                } else {
                    ItemHandlerHelper.giveItemToPlayer((Player)playerIn, (ItemStack)fruit);
                }
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public BlockPathTypes getAiPathNodeType(BlockState state, BlockGetter world, BlockPos pos, Mob entity) {
        if (entity instanceof FlyingAnimal) {
            return BlockPathTypes.OPEN;
        }
        return null;
    }

    public boolean hasBlockEntity(BlockState state) {
        return (Boolean)state.m_61143_((Property)f_54419_) != false && (Integer)state.m_61143_((Property)f_54418_) == 1;
    }

    public BlockEntity m_142194_(BlockPos pPos, BlockState state) {
        if (this.hasBlockEntity(state)) {
            return new FruitTreeBlockEntity(pPos, state, this.type.get());
        }
        return null;
    }

    public <T extends BlockEntity> GameEventListener m_142226_(Level level, T blockEntity) {
        if (level.f_46443_) {
            return null;
        }
        return blockEntity instanceof FruitTreeBlockEntity ? (FruitTreeBlockEntity)blockEntity : null;
    }
}

