/*
 * Decompiled with CFR 0.152.
 */
package snownee.fruits.hybridization;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import com.mojang.datafixers.util.Either;
import java.util.ArrayList;
import java.util.Collection;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.ForgeRegistryEntry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import snownee.fruits.FruitType;
import snownee.fruits.hybridization.HybridingContext;
import snownee.fruits.hybridization.Hybridization;
import snownee.kiwi.recipe.Simple;

public class HybridingRecipe
extends Simple<HybridingContext> {
    protected final Either<FruitType, Block> result;
    public final ImmutableSet<Either<FruitType, Block>> ingredients;

    public HybridingRecipe(ResourceLocation id, Either<FruitType, Block> result, ImmutableSet<Either<FruitType, Block>> ingredients) {
        super(id);
        this.result = result;
        this.ingredients = ingredients;
    }

    public boolean matches(HybridingContext inv, Level worldIn) {
        return this.ingredients.stream().allMatch(inv.ingredients::contains);
    }

    public Either<FruitType, Block> getResult(Collection<Either<FruitType, Block>> types) {
        return this.result;
    }

    public Block getResultAsBlock(Collection<Either<FruitType, Block>> types) {
        return (Block)this.getResult(types).map(t -> t.leaves, b -> b);
    }

    public RecipeSerializer<?> m_7707_() {
        return Hybridization.SERIALIZER;
    }

    public RecipeType<?> m_6671_() {
        return Hybridization.RECIPE_TYPE;
    }

    public static class Serializer
    extends ForgeRegistryEntry<RecipeSerializer<?>>
    implements RecipeSerializer<HybridingRecipe> {
        public HybridingRecipe fromJson(ResourceLocation recipeId, JsonObject json) {
            Either<FruitType, Block> result = Serializer.readIngredient(GsonHelper.m_13930_((JsonObject)json, (String)"result"));
            ImmutableSet.Builder builder = ImmutableSet.builder();
            JsonArray ingredients = GsonHelper.m_13933_((JsonObject)json, (String)"ingredients");
            if (ingredients.size() < 2 || ingredients.size() > 4) {
                throw new JsonSyntaxException("Size of ingredients has to be in [2, 4]");
            }
            ingredients.forEach(e -> builder.add(Serializer.readIngredient(e.getAsJsonObject())));
            return new HybridingRecipe(recipeId, result, (ImmutableSet<Either<FruitType, Block>>)builder.build());
        }

        protected static Either<FruitType, Block> readIngredient(JsonObject object) {
            if (object.has("block")) {
                Block block = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(GsonHelper.m_13906_((JsonObject)object, (String)"block")));
                return Either.right((Object)block);
            }
            if (object.has("fruit")) {
                FruitType type = FruitType.parse(GsonHelper.m_13906_((JsonObject)object, (String)"fruit"));
                return Either.left((Object)((Object)type));
            }
            throw new JsonSyntaxException("Expect key 'block' or 'fruit'");
        }

        public HybridingRecipe fromNetwork(ResourceLocation recipeId, FriendlyByteBuf buffer) {
            int i;
            Either result = buffer.readBoolean() ? Either.left((Object)((Object)FruitType.parse(buffer.m_130136_(255)))) : Either.right((Object)((Block)buffer.readRegistryIdUnsafe(ForgeRegistries.BLOCKS)));
            ImmutableSet.Builder builder = ImmutableSet.builder();
            int size = buffer.readByte();
            for (i = 0; i < size; ++i) {
                Block block = (Block)buffer.readRegistryIdUnsafe(ForgeRegistries.BLOCKS);
                builder.add((Object)Either.right((Object)block));
            }
            size = buffer.readByte();
            for (i = 0; i < size; ++i) {
                builder.add((Object)Either.left((Object)((Object)FruitType.parse(buffer.m_130136_(255)))));
            }
            return new HybridingRecipe(recipeId, (Either<FruitType, Block>)result, (ImmutableSet<Either<FruitType, Block>>)builder.build());
        }

        public void toNetwork(FriendlyByteBuf buffer, HybridingRecipe recipe) {
            recipe.result.ifLeft(type -> {
                buffer.writeBoolean(true);
                buffer.m_130072_(type.name(), 255);
            }).ifRight(block -> {
                buffer.writeBoolean(false);
                buffer.writeRegistryIdUnsafe(ForgeRegistries.BLOCKS, (IForgeRegistryEntry)block);
            });
            ArrayList types = Lists.newArrayList();
            ArrayList blocks = Lists.newArrayList();
            recipe.ingredients.forEach(e -> e.map(types::add, blocks::add));
            buffer.writeByte(blocks.size());
            for (Block block2 : blocks) {
                buffer.writeRegistryIdUnsafe(ForgeRegistries.BLOCKS, (IForgeRegistryEntry)block2);
            }
            buffer.writeByte(types.size());
            for (FruitType type2 : types) {
                buffer.m_130072_(type2.name(), 255);
            }
        }
    }
}

