/*
 * Decompiled with CFR 0.152.
 */
package snownee.fruits.levelgen.treedecorators;

import com.mojang.serialization.Codec;
import java.util.List;
import java.util.Random;
import java.util.function.BiConsumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecorator;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecoratorType;
import snownee.fruits.CoreModule;

public class CarpetTreeDecorator
extends TreeDecorator {
    public static final Codec<CarpetTreeDecorator> CODEC = BlockStateProvider.f_68747_.fieldOf("provider").xmap(CarpetTreeDecorator::new, decorator -> decorator.carpetProvider).codec();
    private final BlockStateProvider carpetProvider;

    public CarpetTreeDecorator(BlockStateProvider carpetProvider) {
        this.carpetProvider = carpetProvider;
    }

    protected TreeDecoratorType<?> m_6663_() {
        return CoreModule.CARPET_DECORATOR;
    }

    public void m_142741_(LevelSimulatedReader pLevel, BiConsumer<BlockPos, BlockState> pBlockSetter, Random pRandom, List<BlockPos> pLogPositions, List<BlockPos> pLeafPositions) {
        if (pLeafPositions.isEmpty()) {
            return;
        }
        int y = pLeafPositions.get(0).m_123342_() + 1;
        for (BlockPos pos : pLeafPositions) {
            if (pos.m_123342_() > y) break;
            CarpetTreeDecorator.placeCarpet(pLevel, pos, this.carpetProvider.m_7112_(pRandom, pos), pBlockSetter);
        }
    }

    public static boolean placeCarpet(LevelSimulatedReader world, BlockPos pos, BlockState carpet, BiConsumer<BlockPos, BlockState> pBlockSetter) {
        int i = 0;
        BlockPos.MutableBlockPos ground = pos.m_122032_();
        while (++i < 5) {
            ground.m_122173_(Direction.DOWN);
            if (world.m_7433_((BlockPos)ground, CarpetTreeDecorator::isReplaceable)) continue;
            if (i != 1) break;
            return false;
        }
        if (!Feature.m_65788_((LevelSimulatedReader)world, (BlockPos)ground)) {
            return false;
        }
        pBlockSetter.accept((BlockPos)ground.m_122173_(Direction.UP), carpet);
        return true;
    }

    private static boolean isReplaceable(BlockState state) {
        return state.m_60795_() || state.m_60713_(Blocks.f_50359_) || state.m_60713_(Blocks.f_50035_);
    }
}

