/*
 * Decompiled with CFR 0.152.
 */
package snownee.fruits.plugin.jei;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.datafixers.util.Either;
import com.mojang.math.Quaternion;
import com.mojang.math.Vector3f;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IGuiItemStackGroup;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.Tag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.animal.Bee;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import snownee.fruits.CoreModule;
import snownee.fruits.FruitType;
import snownee.fruits.hybridization.HybridingRecipe;
import snownee.fruits.plugin.jei.JEIPlugin;

public class HybridingCategory
implements IRecipeCategory<HybridingRecipe> {
    private final TranslatableComponent localizedName;
    private final IDrawable icon;
    private final IDrawable background;
    private final IGuiHelper guiHelper;
    private final Bee bee;
    private final IDrawable x;
    private final IDrawable line;
    public static final int width = 116;
    public static final int height = 54;

    public HybridingCategory(IGuiHelper guiHelper) {
        this.guiHelper = guiHelper;
        this.localizedName = new TranslatableComponent("gui.fruittrees.jei.category.hybriding");
        this.icon = guiHelper.createDrawableIngredient((Object)CoreModule.GRAPEFRUIT.m_7968_());
        this.background = guiHelper.createBlankDrawable(116, 54);
        float f = (float)Math.atan(25.0);
        float f1 = (float)Math.atan(-0.25);
        this.bee = (Bee)EntityType.f_20550_.m_20615_((Level)Minecraft.m_91087_().f_91073_);
        this.bee.f_20883_ = 180.0f + f * 20.0f;
        this.bee.m_146922_(180.0f + f * 40.0f);
        this.bee.m_146926_(-f1 * 20.0f);
        this.bee.f_20885_ = this.bee.m_146908_();
        this.bee.f_20886_ = this.bee.m_146908_();
        this.x = guiHelper.drawableBuilder(new ResourceLocation("fruittrees", "textures/gui/jei.png"), 0, 0, 10, 11).setTextureSize(64, 64).build();
        this.line = guiHelper.drawableBuilder(new ResourceLocation("fruittrees", "textures/gui/jei.png"), 12, 4, 31, 3).setTextureSize(64, 64).build();
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public Component getTitle() {
        return this.localizedName;
    }

    public void draw(HybridingRecipe recipe, PoseStack matrix, double mouseX, double mouseY) {
        this.x.draw(matrix, 18, 22);
        this.line.draw(matrix, 54, 26);
        matrix.m_85836_();
        matrix.m_85837_(70.0, 24.0, 0.0);
        matrix.m_85841_(20.0f, 20.0f, -20.0f);
        float f1 = (float)Math.atan(-0.25);
        Quaternion quaternion = Vector3f.f_122227_.m_122240_(180.0f);
        Quaternion quaternion1 = Vector3f.f_122223_.m_122240_(f1 * 20.0f);
        quaternion.m_80148_(quaternion1);
        matrix.m_85845_(quaternion);
        Minecraft mc = Minecraft.m_91087_();
        EntityRenderDispatcher entityrenderermanager = mc.m_91290_();
        quaternion1.m_80157_();
        entityrenderermanager.m_114412_(quaternion1);
        entityrenderermanager.m_114468_(false);
        MultiBufferSource.BufferSource irendertypebuffer$impl = mc.m_91269_().m_110104_();
        this.bee.f_19797_ = mc.f_91074_.f_19797_;
        entityrenderermanager.m_114384_((Entity)this.bee, 0.0, 0.0, 0.0, mc.m_91296_(), 1.0f, matrix, (MultiBufferSource)irendertypebuffer$impl, 0xF000F0);
        irendertypebuffer$impl.m_109911_();
        entityrenderermanager.m_114468_(true);
        matrix.m_85849_();
    }

    public ResourceLocation getUid() {
        return JEIPlugin.UID;
    }

    public void setIngredients(HybridingRecipe recipe, IIngredients ingredients) {
        Either<FruitType, Block> result = recipe.getResult((Collection<Either<FruitType, Block>>)recipe.ingredients);
        ImmutableList.Builder outputs = ImmutableList.builder();
        result.ifLeft(t -> outputs.add((Object[])new ItemStack[]{t.sapling.get().m_5456_().m_7968_(), t.fruit.m_5456_().m_7968_()})).ifRight(b -> outputs.add((Object)b.m_5456_().m_7968_()));
        ingredients.setOutputLists(VanillaTypes.ITEM, Collections.singletonList(outputs.build()));
        List inputs = recipe.ingredients.stream().map(HybridingCategory::asItem).collect(Collectors.toList());
        ingredients.setInputs(VanillaTypes.ITEM, inputs);
    }

    public static ItemStack asItem(Either<FruitType, Block> either) {
        Optional left = either.left();
        if (left.isPresent()) {
            return ((FruitType)((Object)left.get())).leaves.m_5456_().m_7968_();
        }
        return ((Block)either.right().get()).m_5456_().m_7968_();
    }

    public void setRecipe(IRecipeLayout layout, HybridingRecipe recipe, IIngredients ingredients) {
        IGuiItemStackGroup guiItemStacks = layout.getItemStacks();
        guiItemStacks.init(0, false, 94, 18);
        guiItemStacks.set(0, (List)ingredients.getOutputs(VanillaTypes.ITEM).get(0));
        guiItemStacks.setBackground(0, (IDrawable)this.guiHelper.getSlotDrawable());
        guiItemStacks.addTooltipCallback((slot, input, stack, tooltip) -> {
            if (tooltip.isEmpty()) {
                return;
            }
            if (input && stack.m_150922_((Tag)ItemTags.f_13143_)) {
                TranslatableComponent line = new TranslatableComponent("gui.fruittrees.jei.tip.flowering", new Object[]{tooltip.get(0)});
                tooltip.set(0, line);
            }
        });
        int size = recipe.ingredients.size();
        int x = 0;
        int y = size > 2 ? 5 : 18;
        for (int i = 0; i < size; ++i) {
            guiItemStacks.init(1 + i, true, x, y);
            guiItemStacks.set(1 + i, (List)ingredients.getInputs(VanillaTypes.ITEM).get(i));
            guiItemStacks.setBackground(1 + i, (IDrawable)this.guiHelper.getSlotDrawable());
            if (i == 1) {
                x = 0;
                y += 28;
                continue;
            }
            x += 28;
        }
        if (size == 3) {
            guiItemStacks.init(4, true, 28, y);
            guiItemStacks.set(4, (ItemStack)null);
            guiItemStacks.setBackground(4, (IDrawable)this.guiHelper.getSlotDrawable());
        }
    }

    public Class<? extends HybridingRecipe> getRecipeClass() {
        return HybridingRecipe.class;
    }
}

