/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.sodium.client;

import java.io.IOException;
import me.jellysquid.mods.sodium.client.gui.SodiumGameOptions;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="rubidium")
public class SodiumClientMod {
    private static SodiumGameOptions CONFIG;
    private static Logger LOGGER;
    private static String MOD_VERSION;
    public static final String MODID = "rubidium";
    public static boolean flywheelLoaded;

    public SodiumClientMod() {
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::setup);
    }

    public void setup(FMLClientSetupEvent event) {
        CONFIG = SodiumClientMod.loadConfig();
        flywheelLoaded = ModList.get().isLoaded("flywheel");
    }

    public static SodiumGameOptions options() {
        if (CONFIG == null) {
            CONFIG = SodiumClientMod.loadConfig();
        }
        return CONFIG;
    }

    public static Logger logger() {
        if (LOGGER == null) {
            throw new IllegalStateException("Logger not yet available");
        }
        return LOGGER;
    }

    private static SodiumGameOptions loadConfig() {
        try {
            return SodiumGameOptions.load();
        }
        catch (Exception e) {
            LOGGER.error("Failed to load configuration file", (Throwable)e);
            LOGGER.error("Using default configuration file in read-only mode");
            SodiumGameOptions config = new SodiumGameOptions();
            config.setReadOnly();
            return config;
        }
    }

    public static void restoreDefaultOptions() {
        CONFIG = SodiumGameOptions.defaults();
        try {
            CONFIG.writeChanges();
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to write config file", e);
        }
    }

    public static String getVersion() {
        if (MOD_VERSION == null) {
            throw new NullPointerException("Mod version hasn't been populated yet");
        }
        return MOD_VERSION;
    }

    public static boolean isDirectMemoryAccessEnabled() {
        return SodiumClientMod.options().advanced.allowDirectMemoryAccess;
    }

    static {
        LOGGER = LogManager.getLogger((String)"Rubidium");
        MOD_VERSION = "0.5.0";
        flywheelLoaded = false;
    }
}

