/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.sodium.client.render.chunk.tasks;

import java.util.EnumMap;
import java.util.Objects;
import me.jellysquid.mods.sodium.client.compat.FlywheelCompat;
import me.jellysquid.mods.sodium.client.gl.compile.ChunkBuildContext;
import me.jellysquid.mods.sodium.client.render.chunk.RenderSection;
import me.jellysquid.mods.sodium.client.render.chunk.compile.ChunkBuildBuffers;
import me.jellysquid.mods.sodium.client.render.chunk.compile.ChunkBuildResult;
import me.jellysquid.mods.sodium.client.render.chunk.data.ChunkMeshData;
import me.jellysquid.mods.sodium.client.render.chunk.data.ChunkRenderBounds;
import me.jellysquid.mods.sodium.client.render.chunk.data.ChunkRenderData;
import me.jellysquid.mods.sodium.client.render.chunk.passes.BlockRenderPass;
import me.jellysquid.mods.sodium.client.render.chunk.tasks.ChunkRenderBuildTask;
import me.jellysquid.mods.sodium.client.render.pipeline.context.ChunkRenderCacheLocal;
import me.jellysquid.mods.sodium.client.util.task.CancellationSource;
import me.jellysquid.mods.sodium.client.world.WorldSlice;
import me.jellysquid.mods.sodium.client.world.cloned.ChunkRenderContext;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.chunk.VisGraph;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.client.model.ModelDataManager;
import net.minecraftforge.client.model.data.IModelData;

public class ChunkRenderRebuildTask
extends ChunkRenderBuildTask {
    private final RenderSection render;
    private final ChunkRenderContext renderContext;
    private final int frame;

    public ChunkRenderRebuildTask(RenderSection render, ChunkRenderContext renderContext, int frame) {
        this.render = render;
        this.renderContext = renderContext;
        this.frame = frame;
    }

    @Override
    public ChunkBuildResult performBuild(ChunkBuildContext buildContext, CancellationSource cancellationSource) {
        ChunkRenderData.Builder renderData = new ChunkRenderData.Builder();
        VisGraph occluder = new VisGraph();
        ChunkRenderBounds.Builder bounds = new ChunkRenderBounds.Builder();
        ChunkBuildBuffers buffers = buildContext.buffers;
        buffers.init(renderData, this.render.getChunkId());
        ChunkRenderCacheLocal cache = buildContext.cache;
        cache.init(this.renderContext);
        WorldSlice slice = cache.getWorldSlice();
        int minX = this.render.getOriginX();
        int minY = this.render.getOriginY();
        int minZ = this.render.getOriginZ();
        int maxX = minX + 16;
        int maxY = minY + 16;
        int maxZ = minZ + 16;
        BlockPos.MutableBlockPos blockPos = new BlockPos.MutableBlockPos();
        BlockPos.MutableBlockPos offset = new BlockPos.MutableBlockPos();
        for (int y = minY; y < maxY; ++y) {
            if (cancellationSource.isCancelled()) {
                return null;
            }
            for (int z = minZ; z < maxZ; ++z) {
                for (int x = minX; x < maxX; ++x) {
                    BlockEntityRenderer renderer;
                    BlockEntity entity;
                    FluidState fluidState;
                    BlockState blockState = slice.getBlockState(x, y, z);
                    if (blockState.m_60795_()) continue;
                    blockPos.m_122178_(x, y, z);
                    offset.m_122178_(x & 0xF, y & 0xF, z & 0xF);
                    boolean rendered = false;
                    if (blockState.m_60799_() == RenderShape.MODEL) {
                        for (RenderType layer : RenderType.m_110506_()) {
                            if (!ItemBlockRenderTypes.canRenderInLayer((BlockState)blockState, (RenderType)layer)) continue;
                            ForgeHooksClient.setRenderType((RenderType)layer);
                            IModelData modelData = ModelDataManager.getModelData((Level)((Level)Objects.requireNonNull(Minecraft.m_91087_().f_91073_)), (BlockPos)blockPos);
                            BakedModel model = cache.getBlockModels().m_110893_(blockState);
                            long seed = blockState.m_60726_((BlockPos)blockPos);
                            if (cache.getBlockRenderer().renderModel(slice, blockState, (BlockPos)blockPos, (BlockPos)offset, model, buffers.get(layer), true, seed, modelData)) {
                                rendered = true;
                            }
                            ForgeHooksClient.setRenderType(null);
                        }
                    }
                    if (!(fluidState = blockState.m_60819_()).m_76178_()) {
                        RenderType layer;
                        layer = ItemBlockRenderTypes.m_109287_((FluidState)fluidState);
                        if (cache.getFluidRenderer().render(slice, fluidState, (BlockPos)blockPos, (BlockPos)offset, buffers.get(layer))) {
                            rendered = true;
                        }
                    }
                    if (blockState.m_155947_() && (entity = slice.m_7702_((BlockPos)blockPos)) != null && (renderer = Minecraft.m_91087_().m_167982_().m_112265_(entity)) != null && FlywheelCompat.addAndFilterBEs(entity)) {
                        renderData.addBlockEntity(entity, !renderer.m_5932_(entity));
                        rendered = true;
                    }
                    if (blockState.m_60804_((BlockGetter)slice, (BlockPos)blockPos)) {
                        occluder.m_112971_((BlockPos)blockPos);
                    }
                    if (!rendered) continue;
                    bounds.addBlock(x & 0xF, y & 0xF, z & 0xF);
                }
            }
        }
        EnumMap<BlockRenderPass, ChunkMeshData> meshes = new EnumMap<BlockRenderPass, ChunkMeshData>(BlockRenderPass.class);
        for (BlockRenderPass pass : BlockRenderPass.VALUES) {
            ChunkMeshData mesh = buffers.createMesh(pass);
            if (mesh == null) continue;
            meshes.put(pass, mesh);
        }
        renderData.setOcclusionData(occluder.m_112958_());
        renderData.setBounds(bounds.build(this.render.getChunkPos()));
        return new ChunkBuildResult(this.render, renderData.build(), meshes, this.frame);
    }
}

