/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.sodium.client.render.pipeline;

import me.jellysquid.mods.sodium.client.model.light.LightMode;
import me.jellysquid.mods.sodium.client.model.light.LightPipeline;
import me.jellysquid.mods.sodium.client.model.light.LightPipelineProvider;
import me.jellysquid.mods.sodium.client.model.light.data.QuadLightData;
import me.jellysquid.mods.sodium.client.model.quad.ModelQuad;
import me.jellysquid.mods.sodium.client.model.quad.ModelQuadView;
import me.jellysquid.mods.sodium.client.model.quad.ModelQuadViewMutable;
import me.jellysquid.mods.sodium.client.model.quad.blender.ColorBlender;
import me.jellysquid.mods.sodium.client.model.quad.blender.ColorSampler;
import me.jellysquid.mods.sodium.client.model.quad.properties.ModelQuadFacing;
import me.jellysquid.mods.sodium.client.model.quad.properties.ModelQuadWinding;
import me.jellysquid.mods.sodium.client.render.chunk.compile.buffers.ChunkModelBuilder;
import me.jellysquid.mods.sodium.client.render.chunk.format.ModelVertexSink;
import me.jellysquid.mods.sodium.client.util.Norm3b;
import me.jellysquid.mods.sodium.client.util.color.ColorABGR;
import me.jellysquid.mods.sodium.common.util.DirectionUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.Tag;
import net.minecraft.util.Mth;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.SupportType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.client.ForgeHooksClient;
import org.jetbrains.annotations.Nullable;

public class FluidRenderer {
    private static final float EPSILON = 0.001f;
    private final BlockPos.MutableBlockPos scratchPos = new BlockPos.MutableBlockPos();
    private final TextureAtlasSprite waterOverlaySprite;
    private final ModelQuadViewMutable quad = new ModelQuad();
    private final LightPipelineProvider lighters;
    private final ColorBlender colorBlender;
    private final FabricFluidColorizerAdapter fabricColorProviderAdapter = new FabricFluidColorizerAdapter();
    private final QuadLightData quadLightData = new QuadLightData();
    private final int[] quadColors = new int[4];

    public FluidRenderer(LightPipelineProvider lighters, ColorBlender colorBlender) {
        this.waterOverlaySprite = ModelBakery.f_119223_.m_119204_();
        int normal = Norm3b.pack(0.0f, 1.0f, 0.0f);
        for (int i = 0; i < 4; ++i) {
            this.quad.setNormal(i, normal);
        }
        this.lighters = lighters;
        this.colorBlender = colorBlender;
    }

    private boolean isFluidOccluded(BlockAndTintGetter world, int x, int y, int z, Direction dir, Fluid fluid) {
        BlockPos.MutableBlockPos pos = this.scratchPos.m_122178_(x, y, z);
        BlockState blockState = world.m_8055_((BlockPos)pos);
        BlockPos.MutableBlockPos adjPos = this.scratchPos.m_122178_(x + dir.m_122429_(), y + dir.m_122430_(), z + dir.m_122431_());
        if (blockState.m_60815_()) {
            return world.m_6425_((BlockPos)adjPos).m_76152_().m_6212_(fluid) || blockState.m_60659_((BlockGetter)world, (BlockPos)pos, dir, SupportType.FULL);
        }
        return world.m_6425_((BlockPos)adjPos).m_76152_().m_6212_(fluid);
    }

    private boolean isSideExposed(BlockAndTintGetter world, int x, int y, int z, Direction dir, float height) {
        BlockPos.MutableBlockPos pos = this.scratchPos.m_122178_(x + dir.m_122429_(), y + dir.m_122430_(), z + dir.m_122431_());
        BlockState blockState = world.m_8055_((BlockPos)pos);
        if (blockState.m_60815_()) {
            VoxelShape shape = blockState.m_60768_((BlockGetter)world, (BlockPos)pos);
            if (shape == Shapes.m_83144_()) {
                return dir == Direction.UP;
            }
            if (shape.m_83281_()) {
                return true;
            }
            VoxelShape threshold = Shapes.m_83048_((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)height, (double)1.0);
            return !Shapes.m_83117_((VoxelShape)threshold, (VoxelShape)shape, (Direction)dir);
        }
        return true;
    }

    public boolean render(BlockAndTintGetter world, FluidState fluidState, BlockPos pos, BlockPos offset, ChunkModelBuilder buffers) {
        int posX = pos.m_123341_();
        int posY = pos.m_123342_();
        int posZ = pos.m_123343_();
        Fluid fluid = fluidState.m_76152_();
        boolean sfUp = this.isFluidOccluded(world, posX, posY, posZ, Direction.UP, fluid);
        boolean sfDown = this.isFluidOccluded(world, posX, posY, posZ, Direction.DOWN, fluid) || !this.isSideExposed(world, posX, posY, posZ, Direction.DOWN, 0.8888889f);
        boolean sfNorth = this.isFluidOccluded(world, posX, posY, posZ, Direction.NORTH, fluid);
        boolean sfSouth = this.isFluidOccluded(world, posX, posY, posZ, Direction.SOUTH, fluid);
        boolean sfWest = this.isFluidOccluded(world, posX, posY, posZ, Direction.WEST, fluid);
        boolean sfEast = this.isFluidOccluded(world, posX, posY, posZ, Direction.EAST, fluid);
        if (sfUp && sfDown && sfEast && sfWest && sfNorth && sfSouth) {
            return false;
        }
        boolean isWater = fluidState.m_76153_((Tag)FluidTags.f_13131_);
        ColorSampler<FluidState> colorizer = this.createColorProviderAdapter(world, pos, fluidState);
        TextureAtlasSprite[] sprites = ForgeHooksClient.getFluidSprites((BlockAndTintGetter)world, (BlockPos)pos, (FluidState)fluidState);
        boolean rendered = false;
        float h1 = this.getCornerHeight(world, posX, posY, posZ, fluidState.m_76152_());
        float h2 = this.getCornerHeight(world, posX, posY, posZ + 1, fluidState.m_76152_());
        float h3 = this.getCornerHeight(world, posX + 1, posY, posZ + 1, fluidState.m_76152_());
        float h4 = this.getCornerHeight(world, posX + 1, posY, posZ, fluidState.m_76152_());
        float yOffset = sfDown ? 0.0f : 0.001f;
        ModelQuadViewMutable quad = this.quad;
        LightMode lightMode = isWater && Minecraft.m_91086_() ? LightMode.SMOOTH : LightMode.FLAT;
        LightPipeline lighter = this.lighters.getLighter(lightMode);
        quad.setFlags(0);
        if (!sfUp && this.isSideExposed(world, posX, posY, posZ, Direction.UP, Math.min(Math.min(h1, h2), Math.min(h3, h4)))) {
            float v4;
            float u4;
            float v3;
            float u3;
            float v2;
            float u2;
            float v1;
            float u1;
            ModelQuadFacing facing;
            TextureAtlasSprite sprite;
            h1 -= 0.001f;
            h2 -= 0.001f;
            h3 -= 0.001f;
            h4 -= 0.001f;
            Vec3 velocity = fluidState.m_76179_((BlockGetter)world, pos);
            if (velocity.f_82479_ == 0.0 && velocity.f_82481_ == 0.0) {
                sprite = sprites[0];
                facing = ModelQuadFacing.UP;
                u1 = sprite.m_118367_(0.0);
                v1 = sprite.m_118393_(0.0);
                u2 = u1;
                v2 = sprite.m_118393_(16.0);
                u3 = sprite.m_118367_(16.0);
                v3 = v2;
                u4 = u3;
                v4 = v1;
            } else {
                sprite = sprites[1];
                facing = ModelQuadFacing.UNASSIGNED;
                float dir = (float)Mth.m_14136_((double)velocity.f_82481_, (double)velocity.f_82479_) - 1.5707964f;
                float sin = Mth.m_14031_((float)dir) * 0.25f;
                float cos = Mth.m_14089_((float)dir) * 0.25f;
                u1 = sprite.m_118367_((double)(8.0f + (-cos - sin) * 16.0f));
                v1 = sprite.m_118393_((double)(8.0f + (-cos + sin) * 16.0f));
                u2 = sprite.m_118367_((double)(8.0f + (-cos + sin) * 16.0f));
                v2 = sprite.m_118393_((double)(8.0f + (cos + sin) * 16.0f));
                u3 = sprite.m_118367_((double)(8.0f + (cos + sin) * 16.0f));
                v3 = sprite.m_118393_((double)(8.0f + (cos - sin) * 16.0f));
                u4 = sprite.m_118367_((double)(8.0f + (cos - sin) * 16.0f));
                v4 = sprite.m_118393_((double)(8.0f + (-cos - sin) * 16.0f));
            }
            float uAvg = (u1 + u2 + u3 + u4) / 4.0f;
            float vAvg = (v1 + v2 + v3 + v4) / 4.0f;
            float s1 = (float)sprites[0].m_118405_() / (sprites[0].m_118410_() - sprites[0].m_118409_());
            float s2 = (float)sprites[0].m_118408_() / (sprites[0].m_118412_() - sprites[0].m_118411_());
            float s3 = 4.0f / Math.max(s2, s1);
            u1 = Mth.m_14179_((float)s3, (float)u1, (float)uAvg);
            u2 = Mth.m_14179_((float)s3, (float)u2, (float)uAvg);
            u3 = Mth.m_14179_((float)s3, (float)u3, (float)uAvg);
            u4 = Mth.m_14179_((float)s3, (float)u4, (float)uAvg);
            v1 = Mth.m_14179_((float)s3, (float)v1, (float)vAvg);
            v2 = Mth.m_14179_((float)s3, (float)v2, (float)vAvg);
            v3 = Mth.m_14179_((float)s3, (float)v3, (float)vAvg);
            v4 = Mth.m_14179_((float)s3, (float)v4, (float)vAvg);
            quad.setSprite(sprite);
            this.setVertex(quad, 0, 0.0f, h1, 0.0f, u1, v1);
            this.setVertex(quad, 1, 0.0f, h2, 1.0f, u2, v2);
            this.setVertex(quad, 2, 1.0f, h3, 1.0f, u3, v3);
            this.setVertex(quad, 3, 1.0f, h4, 0.0f, u4, v4);
            this.calculateQuadColors(quad, world, pos, lighter, Direction.UP, 1.0f, colorizer, fluidState);
            int vertexStart = this.writeVertices(buffers, offset, quad);
            buffers.getIndexBufferBuilder(facing).add(vertexStart, ModelQuadWinding.CLOCKWISE);
            if (fluidState.m_76171_((BlockGetter)world, (BlockPos)this.scratchPos.m_122178_(posX, posY + 1, posZ))) {
                buffers.getIndexBufferBuilder(ModelQuadFacing.DOWN).add(vertexStart, ModelQuadWinding.COUNTERCLOCKWISE);
            }
            rendered = true;
        }
        if (!sfDown) {
            TextureAtlasSprite sprite = sprites[0];
            float minU = sprite.m_118409_();
            float maxU = sprite.m_118410_();
            float minV = sprite.m_118411_();
            float maxV = sprite.m_118412_();
            quad.setSprite(sprite);
            this.setVertex(quad, 0, 0.0f, yOffset, 1.0f, minU, maxV);
            this.setVertex(quad, 1, 0.0f, yOffset, 0.0f, minU, minV);
            this.setVertex(quad, 2, 1.0f, yOffset, 0.0f, maxU, minV);
            this.setVertex(quad, 3, 1.0f, yOffset, 1.0f, maxU, maxV);
            this.calculateQuadColors(quad, world, pos, lighter, Direction.DOWN, 1.0f, colorizer, fluidState);
            int vertexStart = this.writeVertices(buffers, offset, quad);
            buffers.getIndexBufferBuilder(ModelQuadFacing.DOWN).add(vertexStart, ModelQuadWinding.CLOCKWISE);
            rendered = true;
        }
        this.quad.setFlags(1);
        block6: for (Direction dir : DirectionUtil.HORIZONTAL_DIRECTIONS) {
            BlockPos.MutableBlockPos adjPos;
            BlockState adjBlock;
            float z2;
            float z1;
            float x2;
            float x1;
            float c2;
            float c1;
            switch (dir) {
                case NORTH: {
                    if (sfNorth) continue block6;
                    c1 = h1;
                    c2 = h4;
                    x1 = 0.0f;
                    x2 = 1.0f;
                    z2 = z1 = 0.001f;
                    break;
                }
                case SOUTH: {
                    if (sfSouth) continue block6;
                    c1 = h3;
                    c2 = h2;
                    x1 = 1.0f;
                    x2 = 0.0f;
                    z2 = z1 = 0.999f;
                    break;
                }
                case WEST: {
                    if (sfWest) continue block6;
                    c1 = h2;
                    c2 = h1;
                    x2 = x1 = 0.001f;
                    z1 = 1.0f;
                    z2 = 0.0f;
                    break;
                }
                case EAST: {
                    if (sfEast) continue block6;
                    c1 = h4;
                    c2 = h3;
                    x2 = x1 = 0.999f;
                    z1 = 0.0f;
                    z2 = 1.0f;
                    break;
                }
                default: {
                    continue block6;
                }
            }
            if (!this.isSideExposed(world, posX, posY, posZ, dir, Math.max(c1, c2))) continue;
            int adjX = posX + dir.m_122429_();
            int adjY = posY + dir.m_122430_();
            int adjZ = posZ + dir.m_122431_();
            TextureAtlasSprite sprite = sprites[1];
            if (isWater && !(adjBlock = world.m_8055_((BlockPos)(adjPos = this.scratchPos.m_122178_(adjX, adjY, adjZ)))).m_60815_() && !adjBlock.m_60795_()) {
                sprite = this.waterOverlaySprite;
            }
            float u1 = sprite.m_118367_(0.0);
            float u2 = sprite.m_118367_(8.0);
            float v1 = sprite.m_118393_((double)((1.0f - c1) * 16.0f * 0.5f));
            float v2 = sprite.m_118393_((double)((1.0f - c2) * 16.0f * 0.5f));
            float v3 = sprite.m_118393_(8.0);
            quad.setSprite(sprite);
            this.setVertex(quad, 0, x2, c2, z2, u2, v2);
            this.setVertex(quad, 1, x2, yOffset, z2, u2, v3);
            this.setVertex(quad, 2, x1, yOffset, z1, u1, v3);
            this.setVertex(quad, 3, x1, c1, z1, u1, v1);
            float br = dir.m_122434_() == Direction.Axis.Z ? 0.8f : 0.6f;
            ModelQuadFacing facing = ModelQuadFacing.fromDirection(dir);
            this.calculateQuadColors(quad, world, pos, lighter, dir, br, colorizer, fluidState);
            int vertexStart = this.writeVertices(buffers, offset, quad);
            buffers.getIndexBufferBuilder(facing).add(vertexStart, ModelQuadWinding.CLOCKWISE);
            if (sprite != this.waterOverlaySprite) {
                buffers.getIndexBufferBuilder(facing.getOpposite()).add(vertexStart, ModelQuadWinding.COUNTERCLOCKWISE);
            }
            rendered = true;
        }
        return rendered;
    }

    private ColorSampler<FluidState> createColorProviderAdapter(BlockAndTintGetter view, BlockPos pos, FluidState state) {
        FabricFluidColorizerAdapter adapter = this.fabricColorProviderAdapter;
        adapter.setHandler(view, pos, state);
        return adapter;
    }

    private void calculateQuadColors(ModelQuadView quad, BlockAndTintGetter world, BlockPos pos, LightPipeline lighter, Direction dir, float brightness, ColorSampler<FluidState> colorSampler, FluidState fluidState) {
        QuadLightData light = this.quadLightData;
        lighter.calculate(quad, pos, light, dir, false);
        int[] biomeColors = this.colorBlender.getColors(world, pos, quad, colorSampler, fluidState);
        for (int i = 0; i < 4; ++i) {
            this.quadColors[i] = ColorABGR.mul(biomeColors != null ? biomeColors[i] : -1, light.br[i] * brightness);
        }
    }

    private int writeVertices(ChunkModelBuilder builder, BlockPos offset, ModelQuadView quad) {
        ModelVertexSink vertices = builder.getVertexSink();
        vertices.ensureCapacity(4);
        int vertexStart = vertices.getVertexCount();
        for (int i = 0; i < 4; ++i) {
            float x = quad.getX(i);
            float y = quad.getY(i);
            float z = quad.getZ(i);
            int color = this.quadColors[i];
            float u = quad.getTexU(i);
            float v = quad.getTexV(i);
            int light = this.quadLightData.lm[i];
            vertices.writeVertex((Vec3i)offset, x, y, z, color, u, v, light, builder.getChunkId());
        }
        vertices.flush();
        TextureAtlasSprite sprite = quad.getSprite();
        if (sprite != null) {
            builder.addSprite(sprite);
        }
        return vertexStart;
    }

    private void setVertex(ModelQuadViewMutable quad, int i, float x, float y, float z, float u, float v) {
        quad.setX(i, x);
        quad.setY(i, y);
        quad.setZ(i, z);
        quad.setTexU(i, u);
        quad.setTexV(i, v);
    }

    private float getCornerHeight(BlockAndTintGetter world, int x, int y, int z, Fluid fluid) {
        int samples = 0;
        float totalHeight = 0.0f;
        for (int i = 0; i < 4; ++i) {
            int x2 = x - (i & 1);
            int z2 = z - (i >> 1 & 1);
            if (world.m_6425_((BlockPos)this.scratchPos.m_122178_(x2, y + 1, z2)).m_76152_().m_6212_(fluid)) {
                return 1.0f;
            }
            BlockPos.MutableBlockPos pos = this.scratchPos.m_122178_(x2, y, z2);
            BlockState blockState = world.m_8055_((BlockPos)pos);
            FluidState fluidState = blockState.m_60819_();
            if (fluidState.m_76152_().m_6212_(fluid)) {
                float height = fluidState.m_76155_((BlockGetter)world, (BlockPos)pos);
                if (height >= 0.8f) {
                    totalHeight += height * 10.0f;
                    samples += 10;
                    continue;
                }
                totalHeight += height;
                ++samples;
                continue;
            }
            if (blockState.m_60767_().m_76333_()) continue;
            ++samples;
        }
        return totalHeight / (float)samples;
    }

    private static class FabricFluidColorizerAdapter
    implements ColorSampler<FluidState> {
        private BlockAndTintGetter world;
        private BlockPos pos;
        private FluidState state;

        private FabricFluidColorizerAdapter() {
        }

        public void setHandler(BlockAndTintGetter world, BlockPos pos, FluidState state) {
            this.world = world;
            this.pos = pos;
            this.state = state;
        }

        @Override
        public int getColor(FluidState state, @Nullable BlockAndTintGetter world, @Nullable BlockPos pos, int tintIndex) {
            if (this.world == null || this.state == null) {
                return -1;
            }
            return state.m_76152_().getAttributes().getColor(world, pos);
        }
    }
}

