/*
 * Decompiled with CFR 0.152.
 */
package mod.noobulus.tetrapak.effects.create;

import com.simibubi.create.AllItems;
import java.util.Collection;
import javax.annotation.Nullable;
import mod.noobulus.tetrapak.util.DamageBufferer;
import mod.noobulus.tetrapak.util.IEventBusListener;
import mod.noobulus.tetrapak.util.MathHelper;
import mod.noobulus.tetrapak.util.tetra_definitions.IHoloDescription;
import mod.noobulus.tetrapak.util.tetra_definitions.ITetraEffect;
import net.minecraft.core.BlockPos;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.entity.living.LivingExperienceDropEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import se.mickelus.tetra.effect.ItemEffect;

public class SolidifyingEffect
implements IHoloDescription,
IEventBusListener {
    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void solidifyKillExp(LivingExperienceDropEvent event) {
        LivingEntity target = event.getEntityLiving();
        DamageSource lastActive = DamageBufferer.getLastActiveDamageSource();
        if (this.shouldSolidifyingAffect(lastActive, (Entity)target)) {
            int chunks = MathHelper.doubleToIntWithChance((double)event.getDroppedExperience() / 3.0);
            Collection drops = event.getEntity().captureDrops();
            if (drops != null) {
                drops.add(new ItemEntity(target.f_19853_, target.m_20182_().f_82479_, target.m_20182_().f_82480_, target.m_20182_().f_82481_, new ItemStack((ItemLike)AllItems.EXP_NUGGET.get(), chunks)));
            } else {
                target.f_19853_.m_7967_((Entity)new ItemEntity(target.f_19853_, target.m_20182_().f_82479_, target.m_20182_().f_82480_, target.m_20182_().f_82481_, new ItemStack((ItemLike)AllItems.EXP_NUGGET.get(), chunks)));
            }
            event.setDroppedExperience(0);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void solidifyBlockExp(BlockEvent.BreakEvent event) {
        ItemStack heldItemMainhand = event.getPlayer().m_21205_();
        if (this.hasEffect(heldItemMainhand)) {
            BlockPos pos = event.getPos();
            Level level = event.getPlayer().m_183503_();
            int chunks = MathHelper.doubleToIntWithChance((double)event.getExpToDrop() / 3.0);
            level.m_7967_((Entity)new ItemEntity(level, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, new ItemStack((ItemLike)AllItems.EXP_NUGGET.get(), chunks)));
            event.setExpToDrop(0);
        }
    }

    private boolean shouldSolidifyingAffect(@Nullable DamageSource source, Entity target) {
        if (target instanceof Player) {
            return false;
        }
        return this.hasEffect(source);
    }

    @Override
    public ItemEffect getEffect() {
        return ITetraEffect.get("solidifying");
    }
}

