/*
 * Decompiled with CFR 0.152.
 */
package mod.noobulus.tetrapak.effects.create.recipes;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.simibubi.create.content.contraptions.components.deployer.DeployerFakePlayer;
import com.simibubi.create.content.contraptions.components.deployer.DeployerTileEntity;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import mod.noobulus.tetrapak.TetraPak;
import mod.noobulus.tetrapak.util.LootLoader;
import mod.noobulus.tetrapak.util.RecalculatableLazyValue;
import mod.noobulus.tetrapak.util.ToolHelper;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.client.Minecraft;
import net.minecraft.core.Registry;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.LootTables;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSet;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraftforge.common.ToolAction;
import net.minecraftforge.common.util.NonNullSupplier;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.wrapper.RecipeWrapper;
import net.minecraftforge.registries.ForgeRegistryEntry;
import net.minecraftforge.registries.IForgeRegistryEntry;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class SalvagingRecipe
implements Recipe<Container> {
    public static final Serializer SERIALIZER = new Serializer();
    private static final LootContextParamSet lootParameters = new LootContextParamSet.Builder().m_81406_(LootContextParams.f_81460_).m_81408_(LootContextParams.f_81463_).m_81408_(LootContextParams.f_81455_).m_81405_();
    public final ToolAction toolType;
    public final int toolLevel;
    public final Ingredient startingItem;
    public final ResourceLocation lootTable;
    public final RecalculatableLazyValue<List<LootLoader.LootSlot>> contents;
    public final RecalculatableLazyValue<List<ItemStack>> toolExamples;
    private final ResourceLocation id;
    @Nullable
    private DeployerAwareInventory recipeInv;

    public SalvagingRecipe(ResourceLocation id, ToolAction toolType, int toolLevel, Ingredient startingItem, ResourceLocation lootTable) {
        this.id = id;
        this.toolType = toolType;
        this.toolLevel = toolLevel;
        this.startingItem = startingItem;
        this.lootTable = lootTable;
        this.contents = new RecalculatableLazyValue((NonNullSupplier)DistExecutor.unsafeRunForDist(() -> () -> () -> {
            if (Minecraft.m_91087_().m_91091_()) {
                return this.getContents();
            }
            return new ArrayList();
        }, () -> () -> this::getContents));
        this.toolExamples = new RecalculatableLazyValue(() -> ToolHelper.getToolsOf(toolType, toolLevel));
    }

    public boolean m_5818_(Container iInventory, Level level) {
        if (iInventory.m_6643_() != 2) {
            return false;
        }
        if (ToolHelper.getTierOf(iInventory.m_8020_(0), this.toolType) < this.toolLevel) {
            return false;
        }
        return this.startingItem.test(iInventory.m_8020_(1));
    }

    public ItemStack m_5874_(Container inv) {
        return this.m_8043_();
    }

    public boolean m_8004_(int width, int height) {
        return true;
    }

    public ItemStack m_8043_() {
        return ItemStack.f_41583_;
    }

    public List<ItemStack> rollResults(Container iInventory, ServerLevel level, @Nullable Player playerEntity) {
        if (iInventory.m_6643_() != 2) {
            return new ArrayList<ItemStack>();
        }
        ItemStack toolSlot = iInventory.m_8020_(0);
        if (toolSlot.m_41619_()) {
            return new ArrayList<ItemStack>();
        }
        LootContext.Builder builder = new LootContext.Builder(level).m_78972_(LootContextParams.f_81463_, (Object)toolSlot);
        if (playerEntity != null) {
            builder.m_78972_(LootContextParams.f_81455_, (Object)playerEntity).m_78972_(LootContextParams.f_81460_, (Object)playerEntity.m_20182_()).m_78963_(playerEntity.m_36336_());
        }
        LootTable table = level.m_142572_().m_129898_().m_79217_(this.lootTable);
        return table.m_79129_(builder.m_78975_(lootParameters));
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public RecipeSerializer<?> m_7707_() {
        return SERIALIZER;
    }

    public RecipeType<?> m_6671_() {
        return SalvagingRecipeType.AUTOMATIC_SALVAGING;
    }

    public void setBufferedInv(DeployerAwareInventory recipeInv) {
        this.recipeInv = recipeInv;
    }

    public boolean m_5598_() {
        return true;
    }

    @Nullable
    public DeployerAwareInventory getRecipeInv() {
        return this.recipeInv;
    }

    private List<LootLoader.LootSlot> getContents() {
        LootTables manager = LootLoader.getManager();
        return LootLoader.crawlTable(manager.m_79217_(this.lootTable), manager);
    }

    private static class Serializer
    extends ForgeRegistryEntry<RecipeSerializer<?>>
    implements RecipeSerializer<SalvagingRecipe> {
        private Serializer() {
        }

        public SalvagingRecipe fromJson(ResourceLocation id, JsonObject json) {
            Ingredient ingredient = Ingredient.m_43917_((JsonElement)json.get("requirement"));
            int toolLevel = GsonHelper.m_13900_((JsonObject)json, (String)"tool_level") ? GsonHelper.m_13927_((JsonObject)json, (String)"tool_level") : 0;
            ToolAction toolType = ToolAction.get((String)GsonHelper.m_13906_((JsonObject)json, (String)"tool_type"));
            ResourceLocation lootTable = new ResourceLocation(GsonHelper.m_13906_((JsonObject)json, (String)"lootTable"));
            return new SalvagingRecipe(id, toolType, toolLevel, ingredient, lootTable);
        }

        @Nullable
        public SalvagingRecipe fromNetwork(ResourceLocation id, FriendlyByteBuf packetBuffer) {
            Ingredient ingredient = Ingredient.m_43940_((FriendlyByteBuf)packetBuffer);
            int toolLevel = packetBuffer.readInt();
            ResourceLocation lootTable = packetBuffer.m_130281_();
            ToolAction toolType = ToolAction.get((String)packetBuffer.m_130136_(Short.MAX_VALUE));
            SalvagingRecipe recipe = new SalvagingRecipe(id, toolType, toolLevel, ingredient, lootTable);
            int slotCount = packetBuffer.readInt();
            ArrayList<LootLoader.LootSlot> slots = new ArrayList<LootLoader.LootSlot>();
            for (int i = 0; i < slotCount; ++i) {
                slots.add(new LootLoader.LootSlot(packetBuffer));
            }
            recipe.contents.updateSupplier((NonNullSupplier<List<LootLoader.LootSlot>>)((NonNullSupplier)() -> slots));
            int exampleCount = packetBuffer.readInt();
            ArrayList<ItemStack> examples = new ArrayList<ItemStack>();
            for (int i = 0; i < exampleCount; ++i) {
                examples.add(packetBuffer.m_130267_());
            }
            recipe.toolExamples.updateSupplier((NonNullSupplier<List<ItemStack>>)((NonNullSupplier)() -> examples));
            return recipe;
        }

        public void toNetwork(FriendlyByteBuf packetBuffer, SalvagingRecipe recipe) {
            recipe.startingItem.m_43923_(packetBuffer);
            packetBuffer.writeInt(recipe.toolLevel);
            packetBuffer.m_130085_(recipe.lootTable);
            packetBuffer.m_130070_(recipe.toolType.name());
            List<LootLoader.LootSlot> slots = recipe.contents.get();
            packetBuffer.writeInt(slots.size());
            slots.forEach(slot -> slot.toBuffer(packetBuffer));
            List<ItemStack> examples = recipe.toolExamples.get();
            packetBuffer.writeInt(examples.size());
            examples.forEach(tool -> packetBuffer.writeItemStack(tool, false));
        }
    }

    @Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD, modid="tetrapak")
    public static class SalvagingRecipeType
    implements RecipeType<SalvagingRecipe> {
        public static final RecipeType<SalvagingRecipe> AUTOMATIC_SALVAGING = new SalvagingRecipeType();

        private SalvagingRecipeType() {
        }

        @SubscribeEvent
        public static void registerRecipeSerializers(RegistryEvent.Register<RecipeSerializer<?>> event) {
            Registry.m_122965_((Registry)Registry.f_122864_, (ResourceLocation)TetraPak.asId("automatic_salvaging"), AUTOMATIC_SALVAGING);
            event.getRegistry().register((IForgeRegistryEntry)((RecipeSerializer)SERIALIZER.setRegistryName(TetraPak.asId("automatic_salvaging"))));
        }
    }

    public static class DeployerAwareInventory
    extends RecipeWrapper {
        public final DeployerTileEntity deployerTileEntity;
        public final DeployerFakePlayer deployerFakePlayer;
        public final Consumer<List<Item>> onRecipeApply;

        public DeployerAwareInventory(IItemHandlerModifiable inv, DeployerTileEntity deployerTileEntity, DeployerFakePlayer deployerFakePlayer, Consumer<List<Item>> onRecipeApply) {
            super(inv);
            this.deployerTileEntity = deployerTileEntity;
            this.deployerFakePlayer = deployerFakePlayer;
            this.onRecipeApply = onRecipeApply;
        }
    }
}

