/*
 * Decompiled with CFR 0.152.
 */
package mod.noobulus.tetrapak.effects.create.refined_radiance;

import mod.noobulus.tetrapak.networking.EntityFloatParticlePacket;
import mod.noobulus.tetrapak.networking.Packets;
import mod.noobulus.tetrapak.util.IEventBusListener;
import mod.noobulus.tetrapak.util.tetra_definitions.IHoloDescription;
import mod.noobulus.tetrapak.util.tetra_definitions.ITetraEffect;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.network.PacketDistributor;
import se.mickelus.tetra.effect.ItemEffect;

public class FloatingEffect
implements IHoloDescription,
IEventBusListener {
    public static final FloatingEffect INSTANCE = new FloatingEffect();
    private boolean makeItemsFloat = false;

    private static void makeFloaty(Entity e) {
        e.m_20242_(true);
        e.m_20256_(e.m_20184_().m_82490_(0.3));
        e.getPersistentData().m_128379_("DoFloatyParticles", true);
    }

    public static float getIdleParticleChance(ItemEntity entity) {
        return (float)Mth.m_14045_((int)(entity.m_32055_().m_41613_() - 10), (int)5, (int)100) / 64.0f;
    }

    public static void onItemEntityTick(ItemEntity entity) {
        Level world = entity.m_20193_();
        if (entity.f_19853_.f_46443_) {
            return;
        }
        if (!entity.getPersistentData().m_128471_("DoFloatyParticles")) {
            return;
        }
        if (world.f_46441_.nextFloat() > FloatingEffect.getIdleParticleChance(entity)) {
            return;
        }
        Packets.channel.send(PacketDistributor.TRACKING_ENTITY.with(() -> entity), (Object)new EntityFloatParticlePacket((Entity)entity));
    }

    public void checkFloatiness(ItemStack tool) {
        this.makeItemsFloat = this.hasEffect(tool);
    }

    public void checkFloatiness(DamageSource source) {
        this.makeItemsFloat = this.hasEffect(source);
    }

    @SubscribeEvent
    public void floatingKillsLevitateDrops(LivingDropsEvent event) {
        if (this.hasEffect(event.getSource())) {
            event.getDrops().forEach(FloatingEffect::makeFloaty);
        }
    }

    @SubscribeEvent
    public void onEntityJoinWorld(EntityJoinWorldEvent event) {
        if (!(event.getEntity() instanceof ItemEntity)) {
            return;
        }
        if (this.makeItemsFloat || this.hasEffect(((ItemEntity)event.getEntity()).m_32055_())) {
            FloatingEffect.makeFloaty(event.getEntity());
        }
    }

    @Override
    public ItemEffect getEffect() {
        return ITetraEffect.get("floating");
    }

    public void resetFloatiness() {
        this.makeItemsFloat = false;
    }
}

