/*
 * Decompiled with CFR 0.152.
 */
package mod.noobulus.tetrapak.effects.druidcraft;

import mod.noobulus.tetrapak.registries.Particles;
import mod.noobulus.tetrapak.util.IEventBusListener;
import mod.noobulus.tetrapak.util.tetra_definitions.IPercentageHoloDescription;
import mod.noobulus.tetrapak.util.tetra_definitions.ITetraEffect;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelTimeAccess;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DistExecutor;
import se.mickelus.tetra.effect.ItemEffect;
import se.mickelus.tetra.gui.stats.getter.IStatGetter;
import se.mickelus.tetra.gui.stats.getter.ITooltipGetter;
import se.mickelus.tetra.items.modular.ModularItem;

public class MoonstrikeEffect
implements IPercentageHoloDescription,
IEventBusListener {
    private static float getMoonFactor(LevelTimeAccess world, double efficiency) {
        return (float)(1.0 + efficiency * (double)world.m_46940_() / 100.0);
    }

    private static void spawnMoonParticles(Level world, Vec3 pos) {
        if (world instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)world;
            if (world.m_46940_() != 0.0f) {
                serverLevel.m_8767_((ParticleOptions)MoonstrikeEffect.getParticleType((LevelTimeAccess)world), pos.m_7096_() + 0.5, pos.m_7098_() + 0.5, pos.m_7094_() + 0.5, 12, (world.f_46441_.nextDouble() * 2.0 - 1.0) * 0.3, 0.3 + world.f_46441_.nextDouble() * 0.3, (world.f_46441_.nextDouble() * 2.0 - 1.0) * 0.3, 0.3);
            }
        }
    }

    private static SimpleParticleType getParticleType(LevelTimeAccess world) {
        float moonSize = world.m_46940_();
        return (SimpleParticleType)((double)moonSize > 0.5 ? ((double)moonSize > 0.75 ? Particles.MOONSTRIKE_STAGE_3 : Particles.MOONSTRIKE_STAGE_2) : ((double)moonSize > 0.25 ? Particles.MOONSTRIKE_STAGE_1 : Particles.MOONSTRIKE_STAGE_0)).get();
    }

    @SubscribeEvent
    public void moonstrikeToolsBreakBlocksFaster(PlayerEvent.BreakSpeed event) {
        ItemStack heldItemMainhand = event.getPlayer().m_21205_();
        Item item = heldItemMainhand.m_41720_();
        if (!(item instanceof ModularItem)) {
            return;
        }
        ModularItem item2 = (ModularItem)item;
        if (this.hasEffect(heldItemMainhand)) {
            Level moonPhaseWorld = event.getPlayer().m_20193_();
            MoonstrikeEffect.spawnMoonParticles(moonPhaseWorld, Vec3.m_82528_((Vec3i)event.getPos()));
            float efficiency = (float)item2.getEffectEfficiency(heldItemMainhand, this.getEffect());
            event.setNewSpeed(event.getOriginalSpeed() * MoonstrikeEffect.getMoonFactor((LevelTimeAccess)moonPhaseWorld, efficiency));
        }
    }

    @SubscribeEvent
    public void moonstrikeCausesBonusDamage(LivingHurtEvent event) {
        if (this.hasEffect(event.getSource())) {
            Entity source = event.getSource().m_7640_();
            if (source == null) {
                return;
            }
            Level moonPhaseWorld = source.m_20193_();
            double efficiency = this.getEffectEfficiency(event.getSource());
            if (moonPhaseWorld.m_46940_() != 0.0f) {
                DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> Minecraft.m_91087_().f_91061_.m_107329_(event.getEntity(), (ParticleOptions)MoonstrikeEffect.getParticleType((LevelTimeAccess)moonPhaseWorld)));
            }
            event.setAmount(event.getAmount() * MoonstrikeEffect.getMoonFactor((LevelTimeAccess)moonPhaseWorld, efficiency));
        }
    }

    @Override
    public ITooltipGetter getStatTooltipGetter(IStatGetter statGetter) {
        return (player, itemStack) -> I18n.m_118938_((String)this.getTooltipPath(), (Object[])new Object[]{statGetter.getValue(player, itemStack), statGetter.getValue(player, itemStack)});
    }

    @Override
    public ItemEffect getEffect() {
        return ITetraEffect.get("moonstrike");
    }
}

