/*
 * Decompiled with CFR 0.152.
 */
package mod.noobulus.tetrapak.effects.quark;

import mod.noobulus.tetrapak.Config;
import mod.noobulus.tetrapak.effects.quark.CorundumMap;
import mod.noobulus.tetrapak.util.IEventBusListener;
import mod.noobulus.tetrapak.util.tetra_definitions.IHoloDescription;
import mod.noobulus.tetrapak.util.tetra_definitions.ITetraEffect;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import se.mickelus.tetra.effect.ItemEffect;
import se.mickelus.tetra.gui.stats.getter.ILabelGetter;
import se.mickelus.tetra.gui.stats.getter.IStatGetter;
import se.mickelus.tetra.gui.stats.getter.ITooltipGetter;
import se.mickelus.tetra.gui.stats.getter.LabelGetterBasic;

public class CorundumEffect
implements IHoloDescription,
IEventBusListener {
    public CorundumEffect() {
        CorundumMap.checkMappings();
    }

    @Override
    public ItemEffect getEffect() {
        return ITetraEffect.get("rainbow");
    }

    @SubscribeEvent
    public void corundumToolsBreakBlocksFaster(PlayerEvent.BreakSpeed event) {
        int effectLevel = this.getEffectLevel(event.getPlayer().m_21205_());
        if (effectLevel <= 0) {
            return;
        }
        BlockPos pos = event.getPos();
        Level world = event.getEntityLiving().f_19853_;
        boolean matches = CorundumMap.COLOR_MAP.get(world.m_8055_(event.getPos()).m_60780_((BlockGetter)world, pos)) == effectLevel;
        event.setNewSpeed((float)((double)event.getOriginalSpeed() * (matches ? (Double)Config.MATCHING_CRYSTAL_FACTOR.get() : (Double)Config.NON_MATCHING_CRYSTAL_FACTOR.get())));
    }

    @Override
    public ITooltipGetter getStatTooltipGetter(IStatGetter statGetter) {
        return (player, itemStack) -> I18n.m_118938_((String)this.getTooltipPath(), (Object[])new Object[]{new TranslatableComponent("tetrapak." + CorundumMap.NAME_MAP.get((int)statGetter.getValue(player, itemStack))).getString(), Config.MATCHING_CRYSTAL_FACTOR.get()});
    }

    @Override
    public ILabelGetter getStatLabel() {
        return new LabelGetterBasic("%s", "%s"){

            public String getLabel(double value, double diffValue, boolean flipped) {
                return new TranslatableComponent("tetrapak." + CorundumMap.NAME_MAP.get((int)diffValue)).getString();
            }
        };
    }
}

