/*
 * Decompiled with CFR 0.152.
 */
package mod.noobulus.tetrapak.mixin;

import com.google.gson.JsonElement;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import mod.noobulus.tetrapak.predicate.PredicateManagers;
import net.minecraft.advancements.critereon.DamageSourcePredicate;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={DamageSourcePredicate.class})
public class DamageSourcePredicateMixin {
    private final List<Predicate<DamageSource>> customPredicates = new ArrayList<Predicate<DamageSource>>();

    @Inject(at={@At(value="RETURN")}, method={"fromJson"}, cancellable=true)
    private static void onFromJson(JsonElement element, CallbackInfoReturnable<DamageSourcePredicate> cir) {
        if (PredicateManagers.DAMAGE_SOURCE_PREDICATES.getRegistry() == null) {
            return;
        }
        List<Predicate<DamageSource>> predicateList = PredicateManagers.DAMAGE_SOURCE_PREDICATES.getRegistry().getValues().stream().map(abstractEntityPredicate -> abstractEntityPredicate.read(element)).filter(Objects::nonNull).collect(Collectors.toList());
        if (predicateList.isEmpty()) {
            return;
        }
        DamageSourcePredicate predicate = (DamageSourcePredicate)cir.getReturnValue();
        if (predicate == DamageSourcePredicate.f_25420_) {
            predicate = DamageSourcePredicate.Builder.m_25471_().m_25476_();
            cir.setReturnValue((Object)predicate);
        }
        ((DamageSourcePredicateMixin)predicate).bindPredicateList(predicateList);
    }

    @Inject(at={@At(value="RETURN")}, method={"matches(Lnet/minecraft/server/level/ServerLevel;Lnet/minecraft/world/phys/Vec3;Lnet/minecraft/world/damagesource/DamageSource;)Z"}, cancellable=true)
    private void onPredicateTest(ServerLevel level, Vec3 pos, DamageSource damageSource, CallbackInfoReturnable<Boolean> cir) {
        if (this.customPredicates.isEmpty() || !cir.getReturnValueZ()) {
            return;
        }
        cir.setReturnValue((Object)this.customPredicates.stream().allMatch(entityPredicate -> entityPredicate.test(damageSource)));
    }

    public void bindPredicateList(List<Predicate<DamageSource>> list) {
        this.customPredicates.addAll(list);
    }
}

