/*
 * Decompiled with CFR 0.152.
 */
package mod.noobulus.tetrapak.networking;

import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import mod.noobulus.tetrapak.TetraPak;
import mod.noobulus.tetrapak.networking.EntityFloatParticlePacket;
import mod.noobulus.tetrapak.networking.ISimplePacket;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.simple.SimpleChannel;

public enum Packets {
    ENTITY_FLOAT_PARTICLE(EntityFloatParticlePacket.class, EntityFloatParticlePacket::new, NetworkDirection.PLAY_TO_CLIENT);

    public static final ResourceLocation CHANNEL_NAME;
    public static final String NETWORK_VERSION;
    public static final SimpleChannel channel;
    private final LoadedPacket<?> packet;

    private <T extends ISimplePacket> Packets(Class<T> packetClass, Function<FriendlyByteBuf, T> factory, NetworkDirection direction) {
        this.packet = new LoadedPacket<T>(packetClass, factory, direction);
    }

    public static void registerPackets() {
        for (Packets packet : Packets.values()) {
            packet.packet.register();
        }
    }

    static {
        CHANNEL_NAME = TetraPak.asId("network");
        NETWORK_VERSION = TetraPak.asId("1").toString();
        channel = NetworkRegistry.ChannelBuilder.named((ResourceLocation)CHANNEL_NAME).serverAcceptedVersions(NETWORK_VERSION::equals).clientAcceptedVersions(NETWORK_VERSION::equals).networkProtocolVersion(() -> NETWORK_VERSION).simpleChannel();
    }

    private static class LoadedPacket<T extends ISimplePacket> {
        private static int index = 0;
        private final BiConsumer<T, FriendlyByteBuf> encoder = ISimplePacket::writePacketData;
        private final Function<FriendlyByteBuf, T> decoder;
        private final BiConsumer<T, Supplier<NetworkEvent.Context>> handler;
        private final Class<T> type;
        private final NetworkDirection direction;

        private LoadedPacket(Class<T> type, Function<FriendlyByteBuf, T> factory, NetworkDirection direction) {
            this.decoder = factory;
            this.handler = ISimplePacket::handle;
            this.type = type;
            this.direction = direction;
        }

        private void register() {
            channel.messageBuilder(this.type, index++, this.direction).encoder(this.encoder).decoder(this.decoder).consumer(this.handler).add();
        }
    }
}

