/*
 * Decompiled with CFR 0.152.
 */
package mod.noobulus.tetrapak.predicate.item;

import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import mod.noobulus.tetrapak.TetraPak;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import se.mickelus.tetra.effect.ItemEffect;
import se.mickelus.tetra.items.modular.ModularItem;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD, modid="tetrapak")
public class TetraEffectPredicate
extends ItemPredicate {
    private static final ItemPredicate ANY = new TetraEffectPredicate(null);
    private static final String JSON_EFFECT_KEY = "effect";
    private static final ResourceLocation ID = TetraPak.asId("has_effect");
    @Nullable
    private final ItemEffect effect;

    public TetraEffectPredicate(@Nullable ItemEffect effect) {
        this.effect = effect;
    }

    private static ItemPredicate fromJson(@Nullable JsonObject jsonObject) {
        if (jsonObject != null && !jsonObject.isJsonNull()) {
            if (jsonObject.has(JSON_EFFECT_KEY)) {
                return new TetraEffectPredicate(ItemEffect.get((String)GsonHelper.m_13906_((JsonObject)jsonObject, (String)JSON_EFFECT_KEY)));
            }
            return ANY;
        }
        return ItemPredicate.f_45028_;
    }

    @SubscribeEvent
    public static void register(FMLCommonSetupEvent event) {
        ItemPredicate.register((ResourceLocation)ID, TetraEffectPredicate::fromJson);
    }

    public boolean m_45049_(ItemStack tool) {
        if (tool.m_41619_() || !(tool.m_41720_() instanceof ModularItem)) {
            return false;
        }
        if (this.effect == null) {
            return true;
        }
        return ((ModularItem)tool.m_41720_()).getEffectLevel(tool, this.effect) > 0;
    }

    public JsonElement m_45048_() {
        if (this.effect == null) {
            return JsonNull.INSTANCE;
        }
        JsonObject jsonobject = new JsonObject();
        jsonobject.addProperty(JSON_EFFECT_KEY, this.effect.getKey());
        return jsonobject;
    }
}

