/*
 * Decompiled with CFR 0.152.
 */
package com.jozufozu.flywheel.backend.gl.shader;

import com.jozufozu.flywheel.backend.gl.GlObject;
import com.jozufozu.flywheel.backend.gl.shader.ShaderType;
import com.jozufozu.flywheel.backend.gl.versioned.GlCompat;
import com.jozufozu.flywheel.core.source.ShaderLoadingException;
import net.minecraft.resources.ResourceLocation;
import org.lwjgl.opengl.GL20;

public class GlShader
extends GlObject {
    public final ResourceLocation name;
    public final ShaderType type;

    public GlShader(ResourceLocation name, ShaderType type, String source) {
        this.name = name;
        this.type = type;
        int handle = GL20.glCreateShader((int)type.glEnum);
        GlCompat.safeShaderSource(handle, source);
        GL20.glCompileShader((int)handle);
        String log = GL20.glGetShaderInfoLog((int)handle);
        if (GL20.glGetShaderi((int)handle, (int)35713) != 1) {
            throw new ShaderLoadingException("Could not compile " + name + ". See log for details.");
        }
        this.setHandle(handle);
    }

    @Override
    protected void deleteInternal(int handle) {
        GL20.glDeleteShader((int)handle);
    }
}

