/*
 * Decompiled with CFR 0.152.
 */
package com.jozufozu.flywheel.config;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;

public enum FlwEngine {
    OFF("off", "Off"),
    BATCHING("batching", "Parallel Batching"),
    INSTANCING("instancing", "GL33 Instanced Arrays");

    private static final Map<String, FlwEngine> lookup;
    private final String shortName;
    private final String properName;

    private FlwEngine(String shortName, String properName) {
        this.shortName = shortName;
        this.properName = properName;
    }

    public String getShortName() {
        return this.shortName;
    }

    public String getProperName() {
        return this.properName;
    }

    @Nullable
    public static FlwEngine byName(String name) {
        return lookup.get(name);
    }

    public static Collection<String> validNames() {
        return lookup.keySet();
    }

    static {
        lookup = new HashMap<String, FlwEngine>();
        for (FlwEngine value : FlwEngine.values()) {
            lookup.put(value.shortName, value);
        }
    }
}

