/*
 * Decompiled with CFR 0.152.
 */
package com.jozufozu.flywheel.core.vertex;

import com.jozufozu.flywheel.api.vertex.VertexList;
import com.jozufozu.flywheel.util.RenderMath;
import java.nio.ByteBuffer;
import org.lwjgl.system.MemoryUtil;

public class PosTexNormalVertexListUnsafe
implements VertexList {
    private final ByteBuffer buffer;
    private final int vertexCount;
    private final long base;

    public PosTexNormalVertexListUnsafe(ByteBuffer buffer, int vertexCount) {
        this.buffer = buffer;
        this.vertexCount = vertexCount;
        this.base = MemoryUtil.memAddress((ByteBuffer)buffer);
    }

    private long ptr(long idx) {
        return this.base + idx * 23L;
    }

    @Override
    public float getX(int index) {
        return MemoryUtil.memGetFloat((long)this.ptr(index));
    }

    @Override
    public float getY(int index) {
        return MemoryUtil.memGetFloat((long)(this.ptr(index) + 4L));
    }

    @Override
    public float getZ(int index) {
        return MemoryUtil.memGetFloat((long)(this.ptr(index) + 8L));
    }

    @Override
    public byte getR(int index) {
        return -1;
    }

    @Override
    public byte getG(int index) {
        return -1;
    }

    @Override
    public byte getB(int index) {
        return -1;
    }

    @Override
    public byte getA(int index) {
        return -1;
    }

    @Override
    public float getU(int index) {
        return MemoryUtil.memGetFloat((long)(this.ptr(index) + 12L));
    }

    @Override
    public float getV(int index) {
        return MemoryUtil.memGetFloat((long)(this.ptr(index) + 16L));
    }

    @Override
    public int getLight(int index) {
        return 0;
    }

    @Override
    public float getNX(int index) {
        return RenderMath.f(MemoryUtil.memGetByte((long)(this.ptr(index) + 20L)));
    }

    @Override
    public float getNY(int index) {
        return RenderMath.f(MemoryUtil.memGetByte((long)(this.ptr(index) + 21L)));
    }

    @Override
    public float getNZ(int index) {
        return RenderMath.f(MemoryUtil.memGetByte((long)(this.ptr(index) + 22L)));
    }

    @Override
    public int getVertexCount() {
        return this.vertexCount;
    }
}

