/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.prettypipes.terminal.containers;

import com.mojang.blaze3d.vertex.PoseStack;
import de.ellpeck.prettypipes.packets.PacketButton;
import de.ellpeck.prettypipes.packets.PacketHandler;
import de.ellpeck.prettypipes.terminal.CraftingTerminalBlockEntity;
import de.ellpeck.prettypipes.terminal.containers.CraftingTerminalContainer;
import de.ellpeck.prettypipes.terminal.containers.ItemTerminalContainer;
import de.ellpeck.prettypipes.terminal.containers.ItemTerminalGui;
import net.minecraft.client.gui.components.Button;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;

public class CraftingTerminalGui
extends ItemTerminalGui {
    private static final ResourceLocation TEXTURE = new ResourceLocation("prettypipes", "textures/gui/crafting_terminal.png");
    private Button requestButton;

    public CraftingTerminalGui(ItemTerminalContainer screenContainer, Inventory inv, Component titleIn) {
        super(screenContainer, inv, titleIn);
        this.f_97726_ = 256;
    }

    @Override
    protected void m_7856_() {
        super.m_7856_();
        this.requestButton = this.m_142416_(new Button(this.f_97735_ + 8, this.f_97736_ + 100, 50, 20, (Component)new TranslatableComponent("info.prettypipes.request"), button -> {
            int amount = CraftingTerminalGui.requestModifier();
            PacketHandler.sendToServer(new PacketButton(((ItemTerminalContainer)this.f_97732_).tile.m_58899_(), PacketButton.ButtonResult.CRAFT_TERMINAL_REQUEST, amount));
        }));
        this.m_96624_();
    }

    @Override
    public void m_181908_() {
        super.m_181908_();
        CraftingTerminalBlockEntity tile = this.getCraftingContainer().getTile();
        this.requestButton.f_93623_ = false;
        for (int i = 0; i < tile.craftItems.getSlots(); ++i) {
            ItemStack stack = tile.getRequestedCraftItem(i);
            if (stack.m_41619_() || stack.m_41613_() >= stack.m_41741_()) continue;
            this.requestButton.f_93623_ = true;
            break;
        }
    }

    @Override
    protected void m_7027_(PoseStack matrix, int mouseX, int mouseY) {
        super.m_7027_(matrix, mouseX, mouseY);
        CraftingTerminalContainer container = this.getCraftingContainer();
        CraftingTerminalBlockEntity tile = container.getTile();
        for (int i = 0; i < tile.ghostItems.getSlots(); ++i) {
            ItemStack ghost;
            if (!tile.craftItems.getStackInSlot(i).m_41619_() || (ghost = tile.ghostItems.getStackInSlot(i)).m_41619_()) continue;
            int finalI = i;
            Slot slot = container.f_38839_.stream().filter(s -> s.f_40218_ == container.craftInventory && s.getSlotIndex() == finalI).findFirst().orElse(null);
            if (slot == null) continue;
            this.f_96541_.m_91291_().m_115123_(ghost, slot.f_40220_, slot.f_40221_);
            this.f_96541_.m_91291_().m_115174_(this.f_96547_, ghost, slot.f_40220_, slot.f_40221_, "0");
        }
    }

    @Override
    protected ResourceLocation getTexture() {
        return TEXTURE;
    }

    @Override
    protected int getXOffset() {
        return 65;
    }

    protected CraftingTerminalContainer getCraftingContainer() {
        return (CraftingTerminalContainer)this.f_97732_;
    }
}

