/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.client.renderer;

import com.jaquadro.minecraft.storagedrawers.api.storage.Drawers;
import com.jaquadro.minecraft.storagedrawers.api.storage.IDrawer;
import com.jaquadro.minecraft.storagedrawers.block.BlockDrawers;
import com.jaquadro.minecraft.storagedrawers.block.tile.TileEntityDrawers;
import com.jaquadro.minecraft.storagedrawers.block.tile.TileEntityDrawersComp;
import com.jaquadro.minecraft.storagedrawers.config.ClientConfig;
import com.jaquadro.minecraft.storagedrawers.util.CountFormatter;
import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Matrix3f;
import com.mojang.math.Matrix4f;
import com.mojang.math.Quaternion;
import com.mojang.math.Vector3f;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import net.minecraft.client.GraphicsStatus;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class TileEntityDrawersRenderer
implements BlockEntityRenderer<TileEntityDrawers> {
    private boolean[] renderAsBlock = new boolean[4];
    private ItemStack[] renderStacks = new ItemStack[4];
    private ItemRenderer renderItem;
    private BlockEntityRendererProvider.Context context;
    private static final float[] sideRotationY2D = new float[]{0.0f, 0.0f, 2.0f, 0.0f, 3.0f, 1.0f};
    public static final ResourceLocation TEXTURE_IND_1 = new ResourceLocation("storagedrawers", "blocks/indicator/indicator_1_on");
    public static final ResourceLocation TEXTURE_IND_2 = new ResourceLocation("storagedrawers", "blocks/indicator/indicator_2_on");
    public static final ResourceLocation TEXTURE_IND_4 = new ResourceLocation("storagedrawers", "blocks/indicator/indicator_4_on");
    public static final ResourceLocation TEXTURE_IND_COMP = new ResourceLocation("storagedrawers", "blocks/indicator/indicator_comp_on");

    public TileEntityDrawersRenderer(BlockEntityRendererProvider.Context context) {
        this.context = context;
    }

    public void render(TileEntityDrawers tile, float partialTickTime, PoseStack matrix, MultiBufferSource buffer, int combinedLight, int combinedOverlay) {
        if (tile == null) {
            return;
        }
        Level world = tile.m_58904_();
        if (world == null) {
            return;
        }
        BlockState state = tile.m_58900_();
        if (state == null) {
            return;
        }
        if (!(state.m_60734_() instanceof BlockDrawers)) {
            return;
        }
        Direction side = (Direction)state.m_61143_((Property)BlockDrawers.f_54117_);
        if (this.playerBehindBlock(tile.m_58899_(), side)) {
            return;
        }
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        BlockPos blockPos = tile.m_58899_().m_142022_(0.5, 0.5, 0.5);
        float distance = (float)Math.sqrt(blockPos.m_123309_((Position)player.m_20182_(), true));
        double renderDistance = (Double)ClientConfig.RENDER.labelRenderDistance.get();
        if (renderDistance > 0.0 && (double)distance > renderDistance) {
            return;
        }
        this.renderItem = Minecraft.m_91087_().m_91291_();
        if (tile.upgrades().hasIlluminationUpgrade()) {
            int blockLight = Math.max(combinedLight % 65536, 208);
            combinedLight = combinedLight & 0xFFFF0000 | blockLight;
        }
        Minecraft mc = Minecraft.m_91087_();
        GraphicsStatus cache = mc.f_91066_.f_92115_;
        mc.f_91066_.f_92115_ = GraphicsStatus.FANCY;
        if (!tile.getDrawerAttributes().isConcealed()) {
            this.renderFastItemSet(tile, state, matrix, buffer, combinedLight, combinedOverlay, side, partialTickTime, distance);
        }
        if (tile.getDrawerAttributes().hasFillLevel()) {
            this.renderIndicator((BlockDrawers)state.m_60734_(), tile, matrix, buffer, (Direction)state.m_61143_((Property)BlockDrawers.f_54117_), combinedLight, combinedOverlay);
        }
        mc.f_91066_.f_92115_ = cache;
        matrix.m_85849_();
        Lighting.m_84928_((Matrix4f)matrix.m_85850_().m_85861_());
        matrix.m_85836_();
    }

    private boolean playerBehindBlock(BlockPos blockPos, Direction facing) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null) {
            return false;
        }
        BlockPos playerPos = player.m_142538_();
        switch (facing) {
            case NORTH: {
                return playerPos.m_123343_() > blockPos.m_123343_();
            }
            case SOUTH: {
                return playerPos.m_123343_() < blockPos.m_123343_();
            }
            case WEST: {
                return playerPos.m_123341_() > blockPos.m_123341_();
            }
            case EAST: {
                return playerPos.m_123341_() < blockPos.m_123341_();
            }
        }
        return false;
    }

    private void renderFastItemSet(TileEntityDrawers tile, BlockState state, PoseStack matrix, MultiBufferSource buffer, int combinedLight, int combinedOverlay, Direction side, float partialTickTime, float distance) {
        int i;
        int drawerCount = tile.getGroup().getDrawerCount();
        for (i = 0; i < drawerCount; ++i) {
            ItemStack itemStack;
            this.renderStacks[i] = ItemStack.f_41583_;
            IDrawer drawer = tile.getGroup().getDrawer(i);
            if (!drawer.isEnabled() || drawer.isEmpty()) continue;
            this.renderStacks[i] = itemStack = drawer.getStoredItemPrototype();
            this.renderAsBlock[i] = this.isItemBlockType(itemStack);
        }
        for (i = 0; i < drawerCount; ++i) {
            if (this.renderStacks[i].m_41619_() || this.renderAsBlock[i]) continue;
            this.renderFastItem(this.renderStacks[i], tile, state, i, matrix, buffer, combinedLight, combinedOverlay, side, partialTickTime);
        }
        for (i = 0; i < drawerCount; ++i) {
            if (this.renderStacks[i].m_41619_() || !this.renderAsBlock[i]) continue;
            this.renderFastItem(this.renderStacks[i], tile, state, i, matrix, buffer, combinedLight, combinedOverlay, side, partialTickTime);
        }
        if (tile.getDrawerAttributes().isShowingQuantity()) {
            double renderDistance;
            float alpha = 1.0f;
            double fadeDistance = (Double)ClientConfig.RENDER.quantityFadeDistance.get();
            if (fadeDistance == 0.0 || (double)distance > fadeDistance) {
                alpha = Math.max(1.0f - (distance - 4.0f) / 6.0f, 0.05f);
            }
            if ((renderDistance = ((Double)ClientConfig.RENDER.quantityRenderDistance.get()).doubleValue()) == 0.0 || (double)distance < renderDistance) {
                MultiBufferSource.BufferSource txtBuffer = MultiBufferSource.m_109898_((BufferBuilder)Tesselator.m_85913_().m_85915_());
                for (int i2 = 0; i2 < drawerCount; ++i2) {
                    String format = CountFormatter.format(this.context.m_173586_(), tile.getGroup().getDrawer(i2));
                    this.renderText(format, state, i2, matrix, (MultiBufferSource)txtBuffer, combinedLight, side, alpha);
                }
                txtBuffer.m_109911_();
            }
        }
    }

    private void renderText(String text, BlockState state, int slot, PoseStack matrix, MultiBufferSource buffer, int combinedLight, Direction side, float alpha) {
        if (text == null || text.isEmpty()) {
            return;
        }
        Font fontRenderer = this.context.m_173586_();
        BlockDrawers block = (BlockDrawers)state.m_60734_();
        AABB labelGeometry = block.countGeometry[slot];
        int textWidth = fontRenderer.m_92895_(text);
        float x = (float)(labelGeometry.f_82288_ + labelGeometry.m_82362_() / 2.0);
        float y = 16.0f - (float)labelGeometry.f_82289_ - (float)labelGeometry.m_82376_();
        float z = (float)labelGeometry.f_82290_ * 0.0625f - 0.01f;
        matrix.m_85836_();
        this.alignRendering(matrix, side);
        this.moveRendering(matrix, 0.125f, 0.125f, x, y, z);
        int color = (int)(255.0f * alpha) << 24 | 0xFF0000 | 0xFF00 | 0xFF;
        fontRenderer.m_92811_(text, (float)(-textWidth) / 2.0f, 0.5f, color, false, matrix.m_85850_().m_85861_(), buffer, false, 0, combinedLight);
        matrix.m_85849_();
    }

    private void renderFastItem(@Nonnull ItemStack itemStack, TileEntityDrawers tile, BlockState state, int slot, PoseStack matrix, MultiBufferSource buffer, int combinedLight, int combinedOverlay, Direction side, float partialTickTime) {
        BlockDrawers block = (BlockDrawers)state.m_60734_();
        AABB labelGeometry = block.labelGeometry[slot];
        float scaleX = (float)labelGeometry.m_82362_() / 16.0f;
        float scaleY = (float)labelGeometry.m_82376_() / 16.0f;
        float moveX = (float)labelGeometry.f_82288_ + 8.0f * scaleX;
        float moveY = 16.0f - (float)labelGeometry.f_82292_ + 8.0f * scaleY;
        float moveZ = (float)labelGeometry.f_82290_ * 0.0625f;
        matrix.m_85836_();
        this.alignRendering(matrix, side);
        this.moveRendering(matrix, scaleX, scaleY, moveX, moveY, moveZ);
        Consumer<MultiBufferSource> finish = buf -> {
            if (buf instanceof MultiBufferSource.BufferSource) {
                ((MultiBufferSource.BufferSource)buf).m_109911_();
            }
        };
        try {
            matrix.m_85837_(0.0, 0.0, 100.0);
            matrix.m_85841_(1.0f, -1.0f, 1.0f);
            matrix.m_85841_(16.0f, 16.0f, 16.0f);
            BakedModel itemModel = this.renderItem.m_174264_(itemStack, null, null, 0);
            boolean render3D = itemModel.m_7539_();
            finish.accept(buffer);
            if (render3D) {
                Lighting.m_84931_();
            } else {
                Lighting.m_84930_();
            }
            matrix.m_85850_().m_85864_().m_8169_(Matrix3f.m_8174_((float)1.0f, (float)1.0f, (float)1.0f));
            this.renderItem.m_115143_(itemStack, ItemTransforms.TransformType.GUI, false, matrix, buffer, combinedLight, combinedOverlay, itemModel);
            finish.accept(buffer);
        }
        catch (Exception exception) {
            // empty catch block
        }
        matrix.m_85849_();
    }

    private boolean isItemBlockType(@Nonnull ItemStack itemStack) {
        return itemStack.m_41720_() instanceof BlockItem;
    }

    private void alignRendering(PoseStack matrix, Direction side) {
        matrix.m_85837_(0.5, 0.5, 0.5);
        matrix.m_85845_(new Quaternion(Vector3f.f_122225_, this.getRotationYForSide2D(side), true));
        matrix.m_85837_(-0.5, -0.5, -0.5);
    }

    private void moveRendering(PoseStack matrix, float scaleX, float scaleY, float offsetX, float offsetY, float offsetZ) {
        matrix.m_85837_(0.0, 1.0, (double)(1.0f - offsetZ));
        matrix.m_85841_(0.0625f, -0.0625f, 5.0E-5f);
        matrix.m_85837_((double)offsetX, (double)offsetY, 0.0);
        matrix.m_85841_(scaleX, scaleY, 1.0f);
    }

    private float getRotationYForSide2D(Direction side) {
        return sideRotationY2D[side.ordinal()] * 90.0f;
    }

    private void renderIndicator(BlockDrawers block, TileEntityDrawers tile, PoseStack matrixStack, MultiBufferSource buffer, Direction side, int combinedLight, int combinedOverlay) {
        int count = tile instanceof TileEntityDrawersComp ? 1 : block.getDrawerCount();
        ResourceLocation resource = TEXTURE_IND_1;
        if (tile instanceof TileEntityDrawersComp) {
            resource = TEXTURE_IND_COMP;
        } else if (count == 2) {
            resource = TEXTURE_IND_2;
        } else if (count == 4) {
            resource = TEXTURE_IND_4;
        }
        TextureAtlasSprite sprite = (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(TextureAtlas.f_118259_).apply(resource);
        float u1 = sprite.m_118409_();
        float u2 = sprite.m_118410_();
        float v1 = sprite.m_118411_();
        float v2 = sprite.m_118412_();
        float pxW = sprite.m_118405_();
        float pxH = sprite.m_118408_();
        float unit = 0.0625f;
        float divU = unit * (u2 - u1);
        float divV = unit * (v2 - v1);
        matrixStack.m_85836_();
        this.alignRendering(matrixStack, side);
        for (int i = 0; i < count; ++i) {
            IDrawer drawer = tile.getGroup().getDrawer(i);
            if (drawer == Drawers.DISABLED || tile.getDrawerAttributes().isConcealed()) continue;
            AABB bb = block.indGeometry[i];
            AABB bbbase = block.indBaseGeometry[i];
            float x1 = unit * (float)bb.f_82288_;
            float x2 = unit * (float)bb.f_82291_;
            float xb2 = unit * (float)bbbase.f_82291_;
            float y1 = unit * (float)bb.f_82289_;
            float y2 = unit * (float)bb.f_82292_;
            float yb2 = unit * (float)bbbase.f_82292_;
            float z = 1.0f - unit * (float)bb.f_82290_;
            float su1 = u1 + (float)bb.f_82288_ * divU;
            float su2 = u1 + (float)bb.f_82291_ * divU;
            float sv1 = v2 - (float)bb.f_82289_ * divV;
            float sv2 = v2 - (float)bb.f_82292_ * divV;
            int stepX = (int)((x2 - xb2) * pxW);
            int stepY = (int)((y2 - yb2) * pxH);
            float xCur = stepX == 0 ? x2 : this.getIndEnd(tile, i, x1, x2 - xb2, stepX);
            float xFrac = x2 == xb2 ? 1.0f : (xCur - x1) / (x2 - xb2);
            float uCur = su1 + xFrac * (su2 - su1);
            float yCur = stepY == 0 ? y2 : this.getIndEnd(tile, i, y1, y2 - yb2, stepY);
            float yFrac = y2 == yb2 ? 1.0f : (yCur - y1) / (y2 - yb2);
            float vCur = sv1 + yFrac * (sv2 - sv1);
            if (!(xCur > x1) || !(yCur > y1)) continue;
            Matrix4f matrix = matrixStack.m_85850_().m_85861_();
            Matrix3f normal = matrixStack.m_85850_().m_85864_();
            VertexConsumer builder = buffer.m_6299_(RenderType.m_110451_());
            TileEntityDrawersRenderer.addQuad(matrix, normal, builder, combinedLight, combinedOverlay, x1, xCur, y1, yCur, z, uCur, su1, sv1, vCur);
        }
        matrixStack.m_85849_();
    }

    public static void addQuad(Matrix4f matrix, Matrix3f normal, VertexConsumer buffer, int combinedLight, int combinedOverlay, float x1, float x2, float y1, float y2, float z, float u1, float u2, float v1, float v2) {
        TileEntityDrawersRenderer.addVertex(matrix, normal, buffer, combinedLight, combinedOverlay, x2, y1, z, u1, v1);
        TileEntityDrawersRenderer.addVertex(matrix, normal, buffer, combinedLight, combinedOverlay, x2, y2, z, u1, v2);
        TileEntityDrawersRenderer.addVertex(matrix, normal, buffer, combinedLight, combinedOverlay, x1, y2, z, u2, v2);
        TileEntityDrawersRenderer.addVertex(matrix, normal, buffer, combinedLight, combinedOverlay, x1, y1, z, u2, v1);
    }

    private static void addVertex(Matrix4f matrix, Matrix3f normal, VertexConsumer buffer, int combinedLight, int combinedOverlay, float x, float y, float z, float u, float v) {
        buffer.m_85982_(matrix, x, y, z).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_7421_(u, v).m_86008_(combinedOverlay).m_85969_(combinedLight).m_85977_(normal, 0.0f, 1.0f, 0.0f).m_5752_();
    }

    private float getIndEnd(TileEntityDrawers tile, int slot, float x, float w, int step) {
        IDrawer drawer = tile.getGroup().getDrawer(slot);
        if (drawer == Drawers.DISABLED) {
            return x;
        }
        int cap = drawer.getMaxCapacity();
        int count = drawer.getStoredItemCount();
        if (cap == 0 || count == 0) {
            return x;
        }
        float fillAmt = (float)(step * count / cap) / (float)step;
        return x + w * fillAmt;
    }
}

