/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.integration;

import com.jaquadro.minecraft.storagedrawers.block.BlockDrawers;
import com.jaquadro.minecraft.storagedrawers.block.tile.TileEntityDrawers;
import com.jaquadro.minecraft.storagedrawers.config.ClientConfig;
import com.jaquadro.minecraft.storagedrawers.integration.DrawerOverlay;
import javax.annotation.Nonnull;
import mcp.mobius.waila.api.BlockAccessor;
import mcp.mobius.waila.api.IComponentProvider;
import mcp.mobius.waila.api.IRegistrar;
import mcp.mobius.waila.api.ITooltip;
import mcp.mobius.waila.api.IWailaPlugin;
import mcp.mobius.waila.api.TooltipPosition;
import mcp.mobius.waila.api.WailaPlugin;
import mcp.mobius.waila.api.config.IPluginConfig;
import mcp.mobius.waila.api.ui.IElement;
import mcp.mobius.waila.impl.ui.ItemStackElement;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

@WailaPlugin(value="storagedrawers")
public class Waila
implements IWailaPlugin {
    public void register(IRegistrar registrar) {
        if (!((Boolean)ClientConfig.INTEGRATION.enableWaila.get()).booleanValue()) {
            return;
        }
        this.registerProvider(registrar);
    }

    private void registerProvider(IRegistrar registrar) {
        WailaDrawer provider = new WailaDrawer();
        registrar.addConfig(new ResourceLocation("storagedrawers", "display.content"), true);
        registrar.addConfig(new ResourceLocation("storagedrawers", "display.stacklimit"), true);
        registrar.addConfig(new ResourceLocation("storagedrawers", "display.status"), true);
        registrar.registerComponentProvider((IComponentProvider)provider, TooltipPosition.BODY, BlockDrawers.class);
    }

    public static class WailaDrawer
    implements IComponentProvider {
        @Nonnull
        public IElement getIcon(BlockAccessor accessor, IPluginConfig config, IElement currentIcon) {
            return ItemStackElement.of((ItemStack)new ItemStack((ItemLike)accessor.getBlock()));
        }

        public void appendTooltip(ITooltip currenttip, BlockAccessor accessor, IPluginConfig config) {
            TileEntityDrawers tile = (TileEntityDrawers)accessor.getBlockEntity();
            DrawerOverlay overlay = new DrawerOverlay();
            overlay.showContent = config.get(new ResourceLocation("storagedrawers", "display.content"));
            overlay.showStackLimit = config.get(new ResourceLocation("storagedrawers", "display.stacklimit"));
            overlay.showStatus = config.get(new ResourceLocation("storagedrawers", "display.status"));
            currenttip.addAll(overlay.getOverlay(tile));
        }
    }
}

