/*
 * Decompiled with CFR 0.152.
 */
package shadows.placebo.container;

import java.util.ArrayList;
import java.util.List;
import java.util.function.BiPredicate;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import shadows.placebo.mixin.AbstractContainerMenuInvoker;

public class QuickMoveHandler {
    protected List<QuickMoveRule> rules = new ArrayList<QuickMoveRule>();

    public ItemStack quickMoveStack(IExposedContainer container, Player player, int index) {
        ItemStack slotStackCopy = ItemStack.f_41583_;
        Slot slot = container.getMenuSlot(index);
        if (slot != null && slot.m_6657_()) {
            ItemStack slotStack = slot.m_7993_();
            slotStackCopy = slotStack.m_41777_();
            for (QuickMoveRule rule : this.rules) {
                if (!rule.req.test(slotStack, index) || container.moveMenuItemStackTo(slotStack, rule.startIdx, rule.endIdx, rule.reversed)) continue;
                return ItemStack.f_41583_;
            }
            if (slotStack.m_41619_()) {
                slot.m_5852_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
        }
        return slotStackCopy;
    }

    public void registerRule(BiPredicate<ItemStack, Integer> req, int startIdx, int endIdx, boolean reversed) {
        this.rules.add(new QuickMoveRule(req, startIdx, endIdx, reversed));
    }

    public void registerRule(BiPredicate<ItemStack, Integer> req, int startIdx, int endIdx) {
        this.registerRule(req, startIdx, endIdx, false);
    }

    public static interface IExposedContainer {
        default public boolean moveMenuItemStackTo(ItemStack pStack, int pStartIndex, int pEndIndex, boolean pReverseDirection) {
            return ((AbstractContainerMenuInvoker)((Object)this))._moveItemStackTo(pStack, pStartIndex, pEndIndex, pReverseDirection);
        }

        default public Slot getMenuSlot(int index) {
            return ((AbstractContainerMenu)this).m_38853_(index);
        }
    }

    protected record QuickMoveRule(BiPredicate<ItemStack, Integer> req, int startIdx, int endIdx, boolean reversed) {
    }
}

