/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.client.gui;

import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Matrix4f;
import dan200.computercraft.client.FrameInfo;
import dan200.computercraft.client.render.RenderTypes;
import dan200.computercraft.core.terminal.Terminal;
import dan200.computercraft.core.terminal.TextBuffer;
import dan200.computercraft.shared.util.Colour;
import dan200.computercraft.shared.util.Palette;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.resources.ResourceLocation;

public final class FixedWidthFontRenderer {
    public static final ResourceLocation FONT = new ResourceLocation("computercraft", "textures/gui/term_font.png");
    public static final int FONT_HEIGHT = 9;
    public static final int FONT_WIDTH = 6;
    public static final float WIDTH = 256.0f;
    public static final float BACKGROUND_START = 0.9765625f;
    public static final float BACKGROUND_END = 0.984375f;

    private FixedWidthFontRenderer() {
    }

    public static float toGreyscale(double[] rgb) {
        return (float)((rgb[0] + rgb[1] + rgb[2]) / 3.0);
    }

    public static int getColour(char c, Colour def) {
        return 15 - Terminal.getColour(c, def);
    }

    private static void drawChar(Matrix4f transform, VertexConsumer buffer, float x, float y, int index, float r, float g, float b, int light) {
        if (index == 0 || index == 32) {
            return;
        }
        int column = index % 16;
        int row = index / 16;
        int xStart = 1 + column * 8;
        int yStart = 1 + row * 11;
        buffer.m_85982_(transform, x, y, 0.0f).m_85950_(r, g, b, 1.0f).m_7421_((float)xStart / 256.0f, (float)yStart / 256.0f).m_85969_(light).m_5752_();
        buffer.m_85982_(transform, x, y + 9.0f, 0.0f).m_85950_(r, g, b, 1.0f).m_7421_((float)xStart / 256.0f, (float)(yStart + 9) / 256.0f).m_85969_(light).m_5752_();
        buffer.m_85982_(transform, x + 6.0f, y, 0.0f).m_85950_(r, g, b, 1.0f).m_7421_((float)(xStart + 6) / 256.0f, (float)yStart / 256.0f).m_85969_(light).m_5752_();
        buffer.m_85982_(transform, x + 6.0f, y, 0.0f).m_85950_(r, g, b, 1.0f).m_7421_((float)(xStart + 6) / 256.0f, (float)yStart / 256.0f).m_85969_(light).m_5752_();
        buffer.m_85982_(transform, x, y + 9.0f, 0.0f).m_85950_(r, g, b, 1.0f).m_7421_((float)xStart / 256.0f, (float)(yStart + 9) / 256.0f).m_85969_(light).m_5752_();
        buffer.m_85982_(transform, x + 6.0f, y + 9.0f, 0.0f).m_85950_(r, g, b, 1.0f).m_7421_((float)(xStart + 6) / 256.0f, (float)(yStart + 9) / 256.0f).m_85969_(light).m_5752_();
    }

    private static void drawQuad(Matrix4f transform, VertexConsumer buffer, float x, float y, float width, float height, float r, float g, float b) {
        buffer.m_85982_(transform, x, y, 0.0f).m_85950_(r, g, b, 1.0f).m_7421_(0.9765625f, 0.9765625f).m_5752_();
        buffer.m_85982_(transform, x, y + height, 0.0f).m_85950_(r, g, b, 1.0f).m_7421_(0.9765625f, 0.984375f).m_5752_();
        buffer.m_85982_(transform, x + width, y, 0.0f).m_85950_(r, g, b, 1.0f).m_7421_(0.984375f, 0.9765625f).m_5752_();
        buffer.m_85982_(transform, x + width, y, 0.0f).m_85950_(r, g, b, 1.0f).m_7421_(0.984375f, 0.9765625f).m_5752_();
        buffer.m_85982_(transform, x, y + height, 0.0f).m_85950_(r, g, b, 1.0f).m_7421_(0.9765625f, 0.984375f).m_5752_();
        buffer.m_85982_(transform, x + width, y + height, 0.0f).m_85950_(r, g, b, 1.0f).m_7421_(0.984375f, 0.984375f).m_5752_();
    }

    private static void drawQuad(Matrix4f transform, VertexConsumer buffer, float x, float y, float width, float height, Palette palette, boolean greyscale, char colourIndex) {
        float r;
        float g;
        float b;
        double[] colour = palette.getColour(FixedWidthFontRenderer.getColour(colourIndex, Colour.BLACK));
        if (greyscale) {
            g = b = FixedWidthFontRenderer.toGreyscale(colour);
            r = b;
        } else {
            r = (float)colour[0];
            g = (float)colour[1];
            b = (float)colour[2];
        }
        FixedWidthFontRenderer.drawQuad(transform, buffer, x, y, width, height, r, g, b);
    }

    private static void drawBackground(@Nonnull Matrix4f transform, @Nonnull VertexConsumer renderer, float x, float y, @Nonnull TextBuffer backgroundColour, @Nonnull Palette palette, boolean greyscale, float leftMarginSize, float rightMarginSize, float height) {
        if (leftMarginSize > 0.0f) {
            FixedWidthFontRenderer.drawQuad(transform, renderer, x - leftMarginSize, y, leftMarginSize, height, palette, greyscale, backgroundColour.charAt(0));
        }
        if (rightMarginSize > 0.0f) {
            FixedWidthFontRenderer.drawQuad(transform, renderer, x + (float)(backgroundColour.length() * 6), y, rightMarginSize, height, palette, greyscale, backgroundColour.charAt(backgroundColour.length() - 1));
        }
        int blockStart = 0;
        char blockColour = '\u0000';
        for (int i = 0; i < backgroundColour.length(); ++i) {
            char colourIndex = backgroundColour.charAt(i);
            if (colourIndex == blockColour) continue;
            if (blockColour != '\u0000') {
                FixedWidthFontRenderer.drawQuad(transform, renderer, x + (float)(blockStart * 6), y, (float)(6 * (i - blockStart)), height, palette, greyscale, blockColour);
            }
            blockColour = colourIndex;
            blockStart = i;
        }
        if (blockColour != '\u0000') {
            FixedWidthFontRenderer.drawQuad(transform, renderer, x + (float)(blockStart * 6), y, (float)(6 * (backgroundColour.length() - blockStart)), height, palette, greyscale, blockColour);
        }
    }

    public static void drawString(@Nonnull Matrix4f transform, @Nonnull VertexConsumer renderer, float x, float y, @Nonnull TextBuffer text, @Nonnull TextBuffer textColour, @Nullable TextBuffer backgroundColour, @Nonnull Palette palette, boolean greyscale, float leftMarginSize, float rightMarginSize, int light) {
        if (backgroundColour != null) {
            FixedWidthFontRenderer.drawBackground(transform, renderer, x, y, backgroundColour, palette, greyscale, leftMarginSize, rightMarginSize, 9.0f);
        }
        for (int i = 0; i < text.length(); ++i) {
            float r;
            float g;
            float b;
            double[] colour = palette.getColour(FixedWidthFontRenderer.getColour(textColour.charAt(i), Colour.BLACK));
            if (greyscale) {
                g = b = FixedWidthFontRenderer.toGreyscale(colour);
                r = b;
            } else {
                r = (float)colour[0];
                g = (float)colour[1];
                b = (float)colour[2];
            }
            int index = text.charAt(i);
            if (index > 255) {
                index = 63;
            }
            FixedWidthFontRenderer.drawChar(transform, renderer, x + (float)(i * 6), y, index, r, g, b, light);
        }
    }

    public static void drawTerminalWithoutCursor(@Nonnull Matrix4f transform, @Nonnull VertexConsumer buffer, float x, float y, @Nonnull Terminal terminal, boolean greyscale, float topMarginSize, float bottomMarginSize, float leftMarginSize, float rightMarginSize) {
        Palette palette = terminal.getPalette();
        int height = terminal.getHeight();
        FixedWidthFontRenderer.drawBackground(transform, buffer, x, y - topMarginSize, terminal.getBackgroundColourLine(0), palette, greyscale, leftMarginSize, rightMarginSize, topMarginSize);
        FixedWidthFontRenderer.drawBackground(transform, buffer, x, y + (float)(height * 9), terminal.getBackgroundColourLine(height - 1), palette, greyscale, leftMarginSize, rightMarginSize, bottomMarginSize);
        for (int i = 0; i < height; ++i) {
            FixedWidthFontRenderer.drawString(transform, buffer, x, y + (float)(9 * i), terminal.getLine(i), terminal.getTextColourLine(i), terminal.getBackgroundColourLine(i), palette, greyscale, leftMarginSize, rightMarginSize, 0xF000F0);
        }
    }

    public static void drawCursor(@Nonnull Matrix4f transform, @Nonnull VertexConsumer buffer, float x, float y, @Nonnull Terminal terminal, boolean greyscale) {
        Palette palette = terminal.getPalette();
        int width = terminal.getWidth();
        int height = terminal.getHeight();
        int cursorX = terminal.getCursorX();
        int cursorY = terminal.getCursorY();
        if (terminal.getCursorBlink() && cursorX >= 0 && cursorX < width && cursorY >= 0 && cursorY < height && FrameInfo.getGlobalCursorBlink()) {
            float r;
            float g;
            float b;
            double[] colour = palette.getColour(15 - terminal.getTextColour());
            if (greyscale) {
                g = b = FixedWidthFontRenderer.toGreyscale(colour);
                r = b;
            } else {
                r = (float)colour[0];
                g = (float)colour[1];
                b = (float)colour[2];
            }
            FixedWidthFontRenderer.drawChar(transform, buffer, x + (float)(cursorX * 6), y + (float)(cursorY * 9), 95, r, g, b, 0xF000F0);
        }
    }

    public static void drawTerminal(@Nonnull Matrix4f transform, @Nonnull VertexConsumer buffer, float x, float y, @Nonnull Terminal terminal, boolean greyscale, float topMarginSize, float bottomMarginSize, float leftMarginSize, float rightMarginSize) {
        FixedWidthFontRenderer.drawTerminalWithoutCursor(transform, buffer, x, y, terminal, greyscale, topMarginSize, bottomMarginSize, leftMarginSize, rightMarginSize);
        FixedWidthFontRenderer.drawCursor(transform, buffer, x, y, terminal, greyscale);
    }

    public static void drawTerminal(@Nonnull Matrix4f transform, float x, float y, @Nonnull Terminal terminal, boolean greyscale, float topMarginSize, float bottomMarginSize, float leftMarginSize, float rightMarginSize) {
        MultiBufferSource.BufferSource renderer = MultiBufferSource.m_109898_((BufferBuilder)Tesselator.m_85913_().m_85915_());
        VertexConsumer buffer = renderer.m_6299_(RenderTypes.TERMINAL_WITH_DEPTH);
        FixedWidthFontRenderer.drawTerminal(transform, buffer, x, y, terminal, greyscale, topMarginSize, bottomMarginSize, leftMarginSize, rightMarginSize);
        renderer.m_109911_();
    }

    public static void drawEmptyTerminal(@Nonnull Matrix4f transform, @Nonnull MultiBufferSource renderer, float x, float y, float width, float height) {
        Colour colour = Colour.BLACK;
        FixedWidthFontRenderer.drawQuad(transform, renderer.m_6299_(RenderTypes.TERMINAL_WITH_DEPTH), x, y, width, height, colour.getR(), colour.getG(), colour.getB());
    }

    public static void drawEmptyTerminal(@Nonnull Matrix4f transform, float x, float y, float width, float height) {
        MultiBufferSource.BufferSource renderer = MultiBufferSource.m_109898_((BufferBuilder)Tesselator.m_85913_().m_85915_());
        FixedWidthFontRenderer.drawEmptyTerminal(transform, (MultiBufferSource)renderer, x, y, width, height);
        renderer.m_109911_();
    }

    public static void drawBlocker(@Nonnull Matrix4f transform, @Nonnull MultiBufferSource renderer, float x, float y, float width, float height) {
        Colour colour = Colour.BLACK;
        FixedWidthFontRenderer.drawQuad(transform, renderer.m_6299_(RenderTypes.TERMINAL_BLOCKER), x, y, width, height, colour.getR(), colour.getG(), colour.getB());
    }
}

