/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.command.text;

import dan200.computercraft.shared.command.CommandUtils;
import dan200.computercraft.shared.command.text.ChatHelpers;
import dan200.computercraft.shared.command.text.ServerTableFormatter;
import dan200.computercraft.shared.network.NetworkHandler;
import dan200.computercraft.shared.network.client.ChatTableClientMessage;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;

public class TableBuilder {
    private final int id;
    private int columns = -1;
    private final Component[] headers;
    private final ArrayList<Component[]> rows = new ArrayList();
    private int additional;

    public TableBuilder(int id, Component ... headers) {
        if (id < 0) {
            throw new IllegalArgumentException("ID must be positive");
        }
        this.id = id;
        this.headers = headers;
        this.columns = headers.length;
    }

    public TableBuilder(int id) {
        if (id < 0) {
            throw new IllegalArgumentException("ID must be positive");
        }
        this.id = id;
        this.headers = null;
    }

    public TableBuilder(int id, String ... headers) {
        if (id < 0) {
            throw new IllegalArgumentException("ID must be positive");
        }
        this.id = id;
        this.headers = new Component[headers.length];
        this.columns = headers.length;
        for (int i = 0; i < headers.length; ++i) {
            this.headers[i] = ChatHelpers.header(headers[i]);
        }
    }

    public void row(Component ... row) {
        if (this.columns == -1) {
            this.columns = row.length;
        }
        if (row.length != this.columns) {
            throw new IllegalArgumentException("Row is the incorrect length");
        }
        this.rows.add(row);
    }

    public int getId() {
        return this.id;
    }

    public int getColumns() {
        return this.columns;
    }

    @Nullable
    public Component[] getHeaders() {
        return this.headers;
    }

    @Nonnull
    public List<Component[]> getRows() {
        return this.rows;
    }

    public int getAdditional() {
        return this.additional;
    }

    public void setAdditional(int additional) {
        this.additional = additional;
    }

    public void trim(int height) {
        if (this.rows.size() > height) {
            this.additional += this.rows.size() - height - 1;
            this.rows.subList(height - 1, this.rows.size()).clear();
        }
    }

    public void display(CommandSourceStack source) {
        if (CommandUtils.isPlayer(source)) {
            this.trim(18);
            NetworkHandler.sendToPlayer((Player)((ServerPlayer)source.m_81373_()), new ChatTableClientMessage(this));
        } else {
            this.trim(100);
            new ServerTableFormatter(source).display(this);
        }
    }
}

