/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.network.client;

import dan200.computercraft.client.sound.SpeakerManager;
import dan200.computercraft.shared.network.NetworkMessage;
import io.netty.buffer.ByteBuf;
import java.nio.ByteBuffer;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.NetworkEvent;

public class SpeakerAudioClientMessage
implements NetworkMessage {
    private final UUID source;
    private final Vec3 pos;
    private final ByteBuffer content;
    private final float volume;

    public SpeakerAudioClientMessage(UUID source, Vec3 pos, float volume, ByteBuffer content) {
        this.source = source;
        this.pos = pos;
        this.content = content;
        this.volume = volume;
    }

    public SpeakerAudioClientMessage(FriendlyByteBuf buf) {
        this.source = buf.m_130259_();
        this.pos = new Vec3(buf.readDouble(), buf.readDouble(), buf.readDouble());
        this.volume = buf.readFloat();
        SpeakerManager.getSound(this.source).pushAudio((ByteBuf)buf);
        this.content = null;
    }

    @Override
    public void toBytes(@Nonnull FriendlyByteBuf buf) {
        buf.m_130077_(this.source);
        buf.writeDouble(this.pos.m_7096_());
        buf.writeDouble(this.pos.m_7098_());
        buf.writeDouble(this.pos.m_7094_());
        buf.writeFloat(this.volume);
        buf.writeBytes(this.content.duplicate());
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void handle(NetworkEvent.Context context) {
        SpeakerManager.getSound(this.source).playAudio(this.pos, this.volume);
    }
}

