/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.turtle;

import dan200.computercraft.api.turtle.ITurtleAccess;
import dan200.computercraft.api.turtle.event.TurtleRefuelEvent;
import dan200.computercraft.shared.util.InventoryUtil;
import dan200.computercraft.shared.util.WorldUtil;
import javax.annotation.Nonnull;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.items.IItemHandler;

@Mod.EventBusSubscriber(modid="computercraft")
public final class FurnaceRefuelHandler
implements TurtleRefuelEvent.Handler {
    private static final FurnaceRefuelHandler INSTANCE = new FurnaceRefuelHandler();

    private FurnaceRefuelHandler() {
    }

    @Override
    public int refuel(@Nonnull ITurtleAccess turtle, @Nonnull ItemStack currentStack, int slot, int limit) {
        ItemStack remainder;
        int fuelPerItem;
        int fuelSpaceLeft = turtle.getFuelLimit() - turtle.getFuelLevel();
        int fuelItemLimit = (int)Math.ceil((double)fuelSpaceLeft / (double)(fuelPerItem = FurnaceRefuelHandler.getFuelPerItem(turtle.getItemHandler().getStackInSlot(slot))));
        if (limit > fuelItemLimit) {
            limit = fuelItemLimit;
        }
        ItemStack stack = turtle.getItemHandler().extractItem(slot, limit, false);
        int fuelToGive = fuelPerItem * stack.m_41613_();
        ItemStack replacementStack = stack.m_41720_().getContainerItem(stack);
        if (!replacementStack.m_41619_() && !(remainder = InventoryUtil.storeItems(replacementStack, (IItemHandler)turtle.getItemHandler(), turtle.getSelectedSlot())).m_41619_()) {
            WorldUtil.dropItemStack(remainder, turtle.getLevel(), turtle.getPosition(), turtle.getDirection().m_122424_());
        }
        return fuelToGive;
    }

    private static int getFuelPerItem(@Nonnull ItemStack stack) {
        return ForgeHooks.getBurnTime((ItemStack)stack, null) * 5 / 100;
    }

    @SubscribeEvent
    public static void onTurtleRefuel(TurtleRefuelEvent event) {
        if (event.getHandler() == null && FurnaceRefuelHandler.getFuelPerItem(event.getStack()) > 0) {
            event.setHandler(INSTANCE);
        }
    }
}

