/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.util;

import dan200.computercraft.shared.util.Colour;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;

public class Palette {
    private static final int PALETTE_SIZE = 16;
    private final double[][] colours = new double[16][3];
    public static final Palette DEFAULT = new Palette();

    public Palette() {
        this.resetColours();
    }

    public void setColour(int i, double r, double g, double b) {
        if (i >= 0 && i < this.colours.length) {
            this.colours[i][0] = r;
            this.colours[i][1] = g;
            this.colours[i][2] = b;
        }
    }

    public void setColour(int i, Colour colour) {
        this.setColour(i, colour.getR(), colour.getG(), colour.getB());
    }

    public double[] getColour(int i) {
        if (i >= 0 && i < this.colours.length) {
            return this.colours[i];
        }
        return null;
    }

    public void resetColour(int i) {
        if (i >= 0 && i < this.colours.length) {
            this.setColour(i, Colour.VALUES[i]);
        }
    }

    public void resetColours() {
        for (int i = 0; i < Colour.VALUES.length; ++i) {
            this.resetColour(i);
        }
    }

    public static int encodeRGB8(double[] rgb) {
        int r = (int)(rgb[0] * 255.0) & 0xFF;
        int g = (int)(rgb[1] * 255.0) & 0xFF;
        int b = (int)(rgb[2] * 255.0) & 0xFF;
        return r << 16 | g << 8 | b;
    }

    public static double[] decodeRGB8(int rgb) {
        return new double[]{(float)(rgb >> 16 & 0xFF) / 255.0f, (float)(rgb >> 8 & 0xFF) / 255.0f, (float)(rgb & 0xFF) / 255.0f};
    }

    public void write(FriendlyByteBuf buffer) {
        double[][] dArray = this.colours;
        int n = dArray.length;
        for (int i = 0; i < n; ++i) {
            double[] colour;
            for (double channel : colour = dArray[i]) {
                buffer.writeByte((int)(channel * 255.0) & 0xFF);
            }
        }
    }

    public void read(FriendlyByteBuf buffer) {
        for (double[] colour : this.colours) {
            for (int i = 0; i < colour.length; ++i) {
                colour[i] = (double)(buffer.readByte() & 0xFF) / 255.0;
            }
        }
    }

    public CompoundTag writeToNBT(CompoundTag nbt) {
        int[] rgb8 = new int[this.colours.length];
        for (int i = 0; i < this.colours.length; ++i) {
            rgb8[i] = Palette.encodeRGB8(this.colours[i]);
        }
        nbt.m_128385_("term_palette", rgb8);
        return nbt;
    }

    public void readFromNBT(CompoundTag nbt) {
        if (!nbt.m_128441_("term_palette")) {
            return;
        }
        int[] rgb8 = nbt.m_128465_("term_palette");
        if (rgb8.length != this.colours.length) {
            return;
        }
        for (int i = 0; i < this.colours.length; ++i) {
            this.colours[i] = Palette.decodeRGB8(rgb8[i]);
        }
    }
}

