/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.capability;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import fuzs.puzzleslib.capability.data.CapabilityComponent;
import fuzs.puzzleslib.capability.data.CapabilityDispatcher;
import fuzs.puzzleslib.capability.data.CapabilityFactory;
import fuzs.puzzleslib.capability.data.PlayerRespawnStrategy;
import java.util.Map;
import java.util.function.Predicate;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.RegisterCapabilitiesEvent;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;

public class CapabilityController {
    private static final Map<String, CapabilityController> MOD_TO_CAPABILITIES = Maps.newConcurrentMap();
    private final String namespace;
    private final Multimap<Class<?>, CapabilityData<?>> typeToData = ArrayListMultimap.create();

    private CapabilityController(String namespace) {
        this.namespace = namespace;
    }

    private void onRegisterCapabilities(RegisterCapabilitiesEvent evt) {
        for (CapabilityData data : this.typeToData.values()) {
            evt.register(data.capabilityType());
        }
    }

    @Deprecated
    @SubscribeEvent
    public void onAttachCapabilities(AttachCapabilitiesEvent<?> evt) {
        for (CapabilityData data : this.typeToData.get((Object)((Class)evt.getGenericType()))) {
            if (!data.filter().test(evt.getObject())) continue;
            evt.addCapability(data.capabilityKey(), (ICapabilityProvider)data.capabilityFactory().createComponent(evt.getObject()));
        }
    }

    @Deprecated
    @SubscribeEvent
    public void onPlayerClone(PlayerEvent.Clone evt) {
        if (this.typeToData.get(Entity.class).isEmpty()) {
            return;
        }
        evt.getOriginal().reviveCaps();
        for (CapabilityData data : this.typeToData.get(Entity.class)) {
            evt.getOriginal().getCapability(data.capability()).ifPresent(oldCapability -> evt.getPlayer().getCapability(data.capability()).ifPresent(newCapability -> ((PlayerCapabilityData)data).respawnStrategy().copy((CapabilityComponent)oldCapability, (CapabilityComponent)newCapability, !evt.isWasDeath(), evt.getPlayer().f_19853_.m_46469_().m_46207_(GameRules.f_46133_))));
        }
        evt.getOriginal().invalidateCaps();
    }

    public <C extends CapabilityComponent> Capability<C> registerItemCapability(String capabilityKey, Class<C> capabilityType, CapabilityFactory<C> capabilityFactory, Item item, CapabilityToken<C> token) {
        return this.registerItemCapability(capabilityKey, capabilityType, capabilityFactory, (Item o) -> o == item, token);
    }

    public <C extends CapabilityComponent> Capability<C> registerItemCapability(String capabilityKey, Class<C> capabilityType, CapabilityFactory<C> capabilityFactory, Predicate<Item> itemFilter, CapabilityToken<C> token) {
        return this.registerCapability(ItemStack.class, capabilityKey, capabilityType, capabilityFactory, o -> {
            Item item;
            return o instanceof Item && itemFilter.test(item = (Item)o);
        }, token);
    }

    public <C extends CapabilityComponent> Capability<C> registerEntityCapability(String capabilityKey, Class<C> capabilityType, CapabilityFactory<C> capabilityFactory, Class<Entity> entityType, CapabilityToken<C> token) {
        return this.registerCapability(Entity.class, capabilityKey, capabilityType, capabilityFactory, entityType::isInstance, token);
    }

    public <C extends CapabilityComponent> Capability<C> registerPlayerCapability(String capabilityKey, Class<C> capabilityType, CapabilityFactory<C> capabilityFactory, PlayerRespawnStrategy respawnStrategy, CapabilityToken<C> token) {
        Capability capability = CapabilityManager.get(token);
        this.typeToData.put(Entity.class, new PlayerCapabilityData<C>(this.locate(capabilityKey), capability, capabilityType, provider -> new CapabilityDispatcher(capability, capabilityFactory.createComponent(provider)), Player.class::isInstance, respawnStrategy));
        return capability;
    }

    public <T extends BlockEntity, C extends CapabilityComponent> Capability<C> registerBlockEntityCapability(String capabilityKey, Class<C> capabilityType, CapabilityFactory<C> capabilityFactory, Class<T> blockEntityType, CapabilityToken<C> token) {
        return this.registerCapability(BlockEntity.class, capabilityKey, capabilityType, capabilityFactory, blockEntityType::isInstance, token);
    }

    public <C extends CapabilityComponent> Capability<C> registerLevelChunkCapability(String capabilityKey, Class<C> capabilityType, CapabilityFactory<C> capabilityFactory, CapabilityToken<C> token) {
        return this.registerCapability(LevelChunk.class, capabilityKey, capabilityType, capabilityFactory, o -> true, token);
    }

    public <C extends CapabilityComponent> Capability<C> registerLevelCapability(String capabilityKey, Class<C> capabilityType, CapabilityFactory<C> capabilityFactory, CapabilityToken<C> token) {
        return this.registerCapability(Level.class, capabilityKey, capabilityType, capabilityFactory, o -> true, token);
    }

    private <C extends CapabilityComponent> Capability<C> registerCapability(Class<? extends ICapabilityProvider> providerType, String capabilityKey, Class<C> capabilityType, CapabilityFactory<C> capabilityFactory, Predicate<Object> filter, CapabilityToken<C> token) {
        Capability capability = CapabilityManager.get(token);
        this.typeToData.put(providerType, new DefaultCapabilityData<C>(this.locate(capabilityKey), capability, capabilityType, provider -> new CapabilityDispatcher(capability, capabilityFactory.createComponent(provider)), filter));
        return capability;
    }

    private ResourceLocation locate(String path) {
        if (path.isEmpty()) {
            throw new IllegalArgumentException("Can't register object without name");
        }
        return new ResourceLocation(this.namespace, path);
    }

    public static synchronized CapabilityController of(String namespace) {
        return MOD_TO_CAPABILITIES.computeIfAbsent(namespace, key -> {
            CapabilityController manager = new CapabilityController(namespace);
            FMLJavaModLoadingContext.get().getModEventBus().addListener(manager::onRegisterCapabilities);
            MinecraftForge.EVENT_BUS.register((Object)manager);
            return manager;
        });
    }

    private static interface CapabilityData<C extends CapabilityComponent> {
        public ResourceLocation capabilityKey();

        public Capability<C> capability();

        public Class<C> capabilityType();

        public CapabilityFactory<CapabilityDispatcher<C>> capabilityFactory();

        public Predicate<Object> filter();
    }

    private record PlayerCapabilityData<C extends CapabilityComponent>(ResourceLocation capabilityKey, Capability<C> capability, Class<C> capabilityType, CapabilityFactory<CapabilityDispatcher<C>> capabilityFactory, Predicate<Object> filter, PlayerRespawnStrategy respawnStrategy) implements CapabilityData<C>
    {
    }

    private record DefaultCapabilityData<C extends CapabilityComponent>(ResourceLocation capabilityKey, Capability<C> capability, Class<C> capabilityType, CapabilityFactory<CapabilityDispatcher<C>> capabilityFactory, Predicate<Object> filter) implements CapabilityData<C>
    {
    }
}

