/*
 * Decompiled with CFR 0.152.
 */
package com.bottomtextdanny.effective_fg.client.particle;

import com.bottomtextdanny.effective_fg.client.render.model.SplashBottomModel;
import com.bottomtextdanny.effective_fg.client.render.model.SplashModel;
import com.bottomtextdanny.effective_fg.client.render.particle_support.ParticleModel;
import com.bottomtextdanny.effective_fg.registry.ParticleRegistry;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec3;

public class SplashParticle
extends TextureSheetParticle {
    private static final ParticleModel WAVE_MODEL = new SplashModel();
    private static final ParticleModel WAVE_BOTTOM_MODEL = new SplashBottomModel();
    private final SpriteSet sprites;
    private float widthMultiplier;
    private float heightMultiplier;
    private int wave1End;
    private int wave2Start;
    private int wave2End;

    protected SplashParticle(ClientLevel level, double x, double y, double z, SpriteSet spriteSet) {
        super(level, x, y, z);
        this.sprites = spriteSet;
        this.f_107226_ = 0.0f;
        this.widthMultiplier = 0.0f;
        this.heightMultiplier = 0.0f;
        this.wave1End = 12;
        this.wave2Start = 7;
        this.wave2End = 24;
    }

    public ParticleRenderType m_7556_() {
        return ParticleRenderType.f_107430_;
    }

    public void m_5989_() {
        block7: {
            block6: {
                if (this.widthMultiplier == 0.0f) {
                    List closeEntities = this.f_107208_.m_45933_(null, this.m_107277_().m_82400_(5.0)).stream().filter(Entity::m_20069_).collect(Collectors.toList());
                    closeEntities.sort((o1, o2) -> (int)(o1.m_20182_().m_82557_(new Vec3(this.f_107212_, this.f_107213_, this.f_107214_)) - o2.m_20182_().m_82557_(new Vec3(this.f_107212_, this.f_107213_, this.f_107214_))));
                    if (!closeEntities.isEmpty()) {
                        this.widthMultiplier = ((Entity)closeEntities.get(0)).m_20205_() * 2.0f;
                        this.heightMultiplier = (float)Math.max(-((Entity)closeEntities.get(0)).m_20184_().m_7098_() * (double)this.widthMultiplier, 0.0);
                        this.wave1End = 10 + Math.round(this.widthMultiplier * 1.2f);
                        this.wave2Start = 6 + Math.round(this.widthMultiplier * 0.7f);
                        this.wave2End = 20 + Math.round(this.widthMultiplier * 2.4f);
                    } else {
                        this.m_107274_();
                    }
                }
                this.f_107209_ = this.f_107212_;
                this.f_107210_ = this.f_107213_;
                this.f_107211_ = this.f_107214_;
                this.widthMultiplier *= 1.03f;
                if (this.f_107224_++ >= this.wave2End) {
                    this.m_107274_();
                }
                if (this.f_107224_ != 1) break block6;
                int i = 0;
                while ((float)i < this.widthMultiplier * 10.0f) {
                    this.f_107208_.m_7106_((ParticleOptions)ParticleRegistry.DROPLET.get(), this.f_107212_ + this.f_107223_.nextGaussian() * (double)this.widthMultiplier / 10.0, this.f_107213_, this.f_107214_ + this.f_107223_.nextGaussian() * (double)this.widthMultiplier / 10.0, this.f_107223_.nextGaussian() / 10.0 * (double)this.widthMultiplier / 2.5, (double)(this.f_107223_.nextFloat() / 10.0f + this.heightMultiplier / 2.8f), this.f_107223_.nextGaussian() / 10.0 * (double)this.widthMultiplier / 2.5);
                    ++i;
                }
                break block7;
            }
            if (this.f_107224_ != this.wave2Start) break block7;
            int i = 0;
            while ((float)i < this.widthMultiplier * 5.0f) {
                this.f_107208_.m_7106_((ParticleOptions)ParticleRegistry.DROPLET.get(), this.f_107212_ + this.f_107223_.nextGaussian() * (double)this.widthMultiplier / 10.0 * 0.5, this.f_107213_, this.f_107214_ + this.f_107223_.nextGaussian() * (double)this.widthMultiplier / 10.0 * 0.5, this.f_107223_.nextGaussian() / 10.0 * (double)this.widthMultiplier / 5.0, (double)(this.f_107223_.nextFloat() / 10.0f + this.heightMultiplier / 2.2f), this.f_107223_.nextGaussian() / 10.0 * (double)this.widthMultiplier / 5.0);
                ++i;
            }
        }
    }

    public void m_5744_(VertexConsumer vertexConsumer, Camera camera, float tickDelta) {
        float maxV;
        float minV;
        float maxU;
        float minU;
        int light = this.m_6355_(tickDelta);
        float yOffset = 0.001f;
        float bottomYOffset = -0.1f;
        Vec3 vec3d = camera.m_90583_();
        float f = (float)(Mth.m_14139_((double)tickDelta, (double)this.f_107209_, (double)this.f_107212_) - vec3d.m_7096_());
        float g = (float)(Mth.m_14139_((double)tickDelta, (double)this.f_107210_, (double)this.f_107213_) - vec3d.m_7098_()) + 0.001f;
        float h = (float)(Mth.m_14139_((double)tickDelta, (double)this.f_107211_, (double)this.f_107214_) - vec3d.m_7094_());
        PoseStack matrixStack = new PoseStack();
        if (this.f_107224_ <= this.wave1End) {
            int frameForFirstSplash = Math.round((float)this.f_107224_ / (float)this.wave1End * 12.0f);
            this.setSprite(frameForFirstSplash);
            minU = this.m_5970_();
            maxU = this.m_5952_();
            minV = this.m_5951_();
            maxV = this.m_5950_();
            matrixStack.m_85836_();
            matrixStack.m_85837_((double)f, (double)g, (double)h);
            matrixStack.m_85841_(this.widthMultiplier, -this.heightMultiplier, this.widthMultiplier);
            WAVE_MODEL.renderToBuffer(matrixStack, vertexConsumer, light, minU, maxU, minV, maxV, 1.0f, 1.0f, 1.0f, 1.0f);
            matrixStack.m_85849_();
            matrixStack.m_85836_();
            matrixStack.m_85851_();
            matrixStack.m_85837_((double)f, (double)g, (double)h);
            matrixStack.m_85841_(this.widthMultiplier * 1.2f, -this.heightMultiplier, this.widthMultiplier * 1.2f);
            WAVE_BOTTOM_MODEL.renderToBuffer(matrixStack, vertexConsumer, light, minU, maxU, minV, maxV, 1.0f, 1.0f, 1.0f, 1.0f);
            matrixStack.m_85849_();
            matrixStack.m_85836_();
            matrixStack.m_85851_();
            matrixStack.m_85837_((double)f, (double)(g + -0.1f), (double)h);
            matrixStack.m_85841_(this.widthMultiplier * 1.2f, -this.heightMultiplier, this.widthMultiplier * 1.2f);
            WAVE_BOTTOM_MODEL.renderToBuffer(matrixStack, vertexConsumer, light, minU, maxU, minV, maxV, 1.0f, 1.0f, 1.0f, 1.0f);
            matrixStack.m_85849_();
        }
        if (this.f_107224_ >= this.wave2Start) {
            int frameForSecondSplash = Math.round((float)(this.f_107224_ - this.wave2Start) / (float)(this.wave2End - this.wave2Start) * 12.0f);
            this.setSprite(frameForSecondSplash);
            minU = this.m_5970_();
            maxU = this.m_5952_();
            minV = this.m_5951_();
            maxV = this.m_5950_();
            matrixStack.m_85836_();
            matrixStack.m_85837_((double)f, (double)g, (double)h);
            matrixStack.m_85841_(this.widthMultiplier * 0.5f, -this.heightMultiplier * 2.0f, this.widthMultiplier * 0.5f);
            WAVE_MODEL.renderToBuffer(matrixStack, vertexConsumer, light, minU, maxU, minV, maxV, 1.0f, 1.0f, 1.0f, 1.0f);
            matrixStack.m_85849_();
            matrixStack.m_85836_();
            matrixStack.m_85837_((double)f, (double)g, (double)h);
            matrixStack.m_85841_(this.widthMultiplier * 0.6f, -this.heightMultiplier * 2.0f, this.widthMultiplier * 0.6f);
            WAVE_BOTTOM_MODEL.renderToBuffer(matrixStack, vertexConsumer, light, minU, maxU, minV, maxV, 1.0f, 1.0f, 1.0f, 1.0f);
            matrixStack.m_85849_();
            matrixStack.m_85836_();
            matrixStack.m_85837_((double)f, (double)(g + -0.1f), (double)h);
            matrixStack.m_85841_(this.widthMultiplier * 0.6f, -this.heightMultiplier * 2.0f, this.widthMultiplier * 0.6f);
            WAVE_BOTTOM_MODEL.renderToBuffer(matrixStack, vertexConsumer, light, minU, maxU, minV, maxV, 1.0f, 1.0f, 1.0f, 1.0f);
        }
    }

    public void setSprite(int index) {
        if (!this.f_107220_) {
            this.m_108337_(this.sprites.m_5819_(index, 12));
        }
    }

    public static class Factory
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet spriteSet;

        public Factory(SpriteSet spriteProvider) {
            this.spriteSet = spriteProvider;
        }

        @Nullable
        public Particle createParticle(SimpleParticleType parameters, ClientLevel level, double x, double y, double z, double velocityX, double velocityY, double velocityZ) {
            return new SplashParticle(level, x, y, z, this.spriteSet);
        }
    }
}

