/*
 * Decompiled with CFR 0.152.
 */
package com.bottomtextdanny.effective_fg.client.render.particle_support;

import com.bottomtextdanny.effective_fg.client.render.particle_support.ParticleModel;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Matrix3f;
import com.mojang.math.Matrix4f;
import com.mojang.math.Vector3f;
import com.mojang.math.Vector4f;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectList;
import java.util.function.BiConsumer;
import net.minecraft.core.Direction;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class ParticleVoxel {
    public float x;
    public float y;
    public float z;
    public float xRot;
    public float yRot;
    public float zRot;
    public boolean mirror;
    public boolean visible = true;
    public BiConsumer<ParticleVoxel, PoseStack> renderCallback;
    public float defaultAngleX;
    public float defaultAngleY;
    public float defaultAngleZ;
    public float defaultOffsetX;
    public float defaultOffsetY;
    public float defaultOffsetZ;
    public float defaultSizeX;
    public float defaultSizeY;
    public float defaultSizeZ;
    public int textureOffsetX;
    public int textureOffsetY;
    public float texWidth;
    public float texHeight;
    public float scaleX;
    public float scaleY;
    public float scaleZ;
    public int index = -1;
    ParticleVoxel parent;
    public final ObjectList<ModelBox> cubeList = new ObjectArrayList();
    public final ObjectList<ParticleVoxel> childModels = new ObjectArrayList();

    public ParticleVoxel(ParticleModel model) {
        this.setScale(1.0f, 1.0f, 1.0f);
        this.setTexSize(model.getTexWidth(), model.getTexHeight());
    }

    public <T extends ParticleVoxel> T callback(BiConsumer<ParticleVoxel, PoseStack> cons) {
        this.renderCallback = cons;
        return (T)this;
    }

    public void translateRotateWithParents(PoseStack matrixStackIn) {
        if (this.parent != null) {
            this.parent.translateRotateWithParents(matrixStackIn);
        }
        matrixStackIn.m_85837_((double)(this.x / 16.0f), (double)(this.y / 16.0f), (double)(this.z / 16.0f));
        if (this.zRot != 0.0f) {
            matrixStackIn.m_85845_(Vector3f.f_122227_.m_122270_(this.zRot));
        }
        if (this.yRot != 0.0f) {
            matrixStackIn.m_85845_(Vector3f.f_122225_.m_122270_(this.yRot));
        }
        if (this.xRot != 0.0f) {
            matrixStackIn.m_85845_(Vector3f.f_122223_.m_122270_(this.xRot));
        }
    }

    public void addChild(ParticleVoxel renderer) {
        this.childModels.add((Object)renderer);
        renderer.parent = this;
    }

    public void setPos(float rotationPointXIn, float rotationPointYIn, float rotationPointZIn) {
        this.x = rotationPointXIn;
        this.y = rotationPointYIn;
        this.z = rotationPointZIn;
    }

    public void setRotationAngle(float rotationAngleXIn, float rotationAngleYIn, float rotationAngleZIn) {
        this.xRot = rotationAngleXIn;
        this.yRot = rotationAngleYIn;
        this.zRot = rotationAngleZIn;
    }

    public void setScale(float x, float y, float z) {
        this.scaleX = x;
        this.scaleY = y;
        this.scaleZ = z;
    }

    public void getDefaultState() {
        this.defaultAngleX = this.xRot;
        this.defaultAngleY = this.yRot;
        this.defaultAngleZ = this.zRot;
        this.defaultOffsetX = this.x;
        this.defaultOffsetY = this.y;
        this.defaultOffsetZ = this.z;
        this.defaultSizeX = this.scaleX;
        this.defaultSizeY = this.scaleY;
        this.defaultSizeZ = this.scaleZ;
    }

    public void setDefaultState() {
        this.xRot = this.defaultAngleX;
        this.yRot = this.defaultAngleY;
        this.zRot = this.defaultAngleZ;
        this.x = this.defaultOffsetX;
        this.y = this.defaultOffsetY;
        this.z = this.defaultOffsetZ;
        this.setScale(this.defaultSizeX, this.defaultSizeY, this.defaultSizeZ);
    }

    public ParticleVoxel texOffs(int x, int y) {
        this.textureOffsetX = x;
        this.textureOffsetY = y;
        return this;
    }

    public ParticleVoxel setTexSize(int textureWidthIn, int textureHeightIn) {
        this.texWidth = textureWidthIn;
        this.texHeight = textureHeightIn;
        return this;
    }

    public ParticleVoxel addBox(String partName, float x, float y, float z, int width, int height, int depth, float delta, int texX, int texY) {
        this.texOffs(texX, texY);
        this.addBox(this.textureOffsetX, this.textureOffsetY, x, y, z, width, height, depth, delta, delta, delta, this.mirror, false);
        return this;
    }

    public ParticleVoxel addBox(float x, float y, float z, float width, float height, float depth) {
        this.addBox(this.textureOffsetX, this.textureOffsetY, x, y, z, width, height, depth, 0.0f, 0.0f, 0.0f, this.mirror, false);
        return this;
    }

    public ParticleVoxel addBox(float x, float y, float z, float width, float height, float depth, boolean mirrorIn) {
        this.addBox(this.textureOffsetX, this.textureOffsetY, x, y, z, width, height, depth, 0.0f, 0.0f, 0.0f, mirrorIn, false);
        return this;
    }

    public void addBox(float x, float y, float z, float width, float height, float depth, float delta) {
        this.addBox(this.textureOffsetX, this.textureOffsetY, x, y, z, width, height, depth, delta, delta, delta, this.mirror, false);
    }

    public void addBox(float x, float y, float z, float width, float height, float depth, float deltaX, float deltaY, float deltaZ) {
        this.addBox(this.textureOffsetX, this.textureOffsetY, x, y, z, width, height, depth, deltaX, deltaY, deltaZ, this.mirror, false);
    }

    public void addBox(float x, float y, float z, float width, float height, float depth, float delta, boolean mirrorIn) {
        this.addBox(this.textureOffsetX, this.textureOffsetY, x, y, z, width, height, depth, delta, delta, delta, mirrorIn, false);
    }

    private void addBox(int texOffX, int texOffY, float x, float y, float z, float width, float height, float depth, float deltaX, float deltaY, float deltaZ, boolean mirorIn, boolean p_228305_13_) {
        this.cubeList.add((Object)new ModelBox(texOffX, texOffY, x, y, z, width, height, depth, deltaX, deltaY, deltaZ, mirorIn, this.texWidth, this.texHeight));
    }

    public void render(PoseStack matrixStackIn, VertexConsumer bufferIn, int packedLightIn, float u0, float u1, float v0, float v1) {
        this.render(matrixStackIn, bufferIn, packedLightIn, u0, u1, v0, v1, 1.0f, 1.0f, 1.0f, 1.0f);
    }

    public void render(PoseStack matrixStackIn, VertexConsumer bufferIn, int packedLightIn, float u0, float u1, float v0, float v1, float red, float green, float blue, float alpha) {
        if (this.visible) {
            matrixStackIn.m_85836_();
            this.translateRotate(matrixStackIn);
            matrixStackIn.m_85841_(this.scaleX, this.scaleY, this.scaleZ);
            if (this.renderCallback != null) {
                this.renderCallback.accept(this, matrixStackIn);
            }
            if (!this.cubeList.isEmpty() || !this.childModels.isEmpty()) {
                this.doRender(matrixStackIn.m_85850_(), bufferIn, packedLightIn, u0, u1, v0, v1, red, green, blue, alpha);
                for (ParticleVoxel modelrenderer : this.childModels) {
                    modelrenderer.render(matrixStackIn, bufferIn, packedLightIn, red, green, blue, alpha);
                }
            }
            matrixStackIn.m_85849_();
        }
    }

    public void translateRotate(PoseStack matrixStackIn) {
        matrixStackIn.m_85837_((double)(this.x / 16.0f), (double)(this.y / 16.0f), (double)(this.z / 16.0f));
        if (this.zRot != 0.0f) {
            matrixStackIn.m_85845_(Vector3f.f_122227_.m_122270_(this.zRot));
        }
        if (this.yRot != 0.0f) {
            matrixStackIn.m_85845_(Vector3f.f_122225_.m_122270_(this.yRot));
        }
        if (this.xRot != 0.0f) {
            matrixStackIn.m_85845_(Vector3f.f_122223_.m_122270_(this.xRot));
        }
    }

    private void doRender(PoseStack.Pose matrixEntryIn, VertexConsumer bufferIn, int packedLightIn, float u0, float u1, float v0, float v1, float red, float green, float blue, float alpha) {
        Matrix4f matrix4f = matrixEntryIn.m_85861_();
        Matrix3f matrix3f = matrixEntryIn.m_85864_();
        for (ModelBox modelrenderer$modelbox : this.cubeList) {
            for (TexturedQuad modelrenderer$texturedquad : modelrenderer$modelbox.quads) {
                float finalV;
                float finalU;
                Vector4f vector4f;
                float f5;
                float f4;
                float f3;
                PositionTextureVertex positiontexturevertex;
                int i;
                Vector3f vector3f = modelrenderer$texturedquad.normal.m_122281_();
                vector3f.m_122249_(matrix3f);
                float f = vector3f.m_122239_();
                float f1 = vector3f.m_122260_();
                float f2 = vector3f.m_122269_();
                for (i = 0; i < 4; ++i) {
                    positiontexturevertex = modelrenderer$texturedquad.vertexPlusWidthositions[i];
                    f3 = positiontexturevertex.position.m_122239_() / 16.0f;
                    f4 = positiontexturevertex.position.m_122260_() / 16.0f;
                    f5 = positiontexturevertex.position.m_122269_() / 16.0f;
                    vector4f = new Vector4f(f3, f4, f5, 1.0f);
                    vector4f.m_123607_(matrix4f);
                    finalU = (u1 - u0) * positiontexturevertex.textureU + u0;
                    finalV = (v1 - v0) * positiontexturevertex.textureV + v0;
                    bufferIn.m_5483_((double)vector4f.m_123601_(), (double)vector4f.m_123615_(), (double)vector4f.m_123616_()).m_7421_(finalU, finalV).m_85950_(red, green, blue, alpha).m_85969_(packedLightIn).m_5752_();
                }
                for (i = 0; i < 4; ++i) {
                    positiontexturevertex = i % 2 == 0 ? modelrenderer$texturedquad.vertexPlusWidthositions[i + 1] : modelrenderer$texturedquad.vertexPlusWidthositions[i - 1];
                    f3 = positiontexturevertex.position.m_122239_() / 16.0f;
                    f4 = positiontexturevertex.position.m_122260_() / 16.0f;
                    f5 = positiontexturevertex.position.m_122269_() / 16.0f;
                    vector4f = new Vector4f(f3, f4, f5, 1.0f);
                    vector4f.m_123607_(matrix4f);
                    finalU = (u1 - u0) * positiontexturevertex.textureU + u0;
                    finalV = (v1 - v0) * positiontexturevertex.textureV + v0;
                    bufferIn.m_5483_((double)vector4f.m_123601_(), (double)vector4f.m_123615_(), (double)vector4f.m_123616_()).m_7421_(finalU, finalV).m_85950_(red, green, blue, alpha).m_85969_(packedLightIn).m_5752_();
                }
            }
        }
    }

    public static class ModelBox {
        protected final TexturedQuad[] quads;
        public float posX1;
        public float posY1;
        public float posZ1;
        public float posX2;
        public float posY2;
        public float posZ2;

        public ModelBox(int texOffX, int texOffY, float x, float y, float z, float width, float height, float depth, float deltaX, float deltaY, float deltaZ, boolean mirorIn, float texWidth, float texHeight) {
            this.posX1 = x;
            this.posY1 = y;
            this.posZ1 = z;
            this.posX2 = x + width;
            this.posY2 = y + height;
            this.posZ2 = z + depth;
            this.quads = new TexturedQuad[6];
            float xPlusWidth = x + width;
            float yPlusHeight = y + height;
            float zPlusDepth = z + depth;
            x -= deltaX;
            y -= deltaY;
            z -= deltaZ;
            xPlusWidth += deltaX;
            yPlusHeight += deltaY;
            zPlusDepth += deltaZ;
            if (mirorIn) {
                float f3 = xPlusWidth;
                xPlusWidth = x;
                x = f3;
            }
            PositionTextureVertex modelrenderer$positiontexturevertex7 = new PositionTextureVertex(x, y, zPlusDepth, 0.0f, 8.0f);
            PositionTextureVertex modelrenderer$positiontexturevertex = new PositionTextureVertex(xPlusWidth, y, zPlusDepth, 8.0f, 0.0f);
            PositionTextureVertex modelrenderer$positiontexturevertex1 = new PositionTextureVertex(xPlusWidth, yPlusHeight, zPlusDepth, 0.0f, 0.0f);
            PositionTextureVertex modelrenderer$positiontexturevertex2 = new PositionTextureVertex(x, yPlusHeight, zPlusDepth, 0.0f, 8.0f);
            PositionTextureVertex modelrenderer$positiontexturevertex3 = new PositionTextureVertex(x, y, z, 8.0f, 8.0f);
            PositionTextureVertex modelrenderer$positiontexturevertex4 = new PositionTextureVertex(xPlusWidth, y, z, 8.0f, 0.0f);
            PositionTextureVertex modelrenderer$positiontexturevertex5 = new PositionTextureVertex(xPlusWidth, yPlusHeight, z, 0.0f, 0.0f);
            PositionTextureVertex modelrenderer$positiontexturevertex6 = new PositionTextureVertex(x, yPlusHeight, z, 0.0f, 8.0f);
            float f4 = texOffX;
            float f5 = (float)texOffX + depth;
            float f6 = (float)texOffX + depth + width;
            float f7 = (float)texOffX + depth + width + width;
            float f8 = (float)texOffX + depth + width + depth;
            float f9 = (float)texOffX + depth + width + depth + width;
            float f10 = texOffY;
            float f11 = (float)texOffY + depth;
            float f12 = (float)texOffY + depth + height;
            this.quads[2] = new TexturedQuad(new PositionTextureVertex[]{modelrenderer$positiontexturevertex4, modelrenderer$positiontexturevertex3, modelrenderer$positiontexturevertex7, modelrenderer$positiontexturevertex}, f5, f10, f6, f11, texWidth, texHeight, mirorIn, Direction.DOWN);
            this.quads[3] = new TexturedQuad(new PositionTextureVertex[]{modelrenderer$positiontexturevertex1, modelrenderer$positiontexturevertex2, modelrenderer$positiontexturevertex6, modelrenderer$positiontexturevertex5}, f6, f11, f7, f10, texWidth, texHeight, mirorIn, Direction.UP);
            this.quads[1] = new TexturedQuad(new PositionTextureVertex[]{modelrenderer$positiontexturevertex7, modelrenderer$positiontexturevertex3, modelrenderer$positiontexturevertex6, modelrenderer$positiontexturevertex2}, f4, f11, f5, f12, texWidth, texHeight, mirorIn, Direction.WEST);
            this.quads[4] = new TexturedQuad(new PositionTextureVertex[]{modelrenderer$positiontexturevertex, modelrenderer$positiontexturevertex7, modelrenderer$positiontexturevertex2, modelrenderer$positiontexturevertex1}, f5, f11, f6, f12, texWidth, texHeight, mirorIn, Direction.NORTH);
            this.quads[0] = new TexturedQuad(new PositionTextureVertex[]{modelrenderer$positiontexturevertex4, modelrenderer$positiontexturevertex, modelrenderer$positiontexturevertex1, modelrenderer$positiontexturevertex5}, f6, f11, f8, f12, texWidth, texHeight, mirorIn, Direction.EAST);
            this.quads[5] = new TexturedQuad(new PositionTextureVertex[]{modelrenderer$positiontexturevertex3, modelrenderer$positiontexturevertex4, modelrenderer$positiontexturevertex5, modelrenderer$positiontexturevertex6}, f8, f11, f9, f12, texWidth, texHeight, mirorIn, Direction.SOUTH);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    static class TexturedQuad {
        public final PositionTextureVertex[] vertexPlusWidthositions;
        public final Vector3f normal;

        public TexturedQuad(PositionTextureVertex[] positionsIn, float u0, float v0, float u1, float v1, float texWidth, float texHeight, boolean mirrorIn, Direction directionIn) {
            this.vertexPlusWidthositions = positionsIn;
            float f = 0.0f / texWidth;
            float f1 = 0.0f / texHeight;
            positionsIn[0] = positionsIn[0].setTextureUV(u1 / texWidth - f, v0 / texHeight + f1);
            positionsIn[1] = positionsIn[1].setTextureUV(u0 / texWidth + f, v0 / texHeight + f1);
            positionsIn[2] = positionsIn[2].setTextureUV(u0 / texWidth + f, v1 / texHeight - f1);
            positionsIn[3] = positionsIn[3].setTextureUV(u1 / texWidth - f, v1 / texHeight - f1);
            if (mirrorIn) {
                int i = positionsIn.length;
                for (int j = 0; j < i / 2; ++j) {
                    PositionTextureVertex MoreContentModelRenderer$positiontexturevertex = positionsIn[j];
                    positionsIn[j] = positionsIn[i - 1 - j];
                    positionsIn[i - 1 - j] = MoreContentModelRenderer$positiontexturevertex;
                }
            }
            this.normal = directionIn.m_122432_();
            if (mirrorIn) {
                this.normal.m_122263_(-1.0f, 1.0f, 1.0f);
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    static class PositionTextureVertex {
        public final Vector3f position;
        public final float textureU;
        public final float textureV;

        public PositionTextureVertex(float x, float y, float z, float texU, float texV) {
            this(new Vector3f(x, y, z), texU, texV);
        }

        public PositionTextureVertex setTextureUV(float texU, float texV) {
            return new PositionTextureVertex(this.position, texU, texV);
        }

        public PositionTextureVertex(Vector3f posIn, float texU, float texV) {
            this.position = posIn;
            this.textureU = texU;
            this.textureV = texV;
        }
    }
}

