/*
 * Decompiled with CFR 0.152.
 */
package com.bottomtextdanny.effective_fg.client.world;

import com.bottomtextdanny.effective_fg.registry.ParticleRegistry;
import com.bottomtextdanny.effective_fg.registry.SoundEventRegistry;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;

public class WaterfallCloudGenerators {
    public static final Set<WaterfallCloudGenerator> generators = Sets.newHashSet();
    private static boolean resolvingWaterfalls;

    public static void addGenerator(Level level, BlockPos blockPos) {
        generators.add(new WaterfallCloudGenerator(level, blockPos));
    }

    public static void removeGenerator(Level level, BlockPos blockPos) {
        generators.removeIf(waterfallCloudGenerator -> waterfallCloudGenerator.level == level && waterfallCloudGenerator.blockPos == blockPos);
    }

    public static void tick() {
        if (Minecraft.m_91087_().f_91074_ == null) {
            return;
        }
        resolvingWaterfalls = true;
        LinkedList generatorsToRemove = Lists.newLinkedList();
        List<WaterfallCloudGenerator> generatorsInDistance = generators.stream().filter(waterfallCloudGenerator -> waterfallCloudGenerator.level == Minecraft.m_91087_().f_91073_ && Math.sqrt(waterfallCloudGenerator.blockPos.m_123331_((Vec3i)Minecraft.m_91087_().f_91074_.m_142538_())) <= (double)((float)Minecraft.m_91087_().f_91066_.f_92106_ * 8.0f)).toList();
        int counter = 0;
        for (WaterfallCloudGenerator waterfallCloudGenerator2 : generatorsInDistance) {
            Level level = waterfallCloudGenerator2.level;
            BlockPos blockPos = waterfallCloudGenerator2.blockPos;
            BlockState stateUp = level.m_8055_(blockPos.m_142082_(0, 1, 0));
            BlockState stateDoubleUp = level.m_8055_(blockPos.m_142082_(0, 2, 0));
            if (level.m_8055_(blockPos).m_60734_() != Blocks.f_49990_ || !level.m_8055_(blockPos).m_60819_().m_76170_() || stateUp.m_60734_() != Blocks.f_49990_ || stateUp.m_60819_().m_76170_() || !(stateUp.m_60819_().m_76182_() >= 0.77f) || !stateDoubleUp.m_60713_(Blocks.f_49990_) || stateDoubleUp.m_60819_().m_76170_()) {
                generatorsToRemove.add(waterfallCloudGenerator2);
                continue;
            }
            if (level.f_46441_.nextInt(3) == 0 && level.m_8055_(blockPos).m_60734_() == Blocks.f_49990_ && level.m_8055_(blockPos).m_60819_().m_76170_() && level.m_8055_(blockPos.m_142082_(0, 1, 0)).m_60734_() == Blocks.f_49990_ && !level.m_8055_(blockPos.m_142082_(0, 1, 0)).m_60819_().m_76170_() && level.m_8055_(blockPos.m_142082_(0, 1, 0)).m_60819_().m_76182_() >= 0.77f) {
                double offsetX = level.f_46441_.nextDouble() / 5.0 + 0.2;
                offsetX = level.f_46441_.nextBoolean() ? offsetX : -offsetX;
                double offsetZ = level.f_46441_.nextDouble() / 5.0 + 0.2;
                double d = offsetZ = level.f_46441_.nextBoolean() ? offsetZ : -offsetZ;
                if (counter < 50 && level.f_46441_.nextInt(9) == 0) {
                    level.m_7785_((double)blockPos.m_123341_(), (double)blockPos.m_123342_(), (double)blockPos.m_123343_(), (SoundEvent)SoundEventRegistry.AMBIENCE_WATERFALL.get(), SoundSource.AMBIENT, 1.5f, 1.2f + level.f_46441_.nextFloat() / 10.0f, true);
                }
                level.m_7106_((ParticleOptions)ParticleRegistry.WATERFALL_CLOUD.get(), (double)blockPos.m_123341_() + 0.5 + offsetX, (double)((float)(blockPos.m_123342_() + 1) + level.f_46441_.nextFloat()), (double)blockPos.m_123343_() + 0.5 + offsetZ, (double)(level.f_46441_.nextFloat() / 5.0f) * Math.signum(offsetX), (double)(level.f_46441_.nextFloat() / 5.0f), (double)(level.f_46441_.nextFloat() / 5.0f) * Math.signum(offsetZ));
            }
            ++counter;
        }
        generators.removeAll(generatorsToRemove);
        generators.removeIf(waterfallCloudGenerator -> waterfallCloudGenerator.level != Minecraft.m_91087_().f_91074_.f_19853_ || Math.sqrt(waterfallCloudGenerator.blockPos.m_123331_((Vec3i)Minecraft.m_91087_().f_91074_.m_142538_())) >= (double)((float)Minecraft.m_91087_().f_91066_.f_92106_ * 16.0f));
        resolvingWaterfalls = false;
    }

    public static boolean isResolvingWaterfalls() {
        return resolvingWaterfalls;
    }

    public static class WaterfallCloudGenerator {
        public Level level;
        public BlockPos blockPos;

        public WaterfallCloudGenerator(Level level, BlockPos blockPos) {
            this.level = level;
            this.blockPos = blockPos;
        }
    }
}

