/*
 * Decompiled with CFR 0.152.
 */
package be.florens.expandability.mixin.fluidcollision;

import be.florens.expandability.EventDispatcher;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.ModifyVariable;

@Mixin(value={Entity.class})
public class EntityMixin {
    @ModifyVariable(method={"move"}, ordinal=1, index=3, name={"vec32"}, at=@At(value="INVOKE_ASSIGN", target="Lnet/minecraft/world/entity/Entity;collide(Lnet/minecraft/world/phys/Vec3;)Lnet/minecraft/world/phys/Vec3;"))
    private Vec3 fluidCollision(Vec3 originalDisplacement) {
        EntityMixin entityMixin = this;
        if (!(entityMixin instanceof LivingEntity)) {
            return originalDisplacement;
        }
        LivingEntity entity = (LivingEntity)entityMixin;
        if (originalDisplacement.f_82480_ <= 0.0 && !EntityMixin.isTouchingFluid(entity, entity.m_142469_().m_82406_(0.001))) {
            Map<Vec3, Double> points = EntityMixin.findFluidDistances(entity, originalDisplacement);
            Double highestDistance = null;
            for (Map.Entry<Vec3, Double> point : points.entrySet()) {
                if (highestDistance != null && (point.getValue() == null || !(point.getValue() > highestDistance))) continue;
                highestDistance = point.getValue();
            }
            if (highestDistance != null) {
                Vec3 finalDisplacement = new Vec3(originalDisplacement.f_82479_, highestDistance.doubleValue(), originalDisplacement.f_82481_);
                AABB finalBox = entity.m_142469_().m_82383_(finalDisplacement).m_82406_(0.001);
                if (EntityMixin.isTouchingFluid(entity, finalBox)) {
                    return originalDisplacement;
                }
                entity.f_19789_ = 0.0f;
                entity.m_6853_(true);
                return finalDisplacement;
            }
        }
        return originalDisplacement;
    }

    @Unique
    private static Map<Vec3, Double> findFluidDistances(LivingEntity entity, Vec3 originalDisplacement) {
        AABB box = entity.m_142469_().m_82383_(originalDisplacement);
        HashMap<Vec3, Double> points = new HashMap<Vec3, Double>();
        points.put(new Vec3(box.f_82288_, box.f_82289_, box.f_82290_), null);
        points.put(new Vec3(box.f_82288_, box.f_82289_, box.f_82293_), null);
        points.put(new Vec3(box.f_82291_, box.f_82289_, box.f_82290_), null);
        points.put(new Vec3(box.f_82291_, box.f_82289_, box.f_82293_), null);
        double fluidStepHeight = entity.m_20096_() ? Math.max(1.0, (double)entity.f_19793_) : 0.0;
        block0: for (Map.Entry entry : points.entrySet()) {
            int i = 0;
            while (true) {
                double limitingVelocity;
                BlockPos landingPos = new BlockPos((Vec3)entry.getKey()).m_142022_(0.0, (double)i + fluidStepHeight, 0.0);
                FluidState landingState = entity.m_20193_().m_6425_(landingPos);
                double distanceToFluidSurface = (double)((float)landingPos.m_123342_() + landingState.m_76182_()) - entity.m_20186_();
                if (distanceToFluidSurface < (limitingVelocity = originalDisplacement.f_82480_) || distanceToFluidSurface > fluidStepHeight) continue block0;
                if (!landingState.m_76178_() && EventDispatcher.onLivingFluidCollision(entity, landingState)) {
                    entry.setValue(distanceToFluidSurface);
                    continue block0;
                }
                --i;
            }
        }
        return points;
    }

    @Unique
    private static boolean isTouchingFluid(LivingEntity entity, AABB box) {
        int minX = Mth.m_14107_((double)box.f_82288_);
        int maxX = Mth.m_14165_((double)box.f_82291_);
        int minY = Mth.m_14107_((double)box.f_82289_);
        int maxY = Mth.m_14165_((double)box.f_82292_);
        int minZ = Mth.m_14107_((double)box.f_82290_);
        int maxZ = Mth.m_14165_((double)box.f_82293_);
        Level world = entity.m_20193_();
        if (world.m_46812_(minX, minY, minZ, maxX, maxY, maxZ)) {
            BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
            for (int i = minX; i < maxX; ++i) {
                for (int j = minY; j < maxY; ++j) {
                    for (int k = minZ; k < maxZ; ++k) {
                        double surfaceY;
                        mutable.m_122178_(i, j, k);
                        FluidState fluidState = world.m_6425_((BlockPos)mutable);
                        if (fluidState.m_76178_() || !((surfaceY = (double)(fluidState.m_76155_((BlockGetter)world, (BlockPos)mutable) + (float)j)) >= box.f_82289_)) continue;
                        return true;
                    }
                }
            }
        }
        return false;
    }
}

