/*
 * Decompiled with CFR 0.152.
 */
package be.florens.expandability.mixin.swimming;

import be.florens.expandability.EventDispatcher;
import be.florens.expandability.EventResult;
import be.florens.expandability.Util;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.Tag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Redirect;

@Mixin(value={Entity.class})
public abstract class EntityMixin {
    @Shadow
    public Level f_19853_;

    @Shadow
    public abstract boolean m_20069_();

    @Shadow
    protected abstract void m_5625_(float var1);

    @Redirect(method={"updateSwimming", "isVisuallyCrawling", "canSpawnSprintParticle", "move"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/entity/Entity;isInWater()Z"))
    private boolean setInWater(Entity entity) {
        if (entity instanceof Player) {
            Player player = (Player)entity;
            return Util.processEventResult(EventDispatcher.onPlayerSwim(player), () -> ((Player)player).m_20069_());
        }
        return entity.m_20069_();
    }

    @Redirect(method={"updateSwimming"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/entity/Entity;isUnderWater()Z"))
    private boolean setUnderWater(Entity entity) {
        if (entity instanceof Player) {
            Player player = (Player)entity;
            return Util.processEventResult(EventDispatcher.onPlayerSwim(player), () -> ((Player)player).m_5842_());
        }
        return entity.m_5842_();
    }

    @Redirect(method={"updateSwimming"}, require=0, at=@At(value="INVOKE", target="Lnet/minecraft/world/level/material/FluidState;is(Lnet/minecraft/tags/Tag;)Z"))
    private boolean setInFluidState(FluidState fluidState, Tag<Fluid> tag) {
        EntityMixin entityMixin = this;
        if (entityMixin instanceof Player) {
            Player player = (Player)entityMixin;
            if (tag == FluidTags.f_13131_) {
                return Util.processEventResult(EventDispatcher.onPlayerSwim(player), () -> fluidState.m_76153_(tag));
            }
        }
        return fluidState.m_76153_(tag);
    }

    @Redirect(method={"move"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/entity/Entity;playSwimSound(F)V"))
    private void cancelPlaySwimSound(Entity entity, float volume) {
        Player player;
        if (!this.m_20069_() && entity instanceof Player && EventDispatcher.onPlayerSwim(player = (Player)entity) == EventResult.SUCCESS) {
            return;
        }
        this.m_5625_(volume);
    }

    @Redirect(method={"updateInWaterStateAndDoWaterCurrentPushing"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/entity/Entity;resetFallDistance()V"))
    private void cancelSetFallDistance(Entity entity) {
        Player player;
        if (entity instanceof Player && EventDispatcher.onPlayerSwim(player = (Player)entity) == EventResult.FAIL) {
            return;
        }
        entity.m_183634_();
    }

    @Redirect(method={"getBlockSpeedFactor"}, at=@At(value="FIELD", opcode=178, target="Lnet/minecraft/world/level/block/Blocks;WATER:Lnet/minecraft/world/level/block/Block;"))
    private Block fixBlockSpeedFactor() {
        Player player;
        Block block;
        EntityMixin entityMixin = this;
        if (entityMixin instanceof Player && (block = player.f_19853_.m_8055_((player = (Player)entityMixin).m_142538_()).m_60734_()) == Blocks.f_49990_ && EventDispatcher.onPlayerSwim(player) == EventResult.FAIL) {
            return Blocks.f_50016_;
        }
        return Blocks.f_49990_;
    }
}

