/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.mutil.data;

import com.google.common.collect.Maps;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.profiling.ProfilerFiller;
import org.apache.commons.io.IOUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import se.mickelus.mutil.data.DataDistributor;
import se.mickelus.mutil.data.DataStore;

public abstract class MergingDataStore<V, U>
extends DataStore<V> {
    private static final Logger logger = LogManager.getLogger();
    protected Class<U> arrayClass;

    public MergingDataStore(Gson gson, String namespace, String directory, Class<V> entryClass, Class<U> arrayClass, DataDistributor synchronizer) {
        super(gson, namespace, directory, entryClass, synchronizer);
        this.arrayClass = arrayClass;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Map<ResourceLocation, JsonElement> prepare(ResourceManager resourceManager, ProfilerFiller profiler) {
        logger.debug("Reading data for {} data store...", (Object)this.directory);
        HashMap map = Maps.newHashMap();
        int i = this.directory.length() + 1;
        for (ResourceLocation fullLocation : resourceManager.m_6540_(this.directory, rl -> rl.endsWith(".json"))) {
            if (!this.namespace.equals(fullLocation.m_135827_())) continue;
            String path = fullLocation.m_135815_();
            ResourceLocation location = new ResourceLocation(fullLocation.m_135827_(), path.substring(i, path.length() - jsonExtLength));
            JsonArray allResources = new JsonArray();
            try {
                for (Resource resource : resourceManager.m_7396_(fullLocation)) {
                    try {
                        InputStream inputstream = resource.m_6679_();
                        try (BufferedReader reader = new BufferedReader(new InputStreamReader(inputstream, StandardCharsets.UTF_8));){
                            JsonObject json = (JsonObject)GsonHelper.m_13776_((Gson)this.gson, (Reader)reader, JsonObject.class);
                            if (json != null) {
                                if (this.shouldLoad((JsonElement)json)) {
                                    allResources.add((JsonElement)json);
                                    continue;
                                }
                                logger.debug("Skipping data '{}' from '{}' due to condition", (Object)fullLocation, (Object)resource.m_7816_());
                                continue;
                            }
                            logger.error("Couldn't load data from '{}' in data pack '{}' as it's empty or null", (Object)fullLocation, (Object)resource.m_7816_());
                        }
                        finally {
                            if (inputstream == null) continue;
                            inputstream.close();
                        }
                    }
                    catch (IOException | RuntimeException e) {
                        logger.error("Couldn't load data from '{}' in data pack '{}'", (Object)fullLocation, (Object)resource.m_7816_(), (Object)e);
                    }
                    finally {
                        IOUtils.closeQuietly((Closeable)resource);
                    }
                }
            }
            catch (IOException e) {
                logger.error("Couldn't load data from '{}'", (Object)fullLocation, (Object)e);
            }
            if (allResources.size() <= 0) continue;
            map.put(location, allResources);
        }
        return map;
    }

    @Override
    public void loadFromPacket(Map<ResourceLocation, String> data) {
        Map<ResourceLocation, JsonElement> splashList = data.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> (JsonElement)GsonHelper.m_13794_((Gson)this.gson, (String)((String)entry.getValue()), JsonArray.class)));
        this.parseData(splashList);
    }

    @Override
    public void parseData(Map<ResourceLocation, JsonElement> splashList) {
        logger.info("Loaded {} {}", (Object)String.format("%3d", splashList.values().size()), (Object)this.directory);
        this.dataMap = splashList.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> this.mergeData(this.gson.fromJson((JsonElement)entry.getValue(), this.arrayClass))));
        this.processData();
        this.listeners.forEach(Runnable::run);
    }

    protected abstract V mergeData(U var1);
}

