/*
 * Decompiled with CFR 0.152.
 */
package fudge.notenoughcrashes.mixins.client;

import fudge.notenoughcrashes.NotEnoughCrashes;
import fudge.notenoughcrashes.mixinhandlers.EntryPointCatcher;
import fudge.notenoughcrashes.mixinhandlers.InGameCatcher;
import fudge.notenoughcrashes.patches.MinecraftClientAccess;
import java.util.Queue;
import java.util.function.Supplier;
import net.minecraft.CrashReport;
import net.minecraft.client.Minecraft;
import net.minecraft.util.profiling.metrics.profiling.MetricsRecorder;
import net.minecraft.util.thread.ReentrantBlockableEventLoop;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Minecraft.class})
public abstract class MixinMinecraftClient
extends ReentrantBlockableEventLoop<Runnable>
implements MinecraftClientAccess {
    @Shadow
    @Nullable
    private Supplier<CrashReport> f_91020_;
    @Shadow
    @Final
    private Queue<Runnable> f_91023_;
    @Shadow
    private MetricsRecorder f_167846_;

    @Override
    public MetricsRecorder getRecorder() {
        return this.f_167846_;
    }

    @Override
    public void setRecorder(MetricsRecorder recorder) {
        this.f_167846_ = recorder;
    }

    public MixinMinecraftClient(String string_1) {
        super(string_1);
    }

    @Inject(method={"run()V"}, at={@At(value="HEAD")})
    private void beforeRun(CallbackInfo ci) {
        if (EntryPointCatcher.crashedDuringStartup()) {
            EntryPointCatcher.displayInitErrorScreen();
        }
    }

    @Inject(method={"run()V"}, at={@At(value="FIELD", target="Lnet/minecraft/client/MinecraftClient;crashReportSupplier:Ljava/util/function/Supplier;")})
    private void onRunLoop(CallbackInfo ci) {
        if (this.f_91020_ != null) {
            NotEnoughCrashes.logDebug("Handling run loop crash");
            InGameCatcher.handleServerCrash(this.f_91020_.get());
            this.f_91020_ = null;
        }
    }

    @ModifyArg(method={"run()V"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/MinecraftClient;printCrashReport(Lnet/minecraft/util/crash/CrashReport;)V", ordinal=1))
    private CrashReport atTheEndOfFirstCatchBeforePrintingCrashReport(CrashReport report) {
        NotEnoughCrashes.logDebug("Handling client game loop try/catch crash in first catch block");
        InGameCatcher.handleClientCrash(report);
        return report;
    }

    @ModifyArg(method={"run()V"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/MinecraftClient;printCrashReport(Lnet/minecraft/util/crash/CrashReport;)V", ordinal=2))
    private CrashReport atTheEndOfSecondCatchBeforePrintingCrashReport(CrashReport report) {
        NotEnoughCrashes.logDebug("Handling client game loop try/catch crash in second catch block");
        InGameCatcher.handleClientCrash(report);
        return report;
    }

    @Inject(method={"run()V"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/MinecraftClient;printCrashReport(Lnet/minecraft/util/crash/CrashReport;)V")}, cancellable=true)
    private void cancelRunLoopAfterCrash(CallbackInfo ci) {
        ci.cancel();
    }

    @Inject(method={"cleanUpAfterCrash()V"}, at={@At(value="HEAD")})
    private void beforeCleanUpAfterCrash(CallbackInfo info) {
        InGameCatcher.cleanupBeforeMinecraft(this.f_91023_);
    }

    @Redirect(method={"startIntegratedServer(Ljava/lang/String;Lnet/minecraft/util/registry/DynamicRegistryManager$Impl;Ljava/util/function/Function;Lcom/mojang/datafixers/util/Function4;ZLnet/minecraft/client/MinecraftClient$WorldLoadAction;)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/MinecraftClient;printCrashReport(Lnet/minecraft/util/crash/CrashReport;)V"))
    private void redirectPrintCrashReport(CrashReport report) {
    }

    @Redirect(method={"doLoadLevel(Ljava/lang/String;Lnet/minecraft/util/registry/DynamicRegistryManager$Impl;Ljava/util/function/Function;Lcom/mojang/datafixers/util/Function4;ZLnet/minecraft/client/MinecraftClient$WorldLoadAction;Z)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/MinecraftClient;printCrashReport(Lnet/minecraft/util/crash/CrashReport;)V"), require=0)
    private void redirectForgePrintCrashReport(CrashReport report) {
    }
}

