/*
 * Decompiled with CFR 0.152.
 */
package ca.spottedleaf.starlight.common.util;

import ca.spottedleaf.starlight.common.chunk.ExtendedChunk;
import ca.spottedleaf.starlight.common.light.SWMRNibbleArray;
import ca.spottedleaf.starlight.common.light.StarLightEngine;
import ca.spottedleaf.starlight.common.util.WorldUtil;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkStatus;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class SaveUtil {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final int STARLIGHT_LIGHT_VERSION = 7;
    private static final String BLOCKLIGHT_STATE_TAG = "starlight.blocklight_state";
    private static final String SKYLIGHT_STATE_TAG = "starlight.skylight_state";
    private static final String STARLIGHT_VERSION_TAG = "starlight.light_version";

    public static void saveLightHook(Level world, ChunkAccess chunk, CompoundTag nbt) {
        try {
            SaveUtil.saveLightHookReal(world, chunk, nbt);
        }
        catch (Exception ex) {
            LOGGER.warn("Failed to inject light data into save data for chunk " + chunk.m_7697_() + ", chunk light will be recalculated on its next load", (Throwable)ex);
        }
    }

    private static void saveLightHookReal(Level world, ChunkAccess chunk, CompoundTag tag) {
        int i;
        boolean lit;
        if (tag == null) {
            return;
        }
        int minSection = WorldUtil.getMinLightSection((LevelHeightAccessor)world);
        int maxSection = WorldUtil.getMaxLightSection((LevelHeightAccessor)world);
        SWMRNibbleArray[] blockNibbles = ((ExtendedChunk)chunk).getBlockNibbles();
        SWMRNibbleArray[] skyNibbles = ((ExtendedChunk)chunk).getSkyNibbles();
        boolean bl = lit = chunk.m_6332_() || !(world instanceof ServerLevel);
        if (lit) {
            tag.m_128379_("isLightOn", false);
        }
        ChunkStatus status = ChunkStatus.m_62397_((String)tag.m_128461_("Status"));
        CompoundTag[] sections = new CompoundTag[maxSection - minSection + 1];
        ListTag sectionsStored = tag.m_128437_("sections", 10);
        for (i = 0; i < sectionsStored.size(); ++i) {
            CompoundTag sectionStored = sectionsStored.m_128728_(i);
            byte k = sectionStored.m_128445_("Y");
            sectionStored.m_128473_("BlockLight");
            sectionStored.m_128473_("SkyLight");
            if (sectionStored.m_128456_()) continue;
            sections[k - minSection] = sectionStored;
        }
        if (lit && status.m_62427_(ChunkStatus.f_62323_)) {
            for (i = minSection; i <= maxSection; ++i) {
                SWMRNibbleArray.SaveState blockNibble = blockNibbles[i - minSection].getSaveState();
                SWMRNibbleArray.SaveState skyNibble = skyNibbles[i - minSection].getSaveState();
                if (blockNibble == null && skyNibble == null) continue;
                CompoundTag section = sections[i - minSection];
                if (section == null) {
                    section = new CompoundTag();
                    section.m_128344_("Y", (byte)i);
                    sections[i - minSection] = section;
                }
                if (blockNibble != null) {
                    if (blockNibble.data != null) {
                        section.m_128382_("BlockLight", blockNibble.data);
                    }
                    section.m_128405_(BLOCKLIGHT_STATE_TAG, blockNibble.state);
                }
                if (skyNibble == null) continue;
                if (skyNibble.data != null) {
                    section.m_128382_("SkyLight", skyNibble.data);
                }
                section.m_128405_(SKYLIGHT_STATE_TAG, skyNibble.state);
            }
        }
        sectionsStored.clear();
        for (CompoundTag section : sections) {
            if (section == null) continue;
            sectionsStored.add((Object)section);
        }
        tag.m_128365_("sections", (Tag)sectionsStored);
        if (lit) {
            tag.m_128405_(STARLIGHT_VERSION_TAG, 7);
        }
    }

    public static void loadLightHook(Level world, ChunkPos pos, CompoundTag tag, ChunkAccess into) {
        try {
            SaveUtil.loadLightHookReal(world, pos, tag, into);
        }
        catch (Exception ex) {
            LOGGER.warn("Failed to load light for chunk " + pos + ", light will be recalculated", (Throwable)ex);
        }
    }

    private static void loadLightHookReal(Level world, ChunkPos pos, CompoundTag tag, ChunkAccess into) {
        if (into == null) {
            return;
        }
        int minSection = WorldUtil.getMinLightSection((LevelHeightAccessor)world);
        int maxSection = WorldUtil.getMaxLightSection((LevelHeightAccessor)world);
        into.m_8094_(false);
        SWMRNibbleArray[] blockNibbles = StarLightEngine.getFilledEmptyLight((LevelHeightAccessor)world);
        SWMRNibbleArray[] skyNibbles = StarLightEngine.getFilledEmptyLight((LevelHeightAccessor)world);
        boolean lit = tag.m_128423_("isLightOn") != null && tag.m_128451_(STARLIGHT_VERSION_TAG) == 7;
        boolean canReadSky = world.m_6042_().m_63935_();
        ChunkStatus status = ChunkStatus.m_62397_((String)tag.m_128461_("Status"));
        if (lit && status.m_62427_(ChunkStatus.f_62323_)) {
            ListTag sections = tag.m_128437_("sections", 10);
            for (int i = 0; i < sections.size(); ++i) {
                CompoundTag sectionData = sections.m_128728_(i);
                byte y = sectionData.m_128445_("Y");
                blockNibbles[y - minSection] = sectionData.m_128425_("BlockLight", 7) ? new SWMRNibbleArray((byte[])sectionData.m_128463_("BlockLight").clone(), sectionData.m_128451_(BLOCKLIGHT_STATE_TAG)) : new SWMRNibbleArray(null, sectionData.m_128451_(BLOCKLIGHT_STATE_TAG));
                if (!canReadSky) continue;
                skyNibbles[y - minSection] = sectionData.m_128425_("SkyLight", 7) ? new SWMRNibbleArray((byte[])sectionData.m_128463_("SkyLight").clone(), sectionData.m_128451_(SKYLIGHT_STATE_TAG)) : new SWMRNibbleArray(null, sectionData.m_128451_(SKYLIGHT_STATE_TAG));
            }
        }
        ((ExtendedChunk)into).setBlockNibbles(blockNibbles);
        ((ExtendedChunk)into).setSkyNibbles(skyNibbles);
        into.m_8094_(lit);
    }

    private SaveUtil() {
    }
}

