/*
 * Decompiled with CFR 0.152.
 */
package snownee.kiwi;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.mojang.datafixers.types.Type;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import net.minecraft.core.NonNullList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.EntityTypeTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.Tag;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Material;
import net.minecraftforge.forge.event.lifecycle.GatherDataEvent;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.jetbrains.annotations.Nullable;
import snownee.kiwi.ModuleInfo;
import snownee.kiwi.block.ModBlock;
import snownee.kiwi.loader.event.ClientInitEvent;
import snownee.kiwi.loader.event.InitEvent;
import snownee.kiwi.loader.event.PostInitEvent;
import snownee.kiwi.loader.event.ServerInitEvent;
import snownee.kiwi.mixin.ItemAccessor;

public abstract class AbstractModule {
    public ResourceLocation uid;
    private static final BiConsumer<ModuleInfo, Item> ITEM_DECORATOR = (module, item) -> {
        if (module.category != null && ((ItemAccessor)item).getCategory() == null && !module.noCategories.contains(item)) {
            ((ItemAccessor)item).setCategory(module.category);
        }
    };
    private static final BiConsumer<ModuleInfo, Block> BLOCK_DECORATOR = (module, block) -> ModBlock.setFireInfo(block);
    private static final Map<Class<?>, BiConsumer<ModuleInfo, ? extends IForgeRegistryEntry<?>>> DEFAULT_DECORATORS = ImmutableMap.of(Item.class, ITEM_DECORATOR, Block.class, BLOCK_DECORATOR);
    protected final Map<Class<?>, BiConsumer<ModuleInfo, ? extends IForgeRegistryEntry<?>>> decorators = Maps.newHashMap(DEFAULT_DECORATORS);

    protected void preInit() {
    }

    protected void init(InitEvent event) {
    }

    protected void clientInit(ClientInitEvent event) {
    }

    protected void serverInit(ServerInitEvent event) {
    }

    protected void postInit(PostInitEvent event) {
    }

    protected void gatherData(GatherDataEvent event) {
    }

    protected static Item.Properties itemProp() {
        return new Item.Properties();
    }

    protected static BlockBehaviour.Properties blockProp(Material material) {
        BlockBehaviour.Properties properties = BlockBehaviour.Properties.m_60939_((Material)material);
        properties.m_60918_(ModBlock.deduceSoundType(material));
        properties.m_60978_(ModBlock.deduceHardness(material));
        return properties;
    }

    protected static BlockBehaviour.Properties blockProp(BlockBehaviour block) {
        return BlockBehaviour.Properties.m_60926_((BlockBehaviour)block);
    }

    public static <T extends BlockEntity> BlockEntityType<T> blockEntity(BlockEntityType.BlockEntitySupplier<? extends T> factory, Type<?> datafixer, Block ... blocks) {
        return BlockEntityType.Builder.m_155273_(factory, (Block[])blocks).m_58966_(datafixer);
    }

    public static CreativeModeTab itemCategory(String namespace, String path, final Supplier<ItemStack> icon, final @Nullable BiConsumer<List<ItemStack>, CreativeModeTab> stacksForDisplay) {
        return new CreativeModeTab(namespace + "." + path){

            public ItemStack m_6976_() {
                return (ItemStack)icon.get();
            }

            public void m_6151_(NonNullList<ItemStack> stacks) {
                if (stacksForDisplay != null) {
                    stacksForDisplay.accept(stacks, this);
                    return;
                }
                super.m_6151_(stacks);
            }
        };
    }

    public static Tag.Named<Item> itemTag(String namespace, String path) {
        return ItemTags.m_13194_((String)(namespace + ":" + path));
    }

    public static Tag.Named<EntityType<?>> entityTag(String namespace, String path) {
        return EntityTypeTags.m_13127_((String)(namespace + ":" + path));
    }

    public static Tag.Named<Block> blockTag(String namespace, String path) {
        return BlockTags.m_13116_((String)(namespace + ":" + path));
    }

    public static Tag.Named<Fluid> fluidTag(String namespace, String path) {
        return FluidTags.m_13134_((String)(namespace + ":" + path));
    }

    public ResourceLocation RL(String path) {
        return new ResourceLocation(this.uid.m_135827_(), path);
    }
}

