/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.backpacked.client.renderer.entity.layers;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Vector3d;
import com.mojang.math.Vector3f;
import com.mrcrayfish.backpacked.client.model.BackpackModel;
import com.mrcrayfish.backpacked.client.renderer.entity.layers.BackpackLayer;
import com.mrcrayfish.backpacked.core.ModItems;
import com.mrcrayfish.backpacked.tileentity.ShelfBlockEntity;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;

public class ShelfRenderer
implements BlockEntityRenderer<ShelfBlockEntity> {
    public ShelfRenderer(BlockEntityRendererProvider.Context context) {
    }

    public void render(ShelfBlockEntity entity, float partialTick, PoseStack poseStack, MultiBufferSource buffer, int light, int overlay) {
        ItemStack stack = entity.getBackpack();
        if (stack.m_41720_() != ModItems.BACKPACK.get()) {
            return;
        }
        CompoundTag tag = stack.m_41784_();
        String modelName = tag.m_128461_("BackpackModel");
        BackpackModel model = BackpackLayer.getModel(modelName).get();
        Direction facing = entity.getDirection();
        poseStack.m_85837_(0.5, 0.0, 0.5);
        poseStack.m_85837_(0.0, 0.3125, 0.0);
        poseStack.m_85837_(0.0, 0.001, 0.0);
        poseStack.m_85845_(facing.m_122406_());
        Vector3d offset = model.getShelfOffset();
        poseStack.m_85837_(offset.f_86214_ * 0.0625, offset.f_86216_ * 0.0625, -offset.f_86215_ * 0.0625);
        poseStack.m_85845_(Vector3f.f_122225_.m_122240_(180.0f));
        poseStack.m_85845_(Vector3f.f_122223_.m_122240_(-90.0f));
        int animationTick = Optional.ofNullable(Minecraft.m_91087_().f_91074_).map(player -> player.f_19797_).orElse(0);
        VertexConsumer builder = buffer.m_6299_(model.m_103119_(model.getTextureLocation()));
        model.setupAngles(null, animationTick, partialTick);
        model.getStraps().f_104207_ = false;
        model.getBag().m_104227_(0.0f, 0.0f, 0.0f);
        model.getBag().m_104301_(poseStack, builder, light, overlay);
    }
}

