/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.backpacked.network;

import com.mrcrayfish.backpacked.network.message.IMessage;
import com.mrcrayfish.backpacked.network.message.MessageBackpackCosmetics;
import com.mrcrayfish.backpacked.network.message.MessageEntityBackpack;
import com.mrcrayfish.backpacked.network.message.MessageOpenBackpack;
import com.mrcrayfish.backpacked.network.message.MessageOpenCustomisation;
import com.mrcrayfish.backpacked.network.message.MessageRequestCustomisation;
import com.mrcrayfish.backpacked.network.message.MessageSyncUnlockTracker;
import com.mrcrayfish.backpacked.network.message.MessageSyncVillagerBackpack;
import com.mrcrayfish.backpacked.network.message.MessageUnlockBackpack;
import com.mrcrayfish.backpacked.network.message.MessageUpdateBackpack;
import java.util.Optional;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.simple.SimpleChannel;

public class Network {
    private static final String PROTOCOL_VERSION = "1";
    private static int nextId = 0;
    private static SimpleChannel playChannel;

    public static void init() {
        playChannel = NetworkRegistry.ChannelBuilder.named((ResourceLocation)new ResourceLocation("backpacked", "network")).networkProtocolVersion(() -> PROTOCOL_VERSION).clientAcceptedVersions(PROTOCOL_VERSION::equals).serverAcceptedVersions(PROTOCOL_VERSION::equals).simpleChannel();
        Network.register(MessageOpenBackpack.class, new MessageOpenBackpack(), NetworkDirection.PLAY_TO_SERVER);
        Network.register(MessageUpdateBackpack.class, new MessageUpdateBackpack(), NetworkDirection.PLAY_TO_CLIENT);
        Network.register(MessageEntityBackpack.class, new MessageEntityBackpack(), NetworkDirection.PLAY_TO_SERVER);
        Network.register(MessageBackpackCosmetics.class, new MessageBackpackCosmetics(), NetworkDirection.PLAY_TO_SERVER);
        Network.register(MessageSyncUnlockTracker.class, new MessageSyncUnlockTracker(), NetworkDirection.PLAY_TO_CLIENT);
        Network.register(MessageUnlockBackpack.class, new MessageUnlockBackpack(), NetworkDirection.PLAY_TO_CLIENT);
        Network.register(MessageRequestCustomisation.class, new MessageRequestCustomisation(), NetworkDirection.PLAY_TO_SERVER);
        Network.register(MessageOpenCustomisation.class, new MessageOpenCustomisation(), NetworkDirection.PLAY_TO_CLIENT);
        Network.register(MessageSyncVillagerBackpack.class, new MessageSyncVillagerBackpack(), NetworkDirection.PLAY_TO_CLIENT);
    }

    private static <T> void register(Class<T> clazz, IMessage<T> message, NetworkDirection direction) {
        playChannel.registerMessage(nextId++, clazz, message::encode, message::decode, message::handle, Optional.of(direction));
    }

    public static SimpleChannel getPlayChannel() {
        return playChannel;
    }
}

