/*
 * Decompiled with CFR 0.152.
 */
package top.seraphjack.simplelogin.client;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.ChatScreen;
import net.minecraft.client.multiplayer.ClientSuggestionProvider;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.ClientChatEvent;
import net.minecraftforge.client.event.ScreenEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import top.seraphjack.simplelogin.SimpleLogin;
import top.seraphjack.simplelogin.client.PasswordHolder;
import top.seraphjack.simplelogin.network.MessageChangePassword;
import top.seraphjack.simplelogin.network.NetworkLoader;

@Mod.EventBusSubscriber(modid="simplelogin", value={Dist.CLIENT})
public final class ClientCommands {
    private static final CommandDispatcher<SharedSuggestionProvider> dispatcher = new CommandDispatcher();
    private static final LiteralArgumentBuilder<SharedSuggestionProvider> commandChangePassword = (LiteralArgumentBuilder)ClientCommands.literal("sl_change_password").then(ClientCommands.argument("password", StringArgumentType.greedyString()).executes(ClientCommands::changePassword));
    private static boolean active;

    @SubscribeEvent
    public static void openGui(ScreenEvent.InitScreenEvent event) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null) {
            return;
        }
        if (event.getScreen() instanceof ChatScreen && !active) {
            active = true;
            player.f_108617_.m_105146_().register(commandChangePassword);
        }
    }

    @SubscribeEvent
    public static void onChat(ClientChatEvent event) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null) {
            return;
        }
        String msg = event.getMessage();
        if (msg.startsWith("/sl_")) {
            event.setCanceled(true);
            StringReader sr = new StringReader(msg);
            sr.skip();
            ClientSuggestionProvider cs = player.f_108617_.m_105137_();
            try {
                dispatcher.execute(sr, (Object)cs);
            }
            catch (CommandSyntaxException e) {
                player.m_5661_((Component)new TranslatableComponent(e.getLocalizedMessage()), false);
                SimpleLogin.logger.error("Error syntax command", (Throwable)e);
            }
        }
    }

    private static LiteralArgumentBuilder<SharedSuggestionProvider> literal(String name) {
        return LiteralArgumentBuilder.literal((String)name);
    }

    private static <T> RequiredArgumentBuilder<SharedSuggestionProvider, T> argument(String name, ArgumentType<T> argumentType) {
        return RequiredArgumentBuilder.argument((String)name, argumentType);
    }

    private static int changePassword(CommandContext<SharedSuggestionProvider> ctx) {
        if (Minecraft.m_91087_().f_91074_ != null) {
            String password = StringArgumentType.getString(ctx, (String)"password");
            NetworkLoader.INSTANCE.sendToServer((Object)new MessageChangePassword(PasswordHolder.instance().password(), password));
            PasswordHolder.instance().setPendingPassword(password);
        }
        return 1;
    }

    static {
        dispatcher.register(commandChangePassword);
        active = false;
    }
}

