/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create;

import com.simibubi.create.Create;
import com.simibubi.create.foundation.data.CreateRegistrate;
import com.simibubi.create.foundation.utility.Lang;
import com.simibubi.create.repack.registrate.builders.BlockBuilder;
import com.simibubi.create.repack.registrate.builders.ItemBuilder;
import com.simibubi.create.repack.registrate.providers.ProviderType;
import com.simibubi.create.repack.registrate.util.nullness.NonNullFunction;
import java.util.function.Function;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.Tag;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.common.Tags;

public class AllTags {
    private static final CreateRegistrate REGISTRATE = (CreateRegistrate)Create.registrate().creativeModeTab(() -> Create.BASE_CREATIVE_TAB);

    public static <T> Tag.Named<T> tag(Function<ResourceLocation, Tag.Named<T>> wrapperFactory, String namespace, String path) {
        return wrapperFactory.apply(new ResourceLocation(namespace, path));
    }

    public static <T> Tag.Named<T> forgeTag(Function<ResourceLocation, Tag.Named<T>> wrapperFactory, String path) {
        return AllTags.tag(wrapperFactory, "forge", path);
    }

    public static Tag.Named<Block> forgeBlockTag(String path) {
        return AllTags.forgeTag(BlockTags::createOptional, path);
    }

    public static Tag.Named<Item> forgeItemTag(String path) {
        return AllTags.forgeTag(ItemTags::createOptional, path);
    }

    public static Tag.Named<Fluid> forgeFluidTag(String path) {
        return AllTags.forgeTag(FluidTags::createOptional, path);
    }

    public static <T extends Block, P> NonNullFunction<BlockBuilder<T, P>, BlockBuilder<T, P>> axeOrPickaxe() {
        return b -> b.tag(BlockTags.f_144280_).tag(BlockTags.f_144282_);
    }

    public static <T extends Block, P> NonNullFunction<BlockBuilder<T, P>, BlockBuilder<T, P>> axeOnly() {
        return b -> b.tag(BlockTags.f_144280_);
    }

    public static <T extends Block, P> NonNullFunction<BlockBuilder<T, P>, BlockBuilder<T, P>> pickaxeOnly() {
        return b -> b.tag(BlockTags.f_144282_);
    }

    public static <T extends Block, P> NonNullFunction<BlockBuilder<T, P>, ItemBuilder<BlockItem, BlockBuilder<T, P>>> tagBlockAndItem(String ... path) {
        return b -> {
            for (String p : path) {
                b.tag(AllTags.forgeBlockTag(p));
            }
            ItemBuilder item = b.item();
            for (String p : path) {
                item.tag(AllTags.forgeItemTag(p));
            }
            return item;
        };
    }

    public static void register() {
        AllFluidTags.BOTTOMLESS_ALLOW.add(new Fluid[]{Fluids.f_76193_, Fluids.f_76195_});
        AllItemTags.CREATE_INGOTS.includeIn(AllItemTags.BEACON_PAYMENT);
        AllItemTags.CREATE_INGOTS.includeIn((Tag.Named<Item>)Tags.Items.INGOTS);
        AllItemTags.UPRIGHT_ON_BELT.add(Items.f_42590_, Items.f_42589_, Items.f_42736_, Items.f_42739_, Items.f_42787_, Items.f_42502_);
        AllBlockTags.WINDMILL_SAILS.includeAll((Tag.Named<Block>)BlockTags.f_13089_);
        AllBlockTags.BRITTLE.includeAll((Tag.Named<Block>)BlockTags.f_13103_);
        AllBlockTags.BRITTLE.includeAll((Tag.Named<Block>)BlockTags.f_13038_);
        AllBlockTags.BRITTLE.add(Blocks.f_50276_, Blocks.f_50680_, Blocks.f_50262_);
        AllBlockTags.FAN_TRANSPARENT.includeAll((Tag.Named<Block>)BlockTags.f_13039_);
        AllBlockTags.FAN_TRANSPARENT.add(Blocks.f_50183_, Blocks.f_50683_, Blocks.f_50684_);
        AllBlockTags.FAN_HEATERS.add(Blocks.f_50450_, Blocks.f_50683_, Blocks.f_49991_, Blocks.f_50083_, Blocks.f_50084_, Blocks.f_50684_);
        AllBlockTags.SAFE_NBT.includeAll((Tag.Named<Block>)BlockTags.f_13068_);
        AllBlockTags.WRENCH_PICKUP.includeAll((Tag.Named<Block>)BlockTags.f_13034_);
        AllBlockTags.WRENCH_PICKUP.includeAll((Tag.Named<Block>)BlockTags.f_13093_);
        AllBlockTags.WRENCH_PICKUP.includeAll((Tag.Named<Block>)BlockTags.f_13099_);
        AllBlockTags.WRENCH_PICKUP.add(Blocks.f_50088_, Blocks.f_50174_, Blocks.f_50146_, Blocks.f_50164_, Blocks.f_50328_, Blocks.f_50455_, Blocks.f_50123_, Blocks.f_50039_, Blocks.f_50032_, Blocks.f_50267_, Blocks.f_50266_, Blocks.f_50329_, Blocks.f_50716_);
        AllBlockTags.ORE_OVERRIDE_STONE.includeAll((Tag.Named<Block>)BlockTags.f_144266_);
    }

    public static enum AllFluidTags {
        BOTTOMLESS_ALLOW(NameSpace.MOD, "bottomless/allow"),
        BOTTOMLESS_DENY(NameSpace.MOD, "bottomless/deny"),
        HONEY(NameSpace.FORGE);

        public final Tag.Named<Fluid> tag;

        private AllFluidTags() {
            this(NameSpace.MOD);
        }

        private AllFluidTags(NameSpace namespace) {
            this(namespace, namespace.optionalDefault, namespace.alwaysDatagenDefault);
        }

        private AllFluidTags(NameSpace namespace, String path) {
            this(namespace, path, namespace.optionalDefault, namespace.alwaysDatagenDefault);
        }

        private AllFluidTags(NameSpace namespace, boolean optional, boolean alwaysDatagen) {
            this(namespace, null, optional, alwaysDatagen);
        }

        private AllFluidTags(NameSpace namespace, String path, boolean optional, boolean alwaysDatagen) {
            ResourceLocation id = new ResourceLocation(namespace.id, path == null ? Lang.asId(this.name()) : path);
            this.tag = optional ? FluidTags.createOptional((ResourceLocation)id) : FluidTags.m_13134_((String)id.toString());
            if (alwaysDatagen) {
                REGISTRATE.addDataGenerator(ProviderType.FLUID_TAGS, prov -> prov.m_126548_(this.tag));
            }
        }

        public boolean matches(Fluid fluid) {
            return fluid != null && fluid.m_76108_(this.tag);
        }

        public void add(Fluid ... values) {
            REGISTRATE.addDataGenerator(ProviderType.FLUID_TAGS, prov -> prov.m_126548_(this.tag).m_126584_((Object[])values));
        }

        public void includeIn(Tag.Named<Fluid> parent) {
            REGISTRATE.addDataGenerator(ProviderType.FLUID_TAGS, prov -> prov.m_126548_(parent).m_126580_(this.tag));
        }

        public void includeIn(AllFluidTags parent) {
            this.includeIn(parent.tag);
        }

        public void includeAll(Tag.Named<Fluid> child) {
            REGISTRATE.addDataGenerator(ProviderType.FLUID_TAGS, prov -> prov.m_126548_(this.tag).m_126580_(child));
        }
    }

    public static enum AllItemTags {
        BLAZE_BURNER_FUEL_REGULAR(NameSpace.MOD, "blaze_burner_fuel/regular"),
        BLAZE_BURNER_FUEL_SPECIAL(NameSpace.MOD, "blaze_burner_fuel/special"),
        CREATE_INGOTS,
        CRUSHED_ORES,
        SANDPAPER,
        SEATS,
        TOOLBOXES,
        UPRIGHT_ON_BELT,
        VALVE_HANDLES,
        BEACON_PAYMENT(NameSpace.FORGE),
        PLATES(NameSpace.FORGE);

        public final Tag.Named<Item> tag;

        private AllItemTags() {
            this(NameSpace.MOD);
        }

        private AllItemTags(NameSpace namespace) {
            this(namespace, namespace.optionalDefault, namespace.alwaysDatagenDefault);
        }

        private AllItemTags(NameSpace namespace, String path) {
            this(namespace, path, namespace.optionalDefault, namespace.alwaysDatagenDefault);
        }

        private AllItemTags(NameSpace namespace, boolean optional, boolean alwaysDatagen) {
            this(namespace, null, optional, alwaysDatagen);
        }

        private AllItemTags(NameSpace namespace, String path, boolean optional, boolean alwaysDatagen) {
            ResourceLocation id = new ResourceLocation(namespace.id, path == null ? Lang.asId(this.name()) : path);
            this.tag = optional ? ItemTags.createOptional((ResourceLocation)id) : ItemTags.m_13194_((String)id.toString());
            if (alwaysDatagen) {
                REGISTRATE.addDataGenerator(ProviderType.ITEM_TAGS, prov -> prov.m_126548_(this.tag));
            }
        }

        public boolean matches(ItemStack stack) {
            return this.tag.m_8110_((Object)stack.m_41720_());
        }

        public void add(Item ... values) {
            REGISTRATE.addDataGenerator(ProviderType.ITEM_TAGS, prov -> prov.m_126548_(this.tag).m_126584_((Object[])values));
        }

        public void includeIn(Tag.Named<Item> parent) {
            REGISTRATE.addDataGenerator(ProviderType.ITEM_TAGS, prov -> prov.m_126548_(parent).m_126580_(this.tag));
        }

        public void includeIn(AllItemTags parent) {
            this.includeIn(parent.tag);
        }

        public void includeAll(Tag.Named<Item> child) {
            REGISTRATE.addDataGenerator(ProviderType.ITEM_TAGS, prov -> prov.m_126548_(this.tag).m_126580_(child));
        }
    }

    public static enum AllBlockTags {
        BRITTLE,
        FAN_HEATERS,
        FAN_TRANSPARENT,
        ORE_OVERRIDE_STONE,
        SAFE_NBT,
        SEATS,
        TOOLBOXES,
        VALVE_HANDLES,
        WINDMILL_SAILS,
        WINDOWABLE,
        WRENCH_PICKUP,
        WG_STONE(NameSpace.FORGE),
        SLIMY_LOGS(NameSpace.TIC);

        public final Tag.Named<Block> tag;

        private AllBlockTags() {
            this(NameSpace.MOD);
        }

        private AllBlockTags(NameSpace namespace) {
            this(namespace, namespace.optionalDefault, namespace.alwaysDatagenDefault);
        }

        private AllBlockTags(NameSpace namespace, String path) {
            this(namespace, path, namespace.optionalDefault, namespace.alwaysDatagenDefault);
        }

        private AllBlockTags(NameSpace namespace, boolean optional, boolean alwaysDatagen) {
            this(namespace, null, optional, alwaysDatagen);
        }

        private AllBlockTags(NameSpace namespace, String path, boolean optional, boolean alwaysDatagen) {
            ResourceLocation id = new ResourceLocation(namespace.id, path == null ? Lang.asId(this.name()) : path);
            this.tag = optional ? BlockTags.createOptional((ResourceLocation)id) : BlockTags.m_13116_((String)id.toString());
            if (alwaysDatagen) {
                REGISTRATE.addDataGenerator(ProviderType.BLOCK_TAGS, prov -> prov.m_126548_(this.tag));
            }
        }

        public boolean matches(Block block) {
            return this.tag.m_8110_((Object)block);
        }

        public boolean matches(BlockState state) {
            return this.matches(state.m_60734_());
        }

        public void add(Block ... values) {
            REGISTRATE.addDataGenerator(ProviderType.BLOCK_TAGS, prov -> prov.m_126548_(this.tag).m_126584_((Object[])values));
        }

        public void includeIn(Tag.Named<Block> parent) {
            REGISTRATE.addDataGenerator(ProviderType.BLOCK_TAGS, prov -> prov.m_126548_(parent).m_126580_(this.tag));
        }

        public void includeIn(AllBlockTags parent) {
            this.includeIn(parent.tag);
        }

        public void includeAll(Tag.Named<Block> child) {
            REGISTRATE.addDataGenerator(ProviderType.BLOCK_TAGS, prov -> prov.m_126548_(this.tag).m_126580_(child));
        }
    }

    public static enum NameSpace {
        MOD("create", false, true),
        FORGE("forge"),
        TIC("tconstruct");

        public final String id;
        public final boolean optionalDefault;
        public final boolean alwaysDatagenDefault;

        private NameSpace(String id) {
            this(id, true, false);
        }

        private NameSpace(String id, boolean optionalDefault, boolean alwaysDatagenDefault) {
            this.id = id;
            this.optionalDefault = optionalDefault;
            this.alwaysDatagenDefault = alwaysDatagenDefault;
        }
    }
}

