/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.components.actors.dispenser;

import com.simibubi.create.content.contraptions.components.actors.dispenser.DispenserMovementBehaviour;
import com.simibubi.create.content.contraptions.components.actors.dispenser.MovedDefaultDispenseItemBehaviour;
import com.simibubi.create.content.contraptions.components.actors.dispenser.MovedOptionalDispenseBehaviour;
import com.simibubi.create.content.contraptions.components.actors.dispenser.MovedProjectileDispenserBehaviour;
import com.simibubi.create.content.contraptions.components.structureMovement.MovementContext;
import java.util.Random;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.Tag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.item.PrimedTnt;
import net.minecraft.world.entity.projectile.FireworkRocketEntity;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.SmallFireball;
import net.minecraft.world.entity.projectile.ThrownPotion;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.BeehiveBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BucketPickup;
import net.minecraft.world.level.block.entity.BeehiveBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;

public interface IMovedDispenseItemBehaviour {
    public static void initSpawneggs() {
        MovedDefaultDispenseItemBehaviour spawnEggDispenseBehaviour = new MovedDefaultDispenseItemBehaviour(){

            @Override
            protected ItemStack dispenseStack(ItemStack itemStack, MovementContext context, BlockPos pos, Vec3 facing) {
                EntityType entityType;
                Entity spawnedEntity;
                if (!(itemStack.m_41720_() instanceof SpawnEggItem)) {
                    return super.dispenseStack(itemStack, context, pos, facing);
                }
                if (context.world instanceof ServerLevel && (spawnedEntity = (entityType = ((SpawnEggItem)itemStack.m_41720_()).m_43228_(itemStack.m_41783_())).m_20592_((ServerLevel)context.world, itemStack, null, pos.m_142022_(facing.f_82479_ + 0.7, facing.f_82480_ + 0.7, facing.f_82481_ + 0.7), MobSpawnType.DISPENSER, facing.f_82480_ < 0.5, false)) != null) {
                    spawnedEntity.m_20256_(context.motion.m_82490_(2.0));
                }
                itemStack.m_41774_(1);
                return itemStack;
            }
        };
        for (SpawnEggItem spawneggitem : SpawnEggItem.m_43233_()) {
            DispenserMovementBehaviour.registerMovedDispenseItemBehaviour((Item)spawneggitem, spawnEggDispenseBehaviour);
        }
    }

    public static void init() {
        MovedProjectileDispenserBehaviour movedPotionDispenseItemBehaviour = new MovedProjectileDispenserBehaviour(){

            @Override
            protected Projectile getProjectileEntity(Level world, double x, double y, double z, ItemStack itemStack) {
                return (Projectile)Util.m_137469_((Object)new ThrownPotion(world, x, y, z), p_218411_1_ -> p_218411_1_.m_37446_(itemStack));
            }

            @Override
            protected float getProjectileInaccuracy() {
                return super.getProjectileInaccuracy() * 0.5f;
            }

            @Override
            protected float getProjectileVelocity() {
                return super.getProjectileVelocity() * 0.5f;
            }
        };
        DispenserMovementBehaviour.registerMovedDispenseItemBehaviour(Items.f_42736_, movedPotionDispenseItemBehaviour);
        DispenserMovementBehaviour.registerMovedDispenseItemBehaviour(Items.f_42739_, movedPotionDispenseItemBehaviour);
        DispenserMovementBehaviour.registerMovedDispenseItemBehaviour(Items.f_41996_, new MovedDefaultDispenseItemBehaviour(){

            @Override
            protected ItemStack dispenseStack(ItemStack itemStack, MovementContext context, BlockPos pos, Vec3 facing) {
                double x = (double)pos.m_123341_() + facing.f_82479_ * 0.7 + 0.5;
                double y = (double)pos.m_123342_() + facing.f_82480_ * 0.7 + 0.5;
                double z = (double)pos.m_123343_() + facing.f_82481_ * 0.7 + 0.5;
                PrimedTnt tntentity = new PrimedTnt(context.world, x, y, z, null);
                tntentity.m_5997_(context.motion.f_82479_, context.motion.f_82480_, context.motion.f_82481_);
                context.world.m_7967_((Entity)tntentity);
                context.world.m_6263_(null, tntentity.m_20185_(), tntentity.m_20186_(), tntentity.m_20189_(), SoundEvents.f_12512_, SoundSource.BLOCKS, 1.0f, 1.0f);
                itemStack.m_41774_(1);
                return itemStack;
            }
        });
        DispenserMovementBehaviour.registerMovedDispenseItemBehaviour(Items.f_42688_, new MovedDefaultDispenseItemBehaviour(){

            @Override
            protected ItemStack dispenseStack(ItemStack itemStack, MovementContext context, BlockPos pos, Vec3 facing) {
                double x = (double)pos.m_123341_() + facing.f_82479_ * 0.7 + 0.5;
                double y = (double)pos.m_123342_() + facing.f_82480_ * 0.7 + 0.5;
                double z = (double)pos.m_123343_() + facing.f_82481_ * 0.7 + 0.5;
                FireworkRocketEntity fireworkrocketentity = new FireworkRocketEntity(context.world, itemStack, x, y, z, true);
                fireworkrocketentity.m_6686_(facing.f_82479_, facing.f_82480_, facing.f_82481_, 0.5f, 1.0f);
                context.world.m_7967_((Entity)fireworkrocketentity);
                itemStack.m_41774_(1);
                return itemStack;
            }

            @Override
            protected void playDispenseSound(LevelAccessor world, BlockPos pos) {
                world.m_46796_(1004, pos, 0);
            }
        });
        DispenserMovementBehaviour.registerMovedDispenseItemBehaviour(Items.f_42613_, new MovedDefaultDispenseItemBehaviour(){

            @Override
            protected void playDispenseSound(LevelAccessor world, BlockPos pos) {
                world.m_46796_(1018, pos, 0);
            }

            @Override
            protected ItemStack dispenseStack(ItemStack itemStack, MovementContext context, BlockPos pos, Vec3 facing) {
                Random random = context.world.f_46441_;
                double x = (double)pos.m_123341_() + facing.f_82479_ * 0.7 + 0.5;
                double y = (double)pos.m_123342_() + facing.f_82480_ * 0.7 + 0.5;
                double z = (double)pos.m_123343_() + facing.f_82481_ * 0.7 + 0.5;
                context.world.m_7967_((Entity)Util.m_137469_((Object)new SmallFireball(context.world, x, y, z, random.nextGaussian() * 0.05 + facing.f_82479_ + context.motion.f_82479_, random.nextGaussian() * 0.05 + facing.f_82480_ + context.motion.f_82480_, random.nextGaussian() * 0.05 + facing.f_82481_ + context.motion.f_82481_), p_229425_1_ -> p_229425_1_.m_37010_(itemStack)));
                itemStack.m_41774_(1);
                return itemStack;
            }
        });
        DispenserMovementBehaviour.registerMovedDispenseItemBehaviour(Items.f_42590_, new MovedOptionalDispenseBehaviour(){

            @Override
            protected ItemStack dispenseStack(ItemStack itemStack, MovementContext context, BlockPos pos, Vec3 facing) {
                this.successful = false;
                BlockPos interactAt = pos.m_142300_(this.getClosestFacingDirection(facing));
                BlockState state = context.world.m_8055_(interactAt);
                Block block = state.m_60734_();
                if (state.m_60620_((Tag)BlockTags.f_13072_) && (Integer)state.m_61143_((Property)BeehiveBlock.f_49564_) >= 5) {
                    ((BeehiveBlock)block).m_49594_(context.world, state, interactAt, null, BeehiveBlockEntity.BeeReleaseStatus.BEE_RELEASED);
                    this.successful = true;
                    return this.placeItemInInventory(itemStack, new ItemStack((ItemLike)Items.f_42787_), context, pos, facing);
                }
                if (context.world.m_6425_(interactAt).m_76153_((Tag)FluidTags.f_13131_)) {
                    this.successful = true;
                    return this.placeItemInInventory(itemStack, PotionUtils.m_43549_((ItemStack)new ItemStack((ItemLike)Items.f_42589_), (Potion)Potions.f_43599_), context, pos, facing);
                }
                return super.dispenseStack(itemStack, context, pos, facing);
            }
        });
        DispenserMovementBehaviour.registerMovedDispenseItemBehaviour(Items.f_42446_, new MovedDefaultDispenseItemBehaviour(){

            @Override
            protected ItemStack dispenseStack(ItemStack itemStack, MovementContext context, BlockPos pos, Vec3 facing) {
                BlockPos interactAt = pos.m_142300_(this.getClosestFacingDirection(facing));
                BlockState state = context.world.m_8055_(interactAt);
                Block block = state.m_60734_();
                if (block instanceof BucketPickup) {
                    ItemStack bucket = ((BucketPickup)block).m_142598_((LevelAccessor)context.world, interactAt, state);
                    return this.placeItemInInventory(itemStack, bucket, context, pos, facing);
                }
                return super.dispenseStack(itemStack, context, pos, facing);
            }
        });
    }

    public ItemStack dispense(ItemStack var1, MovementContext var2, BlockPos var3);
}

