/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.components.structureMovement;

import com.jozufozu.flywheel.light.GPULightVolume;
import com.jozufozu.flywheel.light.LightListener;
import com.jozufozu.flywheel.light.LightProvider;
import com.jozufozu.flywheel.light.LightUpdater;
import com.jozufozu.flywheel.light.ListenerStatus;
import com.jozufozu.flywheel.util.box.GridAlignedBB;
import com.jozufozu.flywheel.util.box.ImmutableBox;
import com.simibubi.create.content.contraptions.components.structureMovement.Contraption;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.LightLayer;

public abstract class ContraptionLighter<C extends Contraption>
implements LightListener {
    protected final C contraption;
    public final GPULightVolume lightVolume;
    protected final LightUpdater lightUpdater;
    protected final GridAlignedBB bounds;
    protected boolean scheduleRebuild;

    protected ContraptionLighter(C contraption) {
        this.contraption = contraption;
        this.lightUpdater = LightUpdater.get((BlockAndTintGetter)((Contraption)contraption).entity.f_19853_);
        this.bounds = this.getContraptionBounds();
        this.growBoundsForEdgeData();
        this.lightVolume = new GPULightVolume((ImmutableBox)this.bounds);
        this.lightVolume.initialize(this.lightUpdater.getProvider());
        this.scheduleRebuild = true;
        this.lightUpdater.addListener((LightListener)this);
    }

    public abstract GridAlignedBB getContraptionBounds();

    public ListenerStatus status() {
        return ListenerStatus.OKAY;
    }

    public void onLightUpdate(LightProvider world, LightLayer type, ImmutableBox changed) {
        this.lightVolume.onLightUpdate(world, type, changed);
    }

    public void onLightPacket(LightProvider world, int chunkX, int chunkZ) {
        this.lightVolume.onLightPacket(world, chunkX, chunkZ);
    }

    protected void growBoundsForEdgeData() {
        this.bounds.grow(2);
    }

    public ImmutableBox getVolume() {
        return this.bounds;
    }

    public void delete() {
        this.lightUpdater.removeListener((LightListener)this);
        this.lightVolume.delete();
    }
}

