/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.components.structureMovement.bearing;

import com.simibubi.create.content.contraptions.components.structureMovement.AssemblyException;
import com.simibubi.create.content.contraptions.components.structureMovement.Contraption;
import com.simibubi.create.content.contraptions.components.structureMovement.ContraptionLighter;
import com.simibubi.create.content.contraptions.components.structureMovement.ContraptionType;
import com.simibubi.create.content.contraptions.components.structureMovement.bearing.AnchoredLighter;
import com.simibubi.create.foundation.utility.NBTHelper;
import java.util.HashSet;
import java.util.Queue;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.commons.lang3.tuple.Pair;

public class ClockworkContraption
extends Contraption {
    protected Direction facing;
    public HandType handType;
    public int offset;
    private Set<BlockPos> ignoreBlocks = new HashSet<BlockPos>();

    @Override
    protected ContraptionType getType() {
        return ContraptionType.CLOCKWORK;
    }

    private void ignoreBlocks(Set<BlockPos> blocks, BlockPos anchor) {
        for (BlockPos blockPos : blocks) {
            this.ignoreBlocks.add(anchor.m_141952_((Vec3i)blockPos));
        }
    }

    @Override
    protected boolean isAnchoringBlockAt(BlockPos pos) {
        return pos.equals((Object)this.anchor.m_5484_(this.facing.m_122424_(), this.offset + 1));
    }

    public static Pair<ClockworkContraption, ClockworkContraption> assembleClockworkAt(Level world, BlockPos pos, Direction direction) throws AssemblyException {
        int hourArmBlocks = 0;
        ClockworkContraption hourArm = new ClockworkContraption();
        ClockworkContraption minuteArm = null;
        hourArm.facing = direction;
        hourArm.handType = HandType.HOUR;
        if (!hourArm.assemble(world, pos)) {
            return null;
        }
        for (int i = 0; i < 16; ++i) {
            BlockPos offsetPos = BlockPos.f_121853_.m_5484_(direction, i);
            if (hourArm.getBlocks().containsKey(offsetPos)) continue;
            hourArmBlocks = i;
            break;
        }
        if (hourArmBlocks > 0) {
            minuteArm = new ClockworkContraption();
            minuteArm.facing = direction;
            minuteArm.handType = HandType.MINUTE;
            minuteArm.offset = hourArmBlocks;
            minuteArm.ignoreBlocks(hourArm.getBlocks().keySet(), hourArm.anchor);
            if (!minuteArm.assemble(world, pos)) {
                return null;
            }
            if (minuteArm.getBlocks().isEmpty()) {
                minuteArm = null;
            }
        }
        hourArm.startMoving(world);
        hourArm.expandBoundsAroundAxis(direction.m_122434_());
        if (minuteArm != null) {
            minuteArm.startMoving(world);
            minuteArm.expandBoundsAroundAxis(direction.m_122434_());
        }
        return Pair.of((Object)hourArm, (Object)minuteArm);
    }

    @Override
    public boolean assemble(Level world, BlockPos pos) throws AssemblyException {
        return this.searchMovedStructure(world, pos, this.facing);
    }

    @Override
    public boolean searchMovedStructure(Level world, BlockPos pos, Direction direction) throws AssemblyException {
        return super.searchMovedStructure(world, pos.m_5484_(direction, this.offset + 1), null);
    }

    @Override
    protected boolean moveBlock(Level world, Direction direction, Queue<BlockPos> frontier, Set<BlockPos> visited) throws AssemblyException {
        if (this.ignoreBlocks.contains(frontier.peek())) {
            frontier.poll();
            return true;
        }
        return super.moveBlock(world, direction, frontier, visited);
    }

    @Override
    public CompoundTag writeNBT(boolean spawnPacket) {
        CompoundTag tag = super.writeNBT(spawnPacket);
        tag.m_128405_("facing", this.facing.m_122411_());
        tag.m_128405_("offset", this.offset);
        NBTHelper.writeEnum(tag, "HandType", this.handType);
        return tag;
    }

    @Override
    public void readNBT(Level world, CompoundTag tag, boolean spawnData) {
        this.facing = Direction.m_122376_((int)tag.m_128451_("facing"));
        this.handType = NBTHelper.readEnum(tag, "HandType", HandType.class);
        this.offset = tag.m_128451_("offset");
        super.readNBT(world, tag, spawnData);
    }

    @Override
    public boolean canBeStabilized(Direction facing, BlockPos localPos) {
        if (BlockPos.f_121853_.equals((Object)localPos) || BlockPos.f_121853_.equals((Object)localPos.m_142300_(facing))) {
            return false;
        }
        return facing.m_122434_() == this.facing.m_122434_();
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public ContraptionLighter<?> makeLighter() {
        return new AnchoredLighter(this);
    }

    public static enum HandType {
        HOUR,
        MINUTE;

    }
}

