/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.fluids.actors;

import com.simibubi.create.content.contraptions.fluids.actors.ItemDrainItemHandler;
import com.simibubi.create.content.contraptions.goggles.IHaveGoggleInformation;
import com.simibubi.create.content.contraptions.processing.EmptyingByBasin;
import com.simibubi.create.content.contraptions.relays.belt.transport.TransportedItemStack;
import com.simibubi.create.foundation.advancement.AllTriggers;
import com.simibubi.create.foundation.tileEntity.SmartTileEntity;
import com.simibubi.create.foundation.tileEntity.TileEntityBehaviour;
import com.simibubi.create.foundation.tileEntity.behaviour.belt.DirectBeltInputBehaviour;
import com.simibubi.create.foundation.tileEntity.behaviour.fluid.SmartFluidTankBehaviour;
import com.simibubi.create.foundation.utility.BlockHelper;
import com.simibubi.create.foundation.utility.Iterate;
import com.simibubi.create.foundation.utility.Pair;
import com.simibubi.create.foundation.utility.VecHelper;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.ItemHandlerHelper;

public class ItemDrainTileEntity
extends SmartTileEntity
implements IHaveGoggleInformation {
    public static final int FILLING_TIME = 20;
    SmartFluidTankBehaviour internalTank;
    TransportedItemStack heldItem;
    protected int processingTicks;
    Map<Direction, LazyOptional<ItemDrainItemHandler>> itemHandlers = new IdentityHashMap<Direction, LazyOptional<ItemDrainItemHandler>>();

    public ItemDrainTileEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        for (Direction d : Iterate.horizontalDirections) {
            ItemDrainItemHandler itemDrainItemHandler = new ItemDrainItemHandler(this, d);
            this.itemHandlers.put(d, (LazyOptional<ItemDrainItemHandler>)LazyOptional.of(() -> itemDrainItemHandler));
        }
    }

    @Override
    public void addBehaviours(List<TileEntityBehaviour> behaviours) {
        behaviours.add(new DirectBeltInputBehaviour(this).allowingBeltFunnels().setInsertionHandler(this::tryInsertingFromSide));
        this.internalTank = SmartFluidTankBehaviour.single(this, 1500).allowExtraction().forbidInsertion();
        behaviours.add(this.internalTank);
    }

    private ItemStack tryInsertingFromSide(TransportedItemStack transportedStack, Direction side, boolean simulate) {
        ItemStack inserted = transportedStack.stack;
        ItemStack returned = ItemStack.f_41583_;
        if (!this.getHeldItemStack().m_41619_()) {
            return inserted;
        }
        if (inserted.m_41613_() > 1 && EmptyingByBasin.canItemBeEmptied(this.f_58857_, inserted)) {
            returned = ItemHandlerHelper.copyStackWithSize((ItemStack)inserted, (int)(inserted.m_41613_() - 1));
            inserted = ItemHandlerHelper.copyStackWithSize((ItemStack)inserted, (int)1);
        }
        if (simulate) {
            return returned;
        }
        transportedStack = transportedStack.copy();
        transportedStack.beltPosition = side.m_122434_().m_122478_() ? 0.5f : 0.0f;
        transportedStack.prevSideOffset = transportedStack.sideOffset;
        transportedStack.prevBeltPosition = transportedStack.beltPosition;
        this.setHeldItem(transportedStack, side);
        this.m_6596_();
        this.sendData();
        return returned;
    }

    public ItemStack getHeldItemStack() {
        return this.heldItem == null ? ItemStack.f_41583_ : this.heldItem.stack;
    }

    @Override
    public void tick() {
        boolean onClient;
        super.tick();
        if (this.heldItem == null) {
            this.processingTicks = 0;
            return;
        }
        boolean bl = onClient = this.f_58857_.f_46443_ && !this.isVirtual();
        if (this.processingTicks > 0) {
            boolean wasAtBeginning;
            this.heldItem.prevBeltPosition = 0.5f;
            boolean bl2 = wasAtBeginning = this.processingTicks == 20;
            if (!onClient || this.processingTicks < 20) {
                --this.processingTicks;
            }
            if (!this.continueProcessing()) {
                this.processingTicks = 0;
                this.notifyUpdate();
                return;
            }
            if (wasAtBeginning != (this.processingTicks == 20)) {
                this.sendData();
            }
            return;
        }
        this.heldItem.prevBeltPosition = this.heldItem.beltPosition;
        this.heldItem.prevSideOffset = this.heldItem.sideOffset;
        this.heldItem.beltPosition += this.itemMovementPerTick();
        if (this.heldItem.beltPosition > 1.0f) {
            BlockPos nextPosition;
            DirectBeltInputBehaviour directBeltInputBehaviour;
            this.heldItem.beltPosition = 1.0f;
            if (onClient) {
                return;
            }
            Direction side = this.heldItem.insertedFrom;
            ItemStack tryExportingToBeltFunnel = this.getBehaviour(DirectBeltInputBehaviour.TYPE).tryExportingToBeltFunnel(this.heldItem.stack, side.m_122424_(), false);
            if (tryExportingToBeltFunnel != null) {
                if (tryExportingToBeltFunnel.m_41613_() != this.heldItem.stack.m_41613_()) {
                    if (tryExportingToBeltFunnel.m_41619_()) {
                        this.heldItem = null;
                    } else {
                        this.heldItem.stack = tryExportingToBeltFunnel;
                    }
                    this.notifyUpdate();
                    return;
                }
                if (!tryExportingToBeltFunnel.m_41619_()) {
                    return;
                }
            }
            if ((directBeltInputBehaviour = TileEntityBehaviour.get((BlockGetter)this.f_58857_, nextPosition = this.f_58858_.m_142300_(side), DirectBeltInputBehaviour.TYPE)) == null) {
                if (!BlockHelper.hasBlockSolidSide(this.f_58857_.m_8055_(nextPosition), (BlockGetter)this.f_58857_, nextPosition, side.m_122424_())) {
                    ItemStack ejected = this.heldItem.stack;
                    Vec3 outPos = VecHelper.getCenterOf((Vec3i)this.f_58858_).m_82549_(Vec3.m_82528_((Vec3i)side.m_122436_()).m_82490_(0.75));
                    float movementSpeed = this.itemMovementPerTick();
                    Vec3 outMotion = Vec3.m_82528_((Vec3i)side.m_122436_()).m_82490_((double)movementSpeed).m_82520_(0.0, 0.125, 0.0);
                    outPos.m_82549_(outMotion.m_82541_());
                    ItemEntity entity = new ItemEntity(this.f_58857_, outPos.f_82479_, outPos.f_82480_ + 0.375, outPos.f_82481_, ejected);
                    entity.m_20256_(outMotion);
                    entity.m_32060_();
                    entity.f_19864_ = true;
                    this.f_58857_.m_7967_((Entity)entity);
                    this.heldItem = null;
                    this.notifyUpdate();
                }
                return;
            }
            if (!directBeltInputBehaviour.canInsertFromSide(side)) {
                return;
            }
            ItemStack returned = directBeltInputBehaviour.handleInsertion(this.heldItem.copy(), side, false);
            if (returned.m_41619_()) {
                if (this.f_58857_.m_7702_(nextPosition) instanceof ItemDrainTileEntity) {
                    AllTriggers.triggerForNearbyPlayers(AllTriggers.CHAINED_ITEM_DRAIN, (LevelAccessor)this.f_58857_, this.f_58858_, 5);
                }
                this.heldItem = null;
                this.notifyUpdate();
                return;
            }
            if (returned.m_41613_() != this.heldItem.stack.m_41613_()) {
                this.heldItem.stack = returned;
                this.notifyUpdate();
                return;
            }
            return;
        }
        if (this.heldItem.prevBeltPosition < 0.5f && this.heldItem.beltPosition >= 0.5f) {
            if (!EmptyingByBasin.canItemBeEmptied(this.f_58857_, this.heldItem.stack)) {
                return;
            }
            this.heldItem.beltPosition = 0.5f;
            if (onClient) {
                return;
            }
            this.processingTicks = 20;
            this.sendData();
        }
    }

    protected boolean continueProcessing() {
        if (this.f_58857_.f_46443_ && !this.isVirtual()) {
            return true;
        }
        if (this.processingTicks < 5) {
            return true;
        }
        if (!EmptyingByBasin.canItemBeEmptied(this.f_58857_, this.heldItem.stack)) {
            return false;
        }
        Pair<FluidStack, ItemStack> emptyItem = EmptyingByBasin.emptyItem(this.f_58857_, this.heldItem.stack, true);
        FluidStack fluidFromItem = emptyItem.getFirst();
        if (this.processingTicks > 5) {
            this.internalTank.allowInsertion();
            if (this.internalTank.getPrimaryHandler().fill(fluidFromItem, IFluidHandler.FluidAction.SIMULATE) != fluidFromItem.getAmount()) {
                this.internalTank.forbidInsertion();
                this.processingTicks = 20;
                return true;
            }
            this.internalTank.forbidInsertion();
            return true;
        }
        emptyItem = EmptyingByBasin.emptyItem(this.f_58857_, this.heldItem.stack.m_41777_(), false);
        AllTriggers.triggerForNearbyPlayers(AllTriggers.ITEM_DRAIN, (LevelAccessor)this.f_58857_, this.f_58858_, 5);
        ItemStack out = emptyItem.getSecond();
        if (!out.m_41619_()) {
            this.heldItem.stack = out;
        } else {
            this.heldItem = null;
        }
        this.internalTank.allowInsertion();
        this.internalTank.getPrimaryHandler().fill(fluidFromItem, IFluidHandler.FluidAction.EXECUTE);
        this.internalTank.forbidInsertion();
        this.notifyUpdate();
        return true;
    }

    private float itemMovementPerTick() {
        return 0.125f;
    }

    @Override
    public void m_7651_() {
        super.m_7651_();
        for (LazyOptional<ItemDrainItemHandler> lazyOptional : this.itemHandlers.values()) {
            lazyOptional.invalidate();
        }
    }

    public void setHeldItem(TransportedItemStack heldItem, Direction insertedFrom) {
        this.heldItem = heldItem;
        this.heldItem.insertedFrom = insertedFrom;
    }

    @Override
    public void write(CompoundTag compound, boolean clientPacket) {
        compound.m_128405_("ProcessingTicks", this.processingTicks);
        if (this.heldItem != null) {
            compound.m_128365_("HeldItem", (Tag)this.heldItem.serializeNBT());
        }
        super.write(compound, clientPacket);
    }

    @Override
    protected void read(CompoundTag compound, boolean clientPacket) {
        this.heldItem = null;
        this.processingTicks = compound.m_128451_("ProcessingTicks");
        if (compound.m_128441_("HeldItem")) {
            this.heldItem = TransportedItemStack.read(compound.m_128469_("HeldItem"));
        }
        super.read(compound, clientPacket);
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (side != null && side.m_122434_().m_122479_() && this.isItemHandlerCap(cap)) {
            return this.itemHandlers.get(side).cast();
        }
        if (side != Direction.UP && this.isFluidHandlerCap(cap)) {
            return this.internalTank.getCapability().cast();
        }
        return super.getCapability(cap, side);
    }

    @Override
    public boolean addToGoggleTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        return this.containedFluidTooltip(tooltip, isPlayerSneaking, this.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY));
    }
}

